/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulator.variable.impl;

import java.util.ArrayList;
import java.util.List;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.Datatype;
import org.simantics.simulator.variable.NodeManager;
import org.simantics.simulator.variable.exceptions.NoSuchNodeException;
import org.simantics.simulator.variable.exceptions.NodeManagerException;

public abstract class AbstractNodeManager<Node>
implements NodeManager<Node> {
    @Override
    public List<String> getChildNames(Node node) throws NodeManagerException {
        List<Node> children = this.getChildren(node);
        ArrayList<String> names = new ArrayList<String>(children.size());
        for (Node child : children) {
            names.add(this.getName(child));
        }
        return names;
    }

    @Override
    public List<String> getPropertyNames(Node node) throws NodeManagerException {
        List<Node> properties = this.getProperties(node);
        ArrayList<String> names = new ArrayList<String>(properties.size());
        for (Node property : properties) {
            names.add(this.getName(property));
        }
        return names;
    }

    @Override
    public Object getValue(Node node, String propertyName, Binding binding) throws NodeManagerException {
        Node property = this.getProperty(node, propertyName);
        if (property == null) {
            throw new NoSuchNodeException("Didn't find a property " + propertyName);
        }
        return this.getValue(property, binding);
    }

    @Override
    public void setValue(Node node, String propertyName, Object value, Binding binding) throws NodeManagerException {
        Node property = this.getProperty(node, propertyName);
        if (property == null) {
            throw new NoSuchNodeException("Didn't find a property " + propertyName);
        }
        this.setValue(property, value, binding);
    }

    @Override
    public Variant getValue(Node node) throws NodeManagerException {
        Datatype datatype = this.getDatatype(node);
        Binding binding = Bindings.getBinding((Datatype)datatype);
        Object value = this.getValue(node, binding);
        return new Variant(binding, value);
    }

    @Override
    public Variant getValue(Node node, String propertyName) throws NodeManagerException {
        Node property = this.getProperty(node, propertyName);
        if (property == null) {
            throw new NoSuchNodeException("Didn't find a property " + propertyName);
        }
        return this.getValue(property);
    }

    @Override
    public String getPropertyURI(Node parent, Node property) {
        return null;
    }
}

