/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.jfree.xml.util.AttributeDefinition;
import org.jfree.xml.util.BasicTypeSupport;
import org.jfree.xml.util.ConstructorDefinition;
import org.jfree.xml.util.LookupDefinition;
import org.jfree.xml.util.ObjectDescriptionException;
import org.jfree.xml.util.PropertyDefinition;

public final class GenericObjectFactory {
    private final ConstructorDefinition[] constructorDefinitions;
    private final PropertyDefinition[] propertyDefinitions;
    private final LookupDefinition[] lookupDefinitions;
    private final AttributeDefinition[] attributeDefinitions;
    private final String[] orderedPropertyNames;
    private final HashMap propertyInfos;
    private final HashMap propertyValues;
    private final Class baseClass;
    private final String registerName;

    public GenericObjectFactory(Class c, String registerName, ConstructorDefinition[] constructors, PropertyDefinition[] propertyDefinitions, LookupDefinition[] lookupDefinitions, AttributeDefinition[] attributeDefinitions, String[] orderedPropertyNames) throws ObjectDescriptionException {
        if (c == null) {
            throw new NullPointerException("BaseClass cannot be null.");
        }
        this.baseClass = c;
        this.registerName = registerName;
        this.propertyInfos = new HashMap();
        this.propertyValues = new HashMap();
        this.constructorDefinitions = constructors;
        this.propertyDefinitions = propertyDefinitions;
        this.lookupDefinitions = lookupDefinitions;
        this.attributeDefinitions = attributeDefinitions;
        this.orderedPropertyNames = orderedPropertyNames;
        try {
            BeanInfo chartBeaninfo = Introspector.getBeanInfo(c, Object.class);
            PropertyDescriptor[] pd = chartBeaninfo.getPropertyDescriptors();
            int i = 0;
            while (i < pd.length) {
                this.propertyInfos.put(pd[i].getName(), pd[i]);
                ++i;
            }
        }
        catch (IntrospectionException introspectionException) {
            throw new ObjectDescriptionException("This is an ugly solution right now ... dirty hack attack");
        }
    }

    private GenericObjectFactory(GenericObjectFactory factory) {
        this.baseClass = factory.baseClass;
        this.propertyValues = new HashMap();
        this.orderedPropertyNames = factory.orderedPropertyNames;
        this.constructorDefinitions = factory.constructorDefinitions;
        this.propertyDefinitions = factory.propertyDefinitions;
        this.attributeDefinitions = factory.attributeDefinitions;
        this.propertyInfos = factory.propertyInfos;
        this.registerName = factory.registerName;
        this.lookupDefinitions = factory.lookupDefinitions;
    }

    public GenericObjectFactory getInstance() {
        return new GenericObjectFactory(this);
    }

    public String getRegisterName() {
        return this.registerName;
    }

    private PropertyDescriptor getPropertyDescriptor(String propertyName) {
        return (PropertyDescriptor)this.propertyInfos.get(propertyName);
    }

    public Class getTypeForTagName(String tagName) throws ObjectDescriptionException {
        PropertyDefinition pdef = this.getPropertyDefinitionByTagName(tagName);
        PropertyDescriptor pdescr = this.getPropertyDescriptor(pdef.getPropertyName());
        if (pdescr == null) {
            throw new ObjectDescriptionException("Invalid Definition: " + pdef.getPropertyName());
        }
        return pdescr.getPropertyType();
    }

    public boolean isPropertyDefinition(String propertyName) {
        int i = 0;
        while (i < this.propertyDefinitions.length) {
            PropertyDefinition pdef = this.propertyDefinitions[i];
            if (pdef.getPropertyName().equals(propertyName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public PropertyDefinition getPropertyDefinitionByPropertyName(String propertyName) throws ObjectDescriptionException {
        int i = 0;
        while (i < this.propertyDefinitions.length) {
            PropertyDefinition pdef = this.propertyDefinitions[i];
            if (pdef.getPropertyName().equals(propertyName)) {
                return pdef;
            }
            ++i;
        }
        throw new ObjectDescriptionException("This property is not defined for this kind of object. : " + propertyName);
    }

    public PropertyDefinition getPropertyDefinitionByTagName(String tagName) throws ObjectDescriptionException {
        int i = 0;
        while (i < this.propertyDefinitions.length) {
            PropertyDefinition pdef = this.propertyDefinitions[i];
            if (pdef.getElementName().equals(tagName)) {
                return pdef;
            }
            ++i;
        }
        throw new ObjectDescriptionException("This tag is not defined for this kind of object. : " + tagName);
    }

    public ConstructorDefinition[] getConstructorDefinitions() {
        return this.constructorDefinitions;
    }

    public AttributeDefinition[] getAttributeDefinitions() {
        return this.attributeDefinitions;
    }

    public PropertyDefinition[] getPropertyDefinitions() {
        return this.propertyDefinitions;
    }

    public String[] getOrderedPropertyNames() {
        return this.orderedPropertyNames;
    }

    public LookupDefinition[] getLookupDefinitions() {
        return this.lookupDefinitions;
    }

    public Object getProperty(String name) {
        return this.propertyValues.get(name);
    }

    public Object createObject() throws ObjectDescriptionException {
        Class[] cArgs = new Class[this.constructorDefinitions.length];
        Object[] oArgs = new Object[this.constructorDefinitions.length];
        int i = 0;
        while (i < cArgs.length) {
            ConstructorDefinition cDef = this.constructorDefinitions[i];
            cArgs[i] = cDef.getType();
            oArgs[i] = cDef.isNull() ? null : this.getProperty(cDef.getPropertyName());
            ++i;
        }
        try {
            Constructor constr = this.baseClass.getConstructor(cArgs);
            Object o = constr.newInstance(oArgs);
            return o;
        }
        catch (Exception e) {
            throw new ObjectDescriptionException("Ugh! Constructor made a buuuh!", e);
        }
    }

    public void setProperty(String propertyName, Object value) throws ObjectDescriptionException {
        PropertyDescriptor pdesc = this.getPropertyDescriptor(propertyName);
        if (pdesc == null) {
            throw new ObjectDescriptionException("Unknown property " + propertyName);
        }
        if (!this.isAssignableOrPrimitive(pdesc.getPropertyType(), value.getClass())) {
            throw new ObjectDescriptionException("Invalid value: " + pdesc.getPropertyType() + " vs. " + value.getClass());
        }
        this.propertyValues.put(propertyName, value);
    }

    private boolean isAssignableOrPrimitive(Class baseType, Class valueType) {
        if (BasicTypeSupport.isBasicDataType(baseType)) {
            return true;
        }
        return baseType.isAssignableFrom(valueType);
    }

    private boolean isConstructorProperty(String propertyName) {
        int i = 0;
        while (i < this.constructorDefinitions.length) {
            ConstructorDefinition cDef = this.constructorDefinitions[i];
            if (propertyName.equals(cDef.getPropertyName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void writeObjectProperties(Object object) throws ObjectDescriptionException {
        int i = 0;
        while (i < this.orderedPropertyNames.length) {
            try {
                Object value;
                String name = this.orderedPropertyNames[i];
                if (!this.isConstructorProperty(name) && (value = this.getProperty(name)) != null) {
                    PropertyDescriptor pdescr = this.getPropertyDescriptor(name);
                    Method setter = pdescr.getWriteMethod();
                    setter.invoke(object, value);
                }
            }
            catch (Exception e) {
                throw new ObjectDescriptionException("Failed to set properties." + this.getBaseClass(), e);
            }
            ++i;
        }
    }

    public void readProperties(Object object) throws ObjectDescriptionException {
        int i = 0;
        while (i < this.orderedPropertyNames.length) {
            try {
                String name = this.orderedPropertyNames[i];
                PropertyDescriptor pdescr = this.getPropertyDescriptor(name);
                if (pdescr == null) {
                    throw new IllegalStateException("No property defined: " + name);
                }
                Method setter = pdescr.getReadMethod();
                Object value = setter.invoke(object, new Object[0]);
                if (value != null) {
                    this.setProperty(name, value);
                }
            }
            catch (Exception e) {
                throw new ObjectDescriptionException("Failed to set properties.", e);
            }
            ++i;
        }
    }

    public Class getBaseClass() {
        return this.baseClass;
    }
}

