/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.parser.coretypes;

import java.awt.BasicStroke;
import java.util.StringTokenizer;
import org.jfree.xml.parser.AbstractXmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BasicStrokeReadHandler
extends AbstractXmlReadHandler {
    private BasicStroke stroke;

    @Override
    protected void startParsing(Attributes attrs) throws SAXException {
        int endCap = Integer.parseInt(attrs.getValue("endCap"));
        int lineJoin = Integer.parseInt(attrs.getValue("lineJoin"));
        float lineWidth = Float.parseFloat(attrs.getValue("lineWidth"));
        float miterLimit = Float.parseFloat(attrs.getValue("miterLimit"));
        String dashArrayAttrib = attrs.getValue("dashArray");
        if (dashArrayAttrib != null) {
            float[] dashArray = this.parseDashArray(dashArrayAttrib);
            float dashPhase = Float.parseFloat(attrs.getValue("dashPhase"));
            this.stroke = new BasicStroke(lineWidth, endCap, lineJoin, miterLimit, dashArray, dashPhase);
        } else {
            this.stroke = new BasicStroke(lineWidth, endCap, lineJoin, miterLimit);
        }
    }

    private float[] parseDashArray(String string) {
        StringTokenizer tokenizer = new StringTokenizer(string, ",");
        float[] retVal = new float[tokenizer.countTokens()];
        int i = 0;
        while (i < retVal.length) {
            retVal[i] = Float.parseFloat(tokenizer.nextToken());
            ++i;
        }
        return retVal;
    }

    @Override
    public Object getObject() {
        return this.stroke;
    }
}

