/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.factory.objects;

import java.net.URL;
import org.jfree.io.IOUtils;
import org.jfree.util.Log;
import org.jfree.xml.factory.objects.AbstractObjectDescription;
import org.jfree.xml.factory.objects.ObjectFactoryException;

public class URLObjectDescription
extends AbstractObjectDescription {
    public URLObjectDescription() {
        super(URL.class);
        this.setParameterDefinition("value", String.class);
    }

    @Override
    public Object createObject() {
        String o = (String)this.getParameter("value");
        String baseURL = this.getConfig().getConfigProperty("content-base");
        try {
            URL bURL = new URL(baseURL);
            return new URL(bURL, o);
        }
        catch (Exception e) {
            try {
                Log.warn("BaseURL is invalid: ", e);
                return new URL(o);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    @Override
    public void setParameterFromObject(Object o) throws ObjectFactoryException {
        if (!(o instanceof URL)) {
            throw new ObjectFactoryException("Is no instance of java.net.URL");
        }
        URL comp = (URL)o;
        String baseURL = this.getConfig().getConfigProperty("content-base");
        try {
            URL bURL = new URL(baseURL);
            this.setParameter("value", IOUtils.getInstance().createRelativeURL(comp, bURL));
        }
        catch (Exception e) {
            Log.warn("BaseURL is invalid: ", e);
        }
        this.setParameter("value", comp.toExternalForm());
    }
}

