/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.factory.objects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jfree.util.Log;
import org.jfree.xml.factory.objects.AbstractObjectDescription;
import org.jfree.xml.factory.objects.ObjectFactoryException;

public class CollectionObjectDescription
extends AbstractObjectDescription {
    public CollectionObjectDescription(Class c) {
        super(c);
        if (!Collection.class.isAssignableFrom(c)) {
            throw new ClassCastException("The given class is no Collection instance");
        }
    }

    private int parseParameterName(String name) {
        try {
            return Integer.parseInt(name);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    @Override
    public Class getParameterDefinition(String name) {
        if (name.equals("size")) {
            return Integer.TYPE;
        }
        int par = this.parseParameterName(name);
        if (par < 0) {
            return null;
        }
        return Object.class;
    }

    @Override
    public Iterator getParameterNames() {
        Integer size = (Integer)this.getParameter("size");
        if (size == null) {
            return this.getDefinedParameterNames();
        }
        ArrayList<String> l = new ArrayList<String>();
        l.add("size");
        int i = 0;
        while (i < size) {
            l.add(String.valueOf(i));
            ++i;
        }
        return l.iterator();
    }

    @Override
    public Object createObject() {
        try {
            Collection l = (Collection)this.getObjectClass().newInstance();
            int counter = 0;
            while (this.getParameterDefinition(String.valueOf(counter)) != null) {
                Object value = this.getParameter(String.valueOf(counter));
                if (value == null) break;
                l.add(value);
                ++counter;
            }
            return l;
        }
        catch (Exception ie) {
            Log.warn("Unable to instantiate Object", ie);
            return null;
        }
    }

    @Override
    public void setParameterFromObject(Object o) throws ObjectFactoryException {
        if (o == null) {
            throw new NullPointerException("Given object is null");
        }
        Class c = this.getObjectClass();
        if (!c.isInstance(o)) {
            throw new ObjectFactoryException("Object is no instance of " + c + "(is " + o.getClass() + ")");
        }
        Collection l = (Collection)o;
        Iterator it = l.iterator();
        int counter = 0;
        while (it.hasNext()) {
            Object ob = it.next();
            this.setParameter(String.valueOf(counter), ob);
            ++counter;
        }
    }
}

