/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.jfree.util.ArrayUtilities;
import org.jfree.util.Log;
import org.jfree.util.PublicCloneable;

public final class ObjectUtilities {
    public static final String THREAD_CONTEXT = "ThreadContext";
    public static final String CLASS_CONTEXT = "ClassContext";
    private static String classLoaderSource = "ThreadContext";
    private static ClassLoader classLoader;

    private ObjectUtilities() {
    }

    public static String getClassLoaderSource() {
        return classLoaderSource;
    }

    public static void setClassLoaderSource(String classLoaderSource) {
        ObjectUtilities.classLoaderSource = classLoaderSource;
    }

    public static boolean equal(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 != null) {
            return o1.equals(o2);
        }
        return false;
    }

    public static int hashCode(Object object) {
        int result = 0;
        if (object != null) {
            result = object.hashCode();
        }
        return result;
    }

    public static Object clone(Object object) throws CloneNotSupportedException {
        if (object == null) {
            throw new IllegalArgumentException("Null 'object' argument.");
        }
        if (object instanceof PublicCloneable) {
            PublicCloneable pc = (PublicCloneable)object;
            return pc.clone();
        }
        try {
            Method method = object.getClass().getMethod("clone", null);
            if (Modifier.isPublic(method.getModifiers())) {
                return method.invoke(object, null);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.warn("Object without clone() method is impossible.");
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.warn("Object.clone(): unable to call method.");
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.warn("Object without clone() method is impossible.");
        }
        throw new CloneNotSupportedException("Failed to clone.");
    }

    public static Collection deepClone(Collection collection) throws CloneNotSupportedException {
        if (collection == null) {
            throw new IllegalArgumentException("Null 'collection' argument.");
        }
        Collection result = (Collection)ObjectUtilities.clone(collection);
        result.clear();
        for (Object item : collection) {
            if (item != null) {
                result.add(ObjectUtilities.clone(item));
                continue;
            }
            result.add(null);
        }
        return result;
    }

    public static synchronized void setClassLoader(ClassLoader classLoader) {
        ObjectUtilities.classLoader = classLoader;
    }

    public static ClassLoader getClassLoader() {
        return classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getClassLoader(Class c) {
        Class<ObjectUtilities> clazz = ObjectUtilities.class;
        synchronized (ObjectUtilities.class) {
            ClassLoader threadLoader;
            if (classLoader != null) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return classLoader;
            }
            String localClassLoaderSource = classLoaderSource;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (THREAD_CONTEXT.equals(localClassLoaderSource) && (threadLoader = Thread.currentThread().getContextClassLoader()) != null) {
                return threadLoader;
            }
            ClassLoader applicationCL = c.getClassLoader();
            if (applicationCL == null) {
                return ClassLoader.getSystemClassLoader();
            }
            return applicationCL;
        }
    }

    public static URL getResource(String name, Class c) {
        ClassLoader cl = ObjectUtilities.getClassLoader(c);
        if (cl == null) {
            return null;
        }
        return cl.getResource(name);
    }

    public static URL getResourceRelative(String name, Class c) {
        ClassLoader cl = ObjectUtilities.getClassLoader(c);
        String cname = ObjectUtilities.convertName(name, c);
        if (cl == null) {
            return null;
        }
        return cl.getResource(cname);
    }

    /*
     * Unable to fully structure code
     */
    private static String convertName(String name, Class c) {
        if (!name.startsWith("/")) ** GOTO lbl4
        return name.substring(1);
lbl-1000:
        // 1 sources

        {
            c = c.getComponentType();
lbl4:
            // 2 sources

            ** while (c.isArray())
        }
lbl5:
        // 1 sources

        baseName = c.getName();
        index = baseName.lastIndexOf(46);
        if (index == -1) {
            return name;
        }
        pkgName = baseName.substring(0, index);
        return String.valueOf(pkgName.replace('.', '/')) + "/" + name;
    }

    public static InputStream getResourceAsStream(String name, Class context) {
        URL url = ObjectUtilities.getResource(name, context);
        if (url == null) {
            return null;
        }
        try {
            return url.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static InputStream getResourceRelativeAsStream(String name, Class context) {
        URL url = ObjectUtilities.getResourceRelative(name, context);
        if (url == null) {
            return null;
        }
        try {
            return url.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Object loadAndInstantiate(String className, Class source) {
        try {
            ClassLoader loader = ObjectUtilities.getClassLoader(source);
            Class<?> c = loader.loadClass(className);
            return c.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object loadAndInstantiate(String className, Class source, Class type) {
        try {
            ClassLoader loader = ObjectUtilities.getClassLoader(source);
            Class<?> c = loader.loadClass(className);
            if (type.isAssignableFrom(c)) {
                return c.newInstance();
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isJDK14() {
        try {
            ClassLoader loader = ObjectUtilities.getClassLoader(ObjectUtilities.class);
            if (loader != null) {
                try {
                    loader.loadClass("java.util.RandomAccess");
                    return true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return false;
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {}
        try {
            String version = System.getProperty("java.vm.specification.version");
            if (version == null) {
                return false;
            }
            String[] versions = ObjectUtilities.parseVersions(version);
            String[] target = new String[]{"1", "4"};
            return ArrayUtilities.compareVersionArrays((Comparable[])versions, (Comparable[])target) >= 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static String[] parseVersions(String version) {
        if (version == null) {
            return new String[0];
        }
        ArrayList<String> versions = new ArrayList<String>();
        StringTokenizer strtok = new StringTokenizer(version, ".");
        while (strtok.hasMoreTokens()) {
            versions.add(strtok.nextToken());
        }
        return versions.toArray(new String[versions.size()]);
    }
}

