/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.tests;

import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.VolatileImage;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JApplet;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RouteTerminal;
import org.simantics.diagram.connection.rendering.BasicConnectionStyle;
import org.simantics.diagram.connection.rendering.ConnectionStyle;
import org.simantics.diagram.connection.rendering.IRouteGraphRenderer;
import org.simantics.diagram.connection.rendering.StyledRouteGraphRenderer;
import org.simantics.diagram.connection.rendering.arrows.ILineEndStyle;
import org.simantics.diagram.connection.rendering.arrows.PlainExampleLineEndStyle;
import org.simantics.scenegraph.g2d.G2DFocusManager;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.events.EventDelegator;
import org.simantics.scenegraph.g2d.nodes.NavigationNode;
import org.simantics.scenegraph.g2d.nodes.connection.IRouteGraphListener;
import org.simantics.scenegraph.g2d.nodes.connection.RouteGraphChangeEvent;
import org.simantics.scenegraph.g2d.nodes.connection.RouteGraphNode;

public class TestRouteGraphNodeApplet
extends JApplet
implements Runnable {
    private static final long serialVersionUID = -2097427018689455381L;
    private static final int FPS = 60;
    protected VolatileImage backbuffer = null;
    protected boolean interrupted = false;
    Color LINE_COLOR1 = Color.RED;
    Color LINE_COLOR2 = Color.GREEN;
    Stroke LINE_STROKE = new BasicStroke(1.0f, 2, 2);
    Stroke ROUTE_LINE_STROKE = new BasicStroke(3.0f, 0, 2);
    G2DSceneGraph sg;
    RouteGraph rg;
    RouteGraphNode rgn;
    BasicConnectionStyle style = new BasicConnectionStyle(this.LINE_COLOR1, Color.BLACK, 3.0, this.LINE_STROKE, this.ROUTE_LINE_STROKE, 8.0);
    Timer timer = new Timer();
    TimerTask task = new TimerTask(){
        boolean toggle = false;

        @Override
        public void run() {
            TestRouteGraphNodeApplet.this.rgn.setRenderer((IRouteGraphRenderer)new StyledRouteGraphRenderer((ConnectionStyle)TestRouteGraphNodeApplet.this.style));
            this.toggle ^= true;
        }
    };

    @Override
    public void init() {
        this.setSize(600, 600);
        this.setFocusable(true);
        this.setFocusCycleRoot(true);
        this.enableInputMethods(true);
        this.enableEvents(142397L);
        this.backbuffer = this.createVolatileImage(this.getWidth(), this.getHeight());
        this.rg = new RouteGraph();
        RouteLine v = this.rg.addLine(false, 0.0);
        v.setData((Object)"L1");
        this.rg.link(TestRouteGraphNodeApplet.addTerminal("T1", this.rg, -100.0, -100.0, 1, (ILineEndStyle)PlainExampleLineEndStyle.INSTANCE), v);
        this.sg = new G2DSceneGraph();
        NavigationNode nav = this.sg.addNode("navigation", NavigationNode.class);
        G2DParentNode temp = nav.addNode("temp", G2DParentNode.class);
        temp.setTransform(AffineTransform.getTranslateInstance(50.0, 50.0));
        this.rgn = temp.addNode("rg1", RouteGraphNode.class);
        this.rgn.setTransform(AffineTransform.getTranslateInstance(100.0, 100.0));
        this.rgn.setRouteGraph(this.rg);
        this.rgn.setRenderer((IRouteGraphRenderer)new StyledRouteGraphRenderer((ConnectionStyle)this.style));
        this.rgn.setRouteGraphListener(new IRouteGraphListener(){

            @Override
            public void routeGraphChanged(RouteGraphChangeEvent event) {
                event.node.getRouteGraphDelta().print();
            }
        });
        Thread t = new Thread(this);
        t.start();
        this.timer.schedule(this.task, 1000L, 1000L);
    }

    private static RouteTerminal addTerminal(Object data, RouteGraph rg, double x, double y, int allowedDirections, ILineEndStyle style) {
        RouteTerminal rt = rg.addTerminal(x, y, x - 20.0, y - 20.0, x + 20.0, y + 20.0, allowedDirections, style);
        rt.setData(data);
        return rt;
    }

    @Override
    public void run() {
        while (!this.interrupted) {
            this.repaint();
            long ival = 16L;
            try {
                Thread.sleep(ival);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void update(Graphics g) {
        int result = this.backbuffer.validate(this.getGraphicsConfiguration());
        if (result == 2) {
            this.backbuffer = this.createVolatileImage(this.getWidth(), this.getHeight());
        }
        Graphics2D g2d = this.backbuffer.createGraphics();
        g2d.clearRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setClip(0, 0, this.getWidth(), this.getHeight());
        this.sg.render(g2d);
        g2d.dispose();
        g.drawImage(this.backbuffer, 0, 0, this);
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public void processEvent(AWTEvent event) {
        if (event.getID() == 101) {
            this.backbuffer = this.createVolatileImage(this.getWidth(), this.getHeight());
            this.repaint();
        }
        EventDelegator handler = this.sg.getEventDelegator();
        switch (event.getID()) {
            case 501: {
                G2DFocusManager.INSTANCE.clearFocus();
                handler.mousePressed((MouseEvent)event);
                if (G2DFocusManager.INSTANCE.getFocusOwner() != null) break;
                this.requestFocusInWindow();
                break;
            }
            case 502: {
                handler.mouseReleased((MouseEvent)event);
                break;
            }
            case 500: {
                handler.mouseClicked((MouseEvent)event);
                break;
            }
            case 503: {
                handler.mouseMoved((MouseEvent)event);
                break;
            }
            case 506: {
                handler.mouseDragged((MouseEvent)event);
                break;
            }
            case 507: {
                handler.mouseWheelMoved((MouseWheelEvent)event);
                break;
            }
            case 504: {
                handler.mouseEntered((MouseEvent)event);
                break;
            }
            case 505: {
                handler.mouseExited((MouseEvent)event);
                break;
            }
            case 401: {
                handler.keyPressed((KeyEvent)event);
                break;
            }
            case 402: {
                handler.keyReleased((KeyEvent)event);
                break;
            }
            case 400: {
                handler.keyTyped((KeyEvent)event);
                break;
            }
            case 1004: {
                handler.focusGained((FocusEvent)event);
                break;
            }
            case 1005: {
                handler.focusLost((FocusEvent)event);
                break;
            }
        }
    }
}

