/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.tests;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.tests.Pair;

public class SceneGraphComparator {
    private Map<INode, INode> aChildrenDiffer = new HashMap<INode, INode>();
    private Map<INode, INode> bChildrenDiffer = new HashMap<INode, INode>();
    private Set<Pair<INode, INode>> different = new HashSet<Pair<INode, INode>>();
    private INode a;
    private INode b;

    public SceneGraphComparator(INode a, INode b) {
        this.a = a;
        this.b = b;
    }

    public void analyze() {
        this.analyze(this.a.getParent(), this.a, this.b.getParent(), this.b);
    }

    public boolean equal() {
        return this.aChildrenDiffer.isEmpty() && this.bChildrenDiffer.isEmpty() && this.different.isEmpty();
    }

    private void analyze(ParentNode<?> pa, INode a, ParentNode<?> pb, INode b) {
        block8: {
            Collection<String> bids;
            if (a == b) {
                return;
            }
            if (!this.equals(a, b)) {
                this.different.add(Pair.make(a, b));
                if (pa != null && pb != null) {
                    this.aChildrenDiffer.put(pa, pb);
                    this.bChildrenDiffer.put(pb, pa);
                }
                return;
            }
            if (!(a instanceof ParentNode)) break block8;
            ParentNode ppa = (ParentNode)a;
            ParentNode ppb = (ParentNode)b;
            Collection<String> aids = ppa.getNodeIds();
            if (!aids.equals(bids = ppb.getNodeIds())) {
                this.aChildrenDiffer.put(ppa, ppb);
                this.bChildrenDiffer.put(ppb, ppa);
            }
            if (a instanceof G2DParentNode) {
                IG2DNode[] sac = ((G2DParentNode)a).getSortedNodes();
                IG2DNode[] sbc = ((G2DParentNode)b).getSortedNodes();
                int i = 0;
                while (i < sac.length) {
                    this.analyze(ppa, sac[i], ppb, sbc[i]);
                    ++i;
                }
            } else {
                for (String id : aids) {
                    Object ac = ppa.getNode(id);
                    Object bc = ppb.getNode(id);
                    this.analyze(ppa, (INode)ac, ppb, (INode)bc);
                }
            }
        }
    }

    private boolean equals(INode a, INode b) {
        Class<?> clazz = a.getClass();
        return clazz.equals(b.getClass());
    }

    public String toString() {
        if (this.equal()) {
            return "no differences";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Differences between nodes:\n");
        for (Pair<INode, INode> p : this.different) {
            sb.append(((INode)p.first).getClass().getSimpleName()).append(p.first).append("\nvs.\n").append(((INode)p.second).getClass().getSimpleName()).append(p.second).append("\n");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        G2DSceneGraph sg1 = new G2DSceneGraph();
        G2DSceneGraph sg2 = new G2DSceneGraph();
        SceneGraphComparator sgc = new SceneGraphComparator(sg1, sg1);
        sgc.analyze();
        System.out.println(sgc);
        sgc = new SceneGraphComparator(sg1, sg2);
        sgc.analyze();
        System.out.println(sgc);
    }
}

