/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.tests;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.Assert;
import org.junit.Test;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.nodes.DataNode;
import org.simantics.scenegraph.g2d.nodes.NavigationNode;
import org.simantics.scenegraph.utils.NodeUtil;

public class LookupServiceTests {
    AtomicBoolean endTest;
    CyclicBarrier startBarrier;
    Semaphore ended;
    G2DSceneGraph root = new G2DSceneGraph();
    List<INode> nodes = new ArrayList<INode>();
    List<String> nodeIds = new ArrayList<String>();
    List<String> mappedIds = new ArrayList<String>();
    List<Throwable> errors = new ArrayList<Throwable>();

    <T extends INode> T addAndMapNode(ParentNode<?> parent, String id, Class<T> clazz) {
        INode node = (INode)parent.addNode(id, clazz);
        this.nodes.add(node);
        this.nodeIds.add(id);
        NodeUtil.map(node, id);
        return (T)node;
    }

    <T extends INode> T addNode(ParentNode<?> parent, String id, Class<T> clazz) {
        INode node = (INode)parent.addNode(id, clazz);
        this.nodes.add(node);
        this.nodeIds.add(id);
        return (T)node;
    }

    <T extends INode> T addNode(ParentNode<?> parent, Class<T> clazz) {
        return this.addNode(parent, UUID.randomUUID().toString(), clazz);
    }

    @Test
    public void testLookup() throws Exception {
        NavigationNode nav = this.addAndMapNode(this.root, "navigation", NavigationNode.class);
        DataNode data = this.addAndMapNode(this.root, "data", DataNode.class);
        G2DParentNode elements = this.addAndMapNode(nav, "elements", G2DParentNode.class);
        G2DParentNode ghosts = this.addAndMapNode(nav, "ghosts", G2DParentNode.class);
        Assert.assertSame((Object)nav, (Object)this.root.lookupNode("navigation"));
        Assert.assertSame((Object)data, (Object)this.root.lookupNode("data"));
        Assert.assertSame((Object)nav, (Object)NodeUtil.lookup(nav, "navigation"));
        Assert.assertSame((Object)data, (Object)NodeUtil.lookup(data, "data"));
        String id1 = UUID.randomUUID().toString();
        String id2 = UUID.randomUUID().toString();
        String id3_1 = UUID.randomUUID().toString();
        String id3_2 = UUID.randomUUID().toString();
        String id4 = UUID.randomUUID().toString();
        G2DParentNode e1 = this.addAndMapNode(elements, id1, G2DParentNode.class);
        G2DParentNode e2 = this.addAndMapNode(elements, id2, G2DParentNode.class);
        G2DParentNode e3 = this.addNode(elements, G2DParentNode.class);
        G2DParentNode e3_1 = this.addAndMapNode(e3, id3_1, G2DParentNode.class);
        G2DParentNode e3_2 = this.addAndMapNode(e3, id3_2, G2DParentNode.class);
        G2DParentNode e4 = this.addAndMapNode(elements, id4, G2DParentNode.class);
        Assert.assertSame((Object)e1, (Object)NodeUtil.lookup(e1, id1));
        Assert.assertSame((Object)e2, (Object)NodeUtil.lookup(e2, id2));
        Assert.assertSame((Object)e3_1, (Object)NodeUtil.lookup(e3_1, id3_1));
        Assert.assertSame((Object)e3_2, (Object)NodeUtil.lookup(e3_2, id3_2));
        Assert.assertSame((Object)e4, (Object)NodeUtil.lookup(e4, id4));
    }
}

