/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.tests;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.Assert;
import org.junit.Test;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.nodes.DataNode;
import org.simantics.scenegraph.g2d.nodes.NavigationNode;
import org.simantics.scenegraph.utils.NodeUtil;

public class LookupServiceSynchronizationTest {
    public static final int ITERATIONS = 10;
    public static final int ITERATION_TIME_MS = 1000;
    public static final int THREADS = 16;
    AtomicBoolean endTest;
    CyclicBarrier startBarrier;
    Semaphore ended;
    G2DSceneGraph root = new G2DSceneGraph();
    List<INode> nodes = new ArrayList<INode>();
    List<String> nodeIds = new ArrayList<String>();
    List<String> mappedIds = new ArrayList<String>();
    List<Throwable> errors = new ArrayList<Throwable>();

    <T extends INode> T addAndMapNode(ParentNode<?> parent, String id, Class<T> clazz) {
        INode node = (INode)parent.addNode(id, clazz);
        this.nodes.add(node);
        this.nodeIds.add(id);
        NodeUtil.map(node, id);
        return (T)node;
    }

    <T extends INode> T addNode(ParentNode<?> parent, String id, Class<T> clazz) {
        INode node = (INode)parent.addNode(id, clazz);
        this.nodes.add(node);
        this.nodeIds.add(id);
        return (T)node;
    }

    <T extends INode> T addNode(ParentNode<?> parent, Class<T> clazz) {
        return this.addNode(parent, UUID.randomUUID().toString(), clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLookup() throws Exception {
        NavigationNode nav = this.addAndMapNode(this.root, "navigation", NavigationNode.class);
        DataNode data = this.addAndMapNode(this.root, "data", DataNode.class);
        G2DParentNode elements = this.addNode(nav, "elements", G2DParentNode.class);
        G2DParentNode ghosts = this.addNode(nav, "ghosts", G2DParentNode.class);
        Assert.assertSame((Object)nav, (Object)this.root.lookupNode("navigation"));
        Assert.assertSame((Object)data, (Object)this.root.lookupNode("data"));
        Assert.assertSame((Object)nav, (Object)NodeUtil.lookup(nav, "navigation"));
        Assert.assertSame((Object)data, (Object)NodeUtil.lookup(data, "data"));
        int iter = 1;
        while (iter <= 10) {
            System.out.println("Starting iteration " + iter);
            System.out.flush();
            this.endTest = new AtomicBoolean(false);
            this.startBarrier = new CyclicBarrier(33);
            this.ended = new Semaphore(0);
            int i = 0;
            while (i < 16) {
                String id = UUID.randomUUID().toString();
                G2DParentNode node = this.addNode(elements, id, G2DParentNode.class);
                new Thread((Runnable)new Mapper(id, node), "Mapper-" + i).start();
                new Thread((Runnable)new Lookup(id, node), "Lookup-" + i).start();
                ++i;
            }
            this.startBarrier.await();
            LookupServiceSynchronizationTest lookupServiceSynchronizationTest = this;
            synchronized (lookupServiceSynchronizationTest) {
                this.wait(1000L);
            }
            System.out.println("Ending iteration " + iter);
            System.out.flush();
            this.endTest.set(true);
            this.ended.acquire(32);
            System.out.println("Iteration " + iter + " ended");
            ++iter;
        }
        Assert.assertEquals((int)this.errors.size(), (int)0);
    }

    public class Lookup
    implements Runnable {
        String id;
        INode node;

        public Lookup(String id, INode node) {
            this.id = id;
            this.node = node;
        }

        @Override
        public void run() {
            try {
                try {
                    System.out.println("started " + Thread.currentThread().getName());
                    System.out.flush();
                    LookupServiceSynchronizationTest.this.startBarrier.await();
                    while (!LookupServiceSynchronizationTest.this.endTest.get()) {
                        Thread.yield();
                        INode n = NodeUtil.lookup(this.node, this.id);
                        String id = NodeUtil.lookupId(this.node);
                        if (n != null) {
                            Assert.assertSame((Object)this.node, (Object)n);
                        }
                        if (id == null) continue;
                        Assert.assertSame((Object)this.id, (Object)id);
                    }
                }
                catch (InterruptedException e) {
                    LookupServiceSynchronizationTest.this.errors.add(e);
                    System.out.println("ending " + Thread.currentThread().getName());
                    System.out.flush();
                    LookupServiceSynchronizationTest.this.ended.release();
                }
                catch (BrokenBarrierException e) {
                    LookupServiceSynchronizationTest.this.errors.add(e);
                    System.out.println("ending " + Thread.currentThread().getName());
                    System.out.flush();
                    LookupServiceSynchronizationTest.this.ended.release();
                }
            }
            finally {
                System.out.println("ending " + Thread.currentThread().getName());
                System.out.flush();
                LookupServiceSynchronizationTest.this.ended.release();
            }
        }
    }

    public class Mapper
    implements Runnable {
        String id;
        INode node;

        public Mapper(String id, INode node) {
            this.id = id;
            this.node = node;
        }

        @Override
        public void run() {
            try {
                try {
                    System.out.println("started " + Thread.currentThread().getName());
                    System.out.flush();
                    LookupServiceSynchronizationTest.this.startBarrier.await();
                    int i = 0;
                    while (!LookupServiceSynchronizationTest.this.endTest.get()) {
                        Thread.yield();
                        NodeUtil.map(this.node, this.id);
                        if (!(i & true)) {
                            NodeUtil.unmap(this.node);
                        } else {
                            LookupServiceSynchronizationTest.this.root.unmap(this.id);
                        }
                        ++i;
                    }
                }
                catch (InterruptedException e) {
                    LookupServiceSynchronizationTest.this.errors.add(e);
                    System.out.println("ending " + Thread.currentThread().getName());
                    System.out.flush();
                    LookupServiceSynchronizationTest.this.ended.release();
                }
                catch (BrokenBarrierException e) {
                    LookupServiceSynchronizationTest.this.errors.add(e);
                    System.out.println("ending " + Thread.currentThread().getName());
                    System.out.flush();
                    LookupServiceSynchronizationTest.this.ended.release();
                }
            }
            finally {
                System.out.println("ending " + Thread.currentThread().getName());
                System.out.flush();
                LookupServiceSynchronizationTest.this.ended.release();
            }
        }
    }
}

