/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.tests;

import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.nodes.DataNode;
import org.simantics.scenegraph.g2d.nodes.NavigationNode;

public class GetRootNodeTest {
    G2DSceneGraph root = new G2DSceneGraph();

    <T extends INode> T addNode(ParentNode<?> parent, String id, Class<T> clazz) {
        INode node = (INode)parent.addNode(id, clazz);
        return (T)node;
    }

    <T extends INode> T addNode(ParentNode<?> parent, Class<T> clazz) {
        return this.addNode(parent, UUID.randomUUID().toString(), clazz);
    }

    @Test
    public void testGetRootNode() throws Exception {
        NavigationNode nav = this.addNode(this.root, NavigationNode.class);
        DataNode data = this.addNode(this.root, DataNode.class);
        G2DParentNode elements = this.addNode(nav, G2DParentNode.class);
        G2DParentNode ghosts = this.addNode(nav, G2DParentNode.class);
        G2DParentNode e1 = this.addNode(elements, G2DParentNode.class);
        G2DParentNode e2 = this.addNode(elements, G2DParentNode.class);
        G2DParentNode e3 = this.addNode(elements, G2DParentNode.class);
        G2DParentNode e1_1 = this.addNode(e1, G2DParentNode.class);
        G2DParentNode e1_2 = this.addNode(e1, G2DParentNode.class);
        G2DParentNode e1_1_1 = this.addNode(e1_1, G2DParentNode.class);
        G2DParentNode e2_1 = this.addNode(e2, G2DParentNode.class);
        G2DParentNode e3_1 = this.addNode(e3, G2DParentNode.class);
        G2DParentNode e3_1_1 = this.addNode(e3_1, G2DParentNode.class);
        G2DParentNode e3_1_1_1 = this.addNode(e3_1_1, G2DParentNode.class);
        Assert.assertSame(e3_1_1_1.getRootNode(), (Object)this.root);
        Assert.assertSame(nav.getRootNode(), (Object)this.root);
        Assert.assertSame(e3_1.getRootNode(), (Object)this.root);
        Assert.assertSame(e3_1_1.getRootNode(), (Object)this.root);
        Assert.assertSame(e3_1.getRootNode(), (Object)this.root);
        Assert.assertSame(e2.getRootNode(), (Object)this.root);
        Assert.assertSame(e2_1.getRootNode(), (Object)this.root);
        Assert.assertSame(e1.getRootNode(), (Object)this.root);
        Assert.assertSame(e1_1_1.getRootNode(), (Object)this.root);
        Assert.assertSame(e1_1.getRootNode(), (Object)this.root);
        Assert.assertSame(e1_2.getRootNode(), (Object)this.root);
        Assert.assertSame(data.getRootNode(), (Object)this.root);
        Assert.assertSame(ghosts.getRootNode(), (Object)this.root);
        ghosts.remove();
        Assert.assertNull(ghosts.getRootNode());
        data.delete();
        Assert.assertNull(data.getRootNode());
        e1.remove();
        Assert.assertNull(e1.getRootNode());
        e2_1.remove();
        Assert.assertNull(e2_1.getRootNode());
        e2.remove();
        Assert.assertNull(e2.getRootNode());
        e3.remove();
        Assert.assertNull(e3_1_1_1.getRootNode());
        Assert.assertNull(e3_1_1.getRootNode());
        Assert.assertNull(e3_1.getRootNode());
        Assert.assertNull(e3.getRootNode());
    }
}

