/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes.connection;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RouteLink;
import org.simantics.diagram.connection.actions.IAction;
import org.simantics.diagram.connection.actions.IReconnectAction;
import org.simantics.diagram.connection.actions.MoveAction;
import org.simantics.diagram.connection.actions.ReconnectLineAction;
import org.simantics.diagram.connection.delta.RouteGraphDelta;
import org.simantics.diagram.connection.rendering.BasicConnectionStyle;
import org.simantics.diagram.connection.rendering.ConnectionStyle;
import org.simantics.diagram.connection.rendering.IRouteGraphRenderer;
import org.simantics.diagram.connection.rendering.StyledRouteGraphRenderer;
import org.simantics.diagram.connection.splitting.SplittedRouteGraph;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ISelectionPainterNode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.KeyEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.scenegraph.g2d.nodes.GridNode;
import org.simantics.scenegraph.g2d.nodes.LinkNode;
import org.simantics.scenegraph.g2d.nodes.connection.HighlightActionPointsAction;
import org.simantics.scenegraph.g2d.nodes.connection.IRouteGraphListener;
import org.simantics.scenegraph.g2d.nodes.connection.RemoveLineAction;
import org.simantics.scenegraph.g2d.nodes.connection.RouteGraphChangeEvent;
import org.simantics.scenegraph.g2d.snap.ISnapAdvisor;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.InitValueSupport;
import org.simantics.scenegraph.utils.NodeUtil;

public class RouteGraphNode
extends G2DNode
implements ISelectionPainterNode,
InitValueSupport {
    private static final long serialVersionUID = -917194130412280965L;
    private static final double TOLERANCE = 1.0;
    private static final Stroke SELECTION_STROKE = new BasicStroke(1.0f, 0, 0);
    private static final Color SELECTION_COLOR = new Color(255, 0, 255, 96);
    private static final HighlightActionPointsAction highlightActions = new HighlightActionPointsAction(null);
    protected RouteGraph rg;
    protected IRouteGraphRenderer baseRenderer;
    protected IRouteGraphRenderer renderer;
    protected double pickTolerance = 1.0;
    protected boolean editable = true;
    private boolean branchable = true;
    protected IRouteGraphListener rgListener;
    protected RouteGraphDelta rgDelta;
    protected transient double mouseX;
    protected transient double mouseY;
    protected transient Point2D pt = new Point2D.Double();
    protected transient MoveAction dragAction;
    protected transient IAction currentAction;
    protected transient Rectangle2D bounds;
    protected transient Color dynamicColor;
    protected transient Stroke dynamicStroke;
    protected transient Path2D selectionPath = new Path2D.Double();
    protected transient Stroke selectionStroke = null;
    protected transient boolean highlightActionsEnabled = false;
    protected transient AffineTransform lastViewTransform = null;
    protected transient Point2D newBranchPointPosition = null;
    MoveAction.TargetFilter moveFilter = new MoveAction.TargetFilter(){

        public boolean accept(Object target) {
            return target instanceof RouteLine || target instanceof RouteLink;
        }
    };

    @Override
    public void initValues() {
        this.dynamicColor = null;
        this.wrapRenderer();
    }

    @INode.PropertySetter(value="color")
    @INode.SyncField(value={"dynamicColor"})
    public void setDynamicColor(Color color) {
        this.dynamicColor = color;
        this.wrapRenderer();
    }

    @INode.PropertySetter(value="width")
    @INode.SyncField(value={"dynamicStroke"})
    public void setDynamicStroke(Stroke stroke) {
        this.dynamicStroke = stroke;
        this.wrapRenderer();
    }

    @INode.SyncField(value={"rg"})
    public void setRouteGraph(RouteGraph graph) {
        this.rg = graph;
        this.updateBounds();
    }

    @INode.SyncField(value={"rgDelta"})
    public void setRouteGraphDelta(RouteGraphDelta delta) {
        this.rgDelta = delta;
    }

    @INode.SyncField(value={"renderer"})
    public void setRenderer(IRouteGraphRenderer renderer) {
        this.baseRenderer = renderer;
        this.wrapRenderer();
        BasicConnectionStyle style = this.tryGetStyle();
        this.selectionStroke = null;
        if (style != null) {
            BasicStroke stroke = (BasicStroke)style.getLineStroke();
            if (stroke != null) {
                this.selectionStroke = new BasicStroke(stroke.getLineWidth() + 0.75f, 0, 0);
            }
        } else {
            this.selectionStroke = SELECTION_STROKE;
        }
    }

    private void wrapRenderer() {
        if (this.baseRenderer == null) {
            this.renderer = null;
            return;
        }
        if (this.dynamicColor != null || this.dynamicStroke != null) {
            BasicConnectionStyle baseStyle = this.tryGetStyle(this.baseRenderer);
            this.renderer = new StyledRouteGraphRenderer((ConnectionStyle)new BasicConnectionStyle(this.dynamicColor != null ? this.dynamicColor : baseStyle.getLineColor(), baseStyle.getBranchPointColor(), baseStyle.getBranchPointRadius(), this.dynamicStroke != null ? this.dynamicStroke : baseStyle.getLineStroke(), this.dynamicStroke != null ? this.dynamicStroke : baseStyle.getRouteLineStroke(), baseStyle.getDegeneratedLineLength()));
        } else {
            this.renderer = this.baseRenderer;
        }
    }

    @INode.SyncField(value={"pickTolerance"})
    public void setPickTolerance(double tolerance) {
        this.pickTolerance = tolerance;
    }

    @INode.SyncField(value={"editable"})
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @INode.SyncField(value={"branchable"})
    public void setBranchable(boolean branchable) {
        this.branchable = branchable;
    }

    public RouteGraph getRouteGraph() {
        return this.rg;
    }

    public RouteGraphDelta getRouteGraphDelta() {
        return this.rgDelta;
    }

    public IRouteGraphRenderer getRenderer() {
        return this.renderer;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isBranchable() {
        return this.branchable;
    }

    public double getPickTolerance() {
        return this.pickTolerance;
    }

    public void setRouteGraphListener(IRouteGraphListener listener) {
        this.rgListener = listener;
    }

    private boolean setRouteGraphAndFireChanges(RouteGraph before, RouteGraph after) {
        RouteGraphDelta delta = new RouteGraphDelta(before, after);
        if (!delta.isEmpty()) {
            this.setRouteGraph(after);
            this.setRouteGraphDelta(delta);
            this.fireRouteGraphChanged(before, after, delta);
            return true;
        }
        return false;
    }

    @INode.ServerSide
    protected void fireRouteGraphChanged(RouteGraph before, RouteGraph after, RouteGraphDelta delta) {
        if (this.rgListener != null) {
            RouteGraphChangeEvent event = new RouteGraphChangeEvent(this, before, after, delta);
            this.rgListener.routeGraphChanged(event);
        }
    }

    @Override
    public void init() {
        super.init();
        this.addEventHandler(this);
    }

    @Override
    public void cleanup() {
        this.rgListener = null;
        this.removeEventHandler(this);
        super.cleanup();
    }

    protected boolean isSelected() {
        return NodeUtil.isSelected(this, 1);
    }

    @Override
    public void render(Graphics2D g) {
        BasicConnectionStyle style;
        if (this.renderer == null) {
            return;
        }
        AffineTransform ot = null;
        AffineTransform t = this.getTransform();
        if (t != null && !t.isIdentity()) {
            ot = g.getTransform();
            g.transform(this.getTransform());
        }
        Object aaHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        boolean selected = NodeUtil.isSelected(this, 1);
        if (this.currentAction != null) {
            this.currentAction.render(g, this.renderer, this.mouseX, this.mouseY);
        } else {
            if (selected && this.selectionStroke != null) {
                this.selectionPath.reset();
                this.rg.getPath2D(this.selectionPath);
                Shape selectionShape = this.selectionStroke.createStrokedShape(this.selectionPath);
                g.setColor(SELECTION_COLOR);
                g.fill(selectionShape);
            }
            this.renderer.render(g, this.rg);
            if (selected && this.highlightActionsEnabled) {
                this.lastViewTransform = g.getTransform();
                highlightActions.setRouteGraph(this.rg);
                highlightActions.render(g, this.renderer, this.mouseX, this.mouseY);
                highlightActions.setRouteGraph(null);
            }
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aaHint);
        if (this.editable && this.branchable && this.newBranchPointPosition != null && !Double.isNaN(this.newBranchPointPosition.getX()) && (style = this.tryGetStyle()) != null) {
            style.drawBranchPoint(g, this.newBranchPointPosition.getX(), this.newBranchPointPosition.getY());
        }
        if (ot != null) {
            g.setTransform(ot);
        }
    }

    private BasicConnectionStyle tryGetStyle() {
        return this.tryGetStyle(this.renderer);
    }

    private BasicConnectionStyle tryGetStyle(IRouteGraphRenderer renderer) {
        ConnectionStyle cs;
        if (renderer instanceof StyledRouteGraphRenderer && (cs = ((StyledRouteGraphRenderer)renderer).getStyle()) instanceof BasicConnectionStyle) {
            return (BasicConnectionStyle)cs;
        }
        return null;
    }

    private double getSelectionStrokeWidth() {
        if (this.selectionStroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)this.selectionStroke;
            return bs.getLineWidth();
        }
        return 1.0;
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return this.bounds;
    }

    protected void updateBounds() {
        Rectangle2D r = this.bounds;
        if (r == null) {
            r = new Rectangle2D.Double();
        }
        this.bounds = this.calculateBounds(r);
        double sw = this.getSelectionStrokeWidth() / 2.0;
        GeometryUtils.expandRectangle(this.bounds, sw, sw);
    }

    protected Rectangle2D calculateBounds(Rectangle2D rect) {
        RouteGraph rg = this.rg;
        if (this.currentAction instanceof MoveAction) {
            rg = ((MoveAction)this.currentAction).getRouteGraph();
        }
        rg.getBounds(rect);
        return rect;
    }

    protected void getMouseLocalPos(MouseEvent e) {
        this.pt.setLocation(e.controlPosition);
        this.pt = NodeUtil.worldToLocal(this, this.pt, this.pt);
        this.mouseX = this.pt.getX();
        this.mouseY = this.pt.getY();
    }

    @Override
    protected boolean mouseDragged(MouseEvent.MouseDragBegin e) {
        if (this.dragAction != null && !e.hasAnyModifier(8896) && e.button == 1) {
            this.currentAction = this.dragAction;
            this.dragAction = null;
        }
        return this.updateCurrentAction(e, true);
    }

    @Override
    protected boolean mouseMoved(MouseEvent.MouseMovedEvent e) {
        this.getMouseLocalPos(e);
        if (this.newBranchPointPosition == null && e.hasAnyModifier(8704) && this.bounds.contains(this.mouseX, this.mouseY)) {
            this.newBranchPointPosition = new Point2D.Double(Double.NaN, Double.NaN);
        }
        if (this.newBranchPointPosition != null) {
            RouteLine line = this.rg.pickLine(this.mouseX, this.mouseY, this.pickTolerance);
            if (line != null) {
                this.newBranchPointPosition.setLocation(this.mouseX, this.mouseY);
                SplittedRouteGraph.snapToLine((Point2D)this.newBranchPointPosition, (RouteLine)line);
                this.repaint();
            } else if (!Double.isNaN(this.newBranchPointPosition.getX())) {
                this.newBranchPointPosition.setLocation(Double.NaN, Double.NaN);
                this.repaint();
            }
        }
        if (this.highlightActionsEnabled && NodeUtil.isSelected(this, 1)) {
            this.repaint();
        }
        return this.updateCurrentAction(e, false);
    }

    protected boolean updateCurrentAction(MouseEvent e, boolean updateMousePos) {
        boolean oldHighlight = this.highlightActionsEnabled;
        this.highlightActionsEnabled = e.hasAllModifiers(128);
        if (oldHighlight != this.highlightActionsEnabled) {
            this.repaint();
        }
        if (this.currentAction != null) {
            if (updateMousePos) {
                this.getMouseLocalPos(e);
            }
            this.updateBounds();
            if (this.currentAction instanceof MoveAction || this.bounds.contains(this.mouseX, this.mouseY)) {
                this.repaint();
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean mouseClicked(MouseEvent.MouseClickEvent e) {
        if (!this.editable) {
            return false;
        }
        if (e.button == 1 && this.isSelected() && this.highlightActionsEnabled && this.rg.getTerminals().size() > 2) {
            RemoveLineAction remove;
            HighlightActionPointsAction.Pick pick = highlightActions.pickAction(this.rg, this.lastViewTransform, this.mouseX, this.mouseY);
            if (pick.hasAction(HighlightActionPointsAction.Action.REMOVE) && (remove = RemoveLineAction.perform(this.rg, pick.line.getLine(), this.mouseX, this.mouseY)) != null) {
                this.setRouteGraphAndFireChanges(remove.getOriginalRouteGraph(), remove.getRouteGraph());
                this.repaint();
                return true;
            }
            if (pick.hasAction(HighlightActionPointsAction.Action.RECONNECT)) {
                this.currentAction = ReconnectLineAction.create((RouteGraph)this.rg, (double)this.mouseX, (double)this.mouseY);
                if (this.currentAction != null) {
                    this.repaint();
                }
            }
        }
        return false;
    }

    @Override
    protected boolean mouseButtonPressed(MouseEvent.MouseButtonPressedEvent e) {
        if (!this.editable) {
            return false;
        }
        if (e.button == 1) {
            this.newBranchPointPosition = null;
            this.getMouseLocalPos(e);
            this.dragAction = null;
            if (this.currentAction instanceof IReconnectAction) {
                RouteGraph originalRg = this.rg.copy();
                ((IReconnectAction)this.currentAction).finish(this.mouseX, this.mouseY);
                this.currentAction = null;
                this.setRouteGraphAndFireChanges(originalRg, this.rg);
                this.currentAction = null;
                this.repaint();
                return true;
            }
            if (!this.allowConnectionRerouting()) {
                return false;
            }
            this.dragAction = SnappingMoveAction.create(this.rg, this.mouseX, this.mouseY, this.pickTolerance, this.moveFilter, this.getSnapAdvisor());
            if (this.currentAction != null) {
                return true;
            }
        }
        return false;
    }

    private boolean allowConnectionRerouting() {
        boolean maxOtherNodesSelected = true;
        INode selections = NodeUtil.tryLookup(this, "selections");
        if (!(selections instanceof G2DParentNode)) {
            return true;
        }
        G2DParentNode p = (G2DParentNode)selections;
        for (IG2DNode selection : p.getNodes()) {
            if (!(selection instanceof G2DParentNode)) continue;
            G2DParentNode sp = (G2DParentNode)selection;
            Collection links = sp.getNodes();
            if (links.isEmpty()) {
                return true;
            }
            int othersSelected = 0;
            for (IG2DNode link : links) {
                INode node;
                if (!(link instanceof LinkNode) || NodeUtil.isParentOf(node = ((LinkNode)link).getDelegate(), this) || ++othersSelected <= 1) continue;
                return false;
            }
            if (othersSelected <= true) continue;
            return false;
        }
        return true;
    }

    protected ISnapAdvisor getSnapAdvisor() {
        GridNode grid = this.lookupNode("grid", GridNode.class);
        return grid != null ? grid.getSnapAdvisor() : null;
    }

    @Override
    protected boolean handleCommand(CommandEvent e) {
        if (Commands.CANCEL.equals(e.command)) {
            return this.cancelCurrentAction();
        }
        return false;
    }

    @Override
    protected boolean mouseButtonReleased(MouseEvent.MouseButtonReleasedEvent e) {
        if (this.currentAction instanceof MoveAction) {
            MoveAction move = (MoveAction)this.currentAction;
            RouteGraph originalRg = this.rg.copy();
            move.finish(this.mouseX, this.mouseY);
            this.setRouteGraphAndFireChanges(originalRg, this.rg);
            this.currentAction = null;
            this.repaint();
            return true;
        }
        return false;
    }

    @Override
    protected boolean keyPressed(KeyEvent.KeyPressedEvent e) {
        if (!this.editable) {
            return false;
        }
        if (!e.hasAnyModifier(8896) && e.keyCode == 83) {
            Object target = this.rg.pick(this.mouseX, this.mouseY, this.pickTolerance, 12);
            return this.splitTarget(target);
        }
        if (!(e.hasAnyModifier(8832) || e.keyCode != 82 && e.keyCode != 68)) {
            Object target = this.rg.pick(this.mouseX, this.mouseY, this.pickTolerance, 5);
            return this.deleteTarget(target);
        }
        if (e.keyCode == 27) {
            return this.cancelCurrentAction();
        }
        if (e.keyCode == 17) {
            this.highlightActionsEnabled = true;
            this.repaint();
        } else if (e.keyCode == 18) {
            RouteLine line = this.rg.pickLine(this.mouseX, this.mouseY, this.pickTolerance);
            if (this.branchable && line != null) {
                this.newBranchPointPosition = new Point2D.Double(this.mouseX, this.mouseY);
                SplittedRouteGraph.snapToLine((Point2D)this.newBranchPointPosition, (RouteLine)line);
                this.repaint();
            }
        }
        return false;
    }

    @Override
    protected boolean keyReleased(KeyEvent.KeyReleasedEvent e) {
        if (e.keyCode == 18 && this.newBranchPointPosition != null) {
            this.newBranchPointPosition = null;
            this.repaint();
        }
        if (e.keyCode == 17) {
            this.highlightActionsEnabled = false;
            this.repaint();
        }
        return false;
    }

    private boolean cancelCurrentAction() {
        if (this.currentAction != null) {
            this.currentAction = null;
            this.repaint();
            return true;
        }
        return false;
    }

    private boolean splitTarget(Object target) {
        if (target instanceof RouteLine) {
            RouteLine rLine = (RouteLine)target;
            RouteGraph before = this.rg.copy();
            this.rg.split(rLine, rLine.isHorizontal() ? this.mouseX : this.mouseY);
            this.setRouteGraphAndFireChanges(before, this.rg);
            this.repaint();
            return true;
        }
        return false;
    }

    private boolean deleteTarget(Object target) {
        boolean changed = false;
        if (target instanceof RouteLine) {
            RouteLine line = (RouteLine)target;
            RouteGraph before = this.rg.copy();
            this.rg.merge(line);
            changed = this.setRouteGraphAndFireChanges(before, this.rg);
        } else if (target instanceof RouteLink) {
            RouteGraph before = this.rg.copy();
            this.rg.deleteCorner((RouteLink)target);
            changed = this.setRouteGraphAndFireChanges(before, this.rg);
        }
        if (changed) {
            this.repaint();
        }
        return changed;
    }

    @Override
    public int getEventMask() {
        return EventTypes.CommandMask | EventTypes.KeyMask | EventTypes.MouseMask;
    }

    static class SnappingMoveAction
    extends MoveAction {
        private ISnapAdvisor snapAdvisor;
        private Point2D point = new Point2D.Double();

        public SnappingMoveAction(RouteGraph rg, Object target, ISnapAdvisor snapAdvisor) {
            super(rg, target);
            this.snapAdvisor = snapAdvisor;
        }

        protected void move(RouteGraph rg, Object target, double x, double y) {
            this.point.setLocation(x, y);
            this.snapAdvisor.snap(this.point);
            super.move(rg, target, this.point.getX(), this.point.getY());
        }

        public static MoveAction create(RouteGraph rg, double x, double y, double tolerance, MoveAction.TargetFilter filter, ISnapAdvisor snapAdvisor) {
            Object target = rg.pick(x, y, tolerance);
            if (target != null && (filter == null || filter.accept(target))) {
                if (snapAdvisor != null) {
                    return new SnappingMoveAction(rg, target, snapAdvisor);
                }
                return new MoveAction(rg, target);
            }
            return null;
        }
    }
}

