/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes.connection;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.imageio.ImageIO;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteLineHalf;
import org.simantics.diagram.connection.actions.IAction;
import org.simantics.diagram.connection.rendering.IRouteGraphRenderer;

public class HighlightActionPointsAction
implements IAction {
    static BufferedImage cross = HighlightActionPointsAction.safeReadImage("cross.png");
    static BufferedImage cut = HighlightActionPointsAction.safeReadImage("cut.png");
    public static final Stroke STROKE = new BasicStroke(0.1f, 1, 1);
    public static final AlphaComposite COMPOSITE = AlphaComposite.SrcOver.derive(0.6f);
    public static final double DEGENERATED_LINE_LENGTH = 1.0;
    public static final double CUT_DIST_FROM_END = 0.5;
    RouteGraph rg;
    transient Collection<RouteLineHalf> lhs = new ArrayList<RouteLineHalf>();
    transient AffineTransform transform = new AffineTransform();
    transient AffineTransform transform2 = new AffineTransform();
    transient Rectangle2D rect = new Rectangle2D.Double();

    public HighlightActionPointsAction(RouteGraph rg) {
        this.rg = rg;
    }

    public void setRouteGraph(RouteGraph rg) {
        this.rg = rg;
    }

    public void render(Graphics2D g, IRouteGraphRenderer renderer, double mouseX, double mouseY) {
        boolean simpleConnection = this.rg.isSimpleConnection() || this.rg.getTerminals().size() <= 2;
        boolean branchedConnection = this.rg.getTerminals().size() > 2;
        this.lhs.clear();
        this.rg.getLineHalves(this.lhs);
        AffineTransform preTr = g.getTransform();
        double viewScale = 1.0 / HighlightActionPointsAction.getScale(preTr);
        this.transform2.setToScale(viewScale, viewScale);
        Composite originalComposite = g.getComposite();
        g.setComposite(COMPOSITE);
        Pick pick = this.pickAction(this.rg, this.lhs, preTr, mouseX, mouseY);
        if (!simpleConnection) {
            double crossW = (double)cross.getWidth() * viewScale * 0.5;
            double crossH = (double)cross.getHeight() * viewScale * 0.5;
            for (RouteLineHalf lh : this.lhs) {
                if (lh.getLine().getTerminal() == null) continue;
                double x = lh.getLink().getX();
                double y = lh.getLink().getY();
                if (lh.getLine().isHorizontal()) {
                    x = (lh.getLine().getBegin().getX() + lh.getLine().getEnd().getX()) * 0.5;
                } else {
                    y = (lh.getLine().getBegin().getY() + lh.getLine().getEnd().getY()) * 0.5;
                }
                boolean hit = pick.matches(Action.REMOVE, lh);
                if (hit) {
                    g.setComposite(originalComposite);
                }
                this.transform.setToTranslation(x - crossW, y - crossH);
                g.transform(this.transform);
                g.drawImage(cross, this.transform2, null);
                g.setTransform(preTr);
                if (!hit) continue;
                g.setComposite(COMPOSITE);
            }
        }
        if (branchedConnection) {
            double cutW = (double)cut.getWidth() * viewScale * 0.5;
            double cutH = (double)cut.getHeight() * viewScale * 0.5;
            double dist = 0.5;
            for (RouteLineHalf lh : this.lhs) {
                if (lh.getLine().getLength() < 3.0) continue;
                double x = lh.getLink().getX();
                double y = lh.getLink().getY();
                if (lh.getLine().isHorizontal()) {
                    x = lh.getLink() == lh.getLine().getBegin() ? (x += 1.0) : (x -= 1.0);
                } else {
                    y = lh.getLink() == lh.getLine().getBegin() ? (y += 1.0) : (y -= 1.0);
                }
                boolean hit = pick.matches(Action.RECONNECT, lh);
                if (hit) {
                    g.setComposite(originalComposite);
                }
                this.transform.setToTranslation(x - cutW, y - cutH);
                if (!lh.getLine().isHorizontal()) {
                    this.transform.rotate(1.5707963267948966, cutW, cutH);
                }
                g.transform(this.transform);
                g.drawImage(cut, this.transform2, null);
                g.setTransform(preTr);
                if (!hit) continue;
                g.setComposite(COMPOSITE);
            }
        }
        g.setComposite(originalComposite);
    }

    public Pick pickAction(RouteGraph rg, AffineTransform viewTr, double mouseX, double mouseY) {
        boolean simpleConnection;
        boolean branchedConnection = rg.getTerminals().size() > 2;
        boolean bl = simpleConnection = rg.isSimpleConnection() || rg.getTerminals().size() <= 2;
        if (!branchedConnection || simpleConnection) {
            return null;
        }
        this.lhs.clear();
        return this.pickAction(rg, rg.getLineHalves(this.lhs), viewTr, mouseX, mouseY);
    }

    public Pick pickAction(RouteGraph rg, Collection<RouteLineHalf> lhs, AffineTransform viewTr, double mouseX, double mouseY) {
        boolean simpleConnection;
        boolean branchedConnection = rg.getTerminals().size() > 2;
        boolean bl = simpleConnection = rg.isSimpleConnection() || rg.getTerminals().size() <= 2;
        if (!branchedConnection || simpleConnection || viewTr == null) {
            return Pick.MISS;
        }
        lhs.clear();
        rg.getLineHalves(lhs);
        RouteLineHalf selected = null;
        Action selectedAction = null;
        double nearest = Double.MAX_VALUE;
        double viewScale = 1.0 / HighlightActionPointsAction.getScale(viewTr);
        if (!simpleConnection) {
            double crossW = (double)cross.getWidth() * viewScale * 0.5;
            double crossH = (double)cross.getHeight() * viewScale * 0.5;
            for (RouteLineHalf lh : lhs) {
                double distSq;
                if (lh.getLine().getTerminal() == null) continue;
                double x = lh.getLink().getX();
                double y = lh.getLink().getY();
                if (lh.getLine().isHorizontal()) {
                    x = (lh.getLine().getBegin().getX() + lh.getLine().getEnd().getX()) * 0.5;
                } else {
                    y = (lh.getLine().getBegin().getY() + lh.getLine().getEnd().getY()) * 0.5;
                }
                this.rect.setFrameFromCenter(x, y, x - crossW, y - crossH);
                boolean hit = this.rect.contains(mouseX, mouseY);
                if (!hit || !((distSq = HighlightActionPointsAction.distSq(x, y, mouseX, mouseY)) < nearest)) continue;
                nearest = distSq;
                selected = lh;
                selectedAction = Action.REMOVE;
            }
        }
        if (branchedConnection) {
            double cutW = (double)cut.getWidth() * viewScale * 0.5;
            double cutH = (double)cut.getHeight() * viewScale * 0.5;
            double dist = 0.5;
            for (RouteLineHalf lh : lhs) {
                double distSq;
                if (lh.getLine().getLength() < 3.0) continue;
                double x = lh.getLink().getX();
                double y = lh.getLink().getY();
                if (lh.getLine().isHorizontal()) {
                    x = lh.getLink() == lh.getLine().getBegin() ? (x += 1.0) : (x -= 1.0);
                } else {
                    y = lh.getLink() == lh.getLine().getBegin() ? (y += 1.0) : (y -= 1.0);
                }
                this.rect.setFrameFromCenter(x, y, x - cutW, y - cutH);
                boolean hit = this.rect.contains(mouseX, mouseY);
                if (!hit || !((distSq = HighlightActionPointsAction.distSq(x, y, mouseX, mouseY)) < nearest)) continue;
                nearest = 0.5;
                selected = lh;
                selectedAction = Action.RECONNECT;
            }
        }
        return selected == null ? Pick.MISS : new Pick(selectedAction, selected);
    }

    private static double distSq(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        return dx * dx + dy * dy;
    }

    private static double getScale(AffineTransform at) {
        double m00 = at.getScaleX();
        double m11 = at.getScaleY();
        double m10 = at.getShearY();
        double m01 = at.getShearX();
        return Math.sqrt(Math.abs(m00 * m11 - m10 * m01));
    }

    private static BufferedImage safeReadImage(String name) {
        try {
            URL url = HighlightActionPointsAction.class.getResource(name);
            return ImageIO.read(url);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static enum Action {
        REMOVE,
        RECONNECT;

    }

    public static class Pick {
        public static final Pick MISS = new Pick(null, null);
        Action action;
        RouteLineHalf line;

        public Pick(Action action, RouteLineHalf line) {
            this.action = action;
            this.line = line;
        }

        public boolean hasAction(Action action) {
            return this.action == action;
        }

        public boolean hasResult() {
            return this.action != null && this.line != null;
        }

        public boolean matches(Action action, RouteLineHalf line) {
            if (this.action == null || this.line == null) {
                return false;
            }
            return this.action.equals((Object)action) && this.line.equals(line);
        }
    }
}

