/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.IdentityAffineTransform;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.NodeUtil;

public class TransformableSelectionNode
extends G2DNode {
    private static final long serialVersionUID = -2879575230419873230L;
    private static final int HEADER_HEIGHT = 10;
    public static final transient BasicStroke SELECTION_STROKE = new BasicStroke(1.0f, 2, 2, 10.0f, new float[]{5.0f, 5.0f}, 0.0f);
    protected Rectangle2D bounds = null;
    protected Color color = null;
    protected Boolean resizeable = Boolean.FALSE;
    protected double minWidth = 7.0;
    protected double minHeight = 7.0;
    protected transient Point2D dragDelta = null;
    protected transient Point2D orig = null;
    protected transient Boolean resize = null;
    protected transient Point2D temp = new Point2D.Double();
    protected transient Path2D path = new Path2D.Double();
    protected transient Rectangle2D rect = new Rectangle2D.Double();
    protected transient TransformCallback transformCallback = null;

    @Override
    public void init() {
        super.init();
        this.addEventHandler(this);
    }

    @Override
    public void cleanup() {
        this.removeEventHandler(this);
        super.cleanup();
    }

    @INode.SyncField(value={"transform", "bounds", "color", "resizeable", "minWidth", "minHeight"})
    public void init(AffineTransform transform, Rectangle2D bounds, Color color, boolean resizeable, double minWidth, double minHeight) {
        this.transform = transform;
        this.bounds = bounds;
        this.color = color;
        this.resizeable = resizeable;
        this.minWidth = minWidth;
        this.minHeight = minHeight;
    }

    @INode.SyncField(value={"transform", "bounds", "color", "resizeable"})
    public void init(AffineTransform transform, Rectangle2D bounds, Color color, boolean resizeable) {
        this.transform = transform;
        this.bounds = bounds;
        this.color = color;
        this.resizeable = resizeable;
    }

    @INode.SyncField(value={"transform", "bounds", "color"})
    public void init(AffineTransform transform, Rectangle2D bounds, Color color) {
        this.transform = transform;
        this.bounds = bounds;
        this.color = color;
    }

    @Override
    public void render(Graphics2D g) {
        double padding;
        if (this.bounds == null) {
            return;
        }
        AffineTransform ot = g.getTransform();
        g.setColor(this.color);
        g.transform(this.transform);
        AffineTransform tx = g.getTransform();
        double scale = GeometryUtils.getScale(tx);
        double scaleRecip = 1.0 / scale;
        BasicStroke scaledStroke = GeometryUtils.scaleStroke(SELECTION_STROKE, (float)scaleRecip);
        g.setStroke(scaledStroke);
        double paddingX = padding = 0.0 * scaleRecip;
        double paddingY = padding;
        g.draw(new Rectangle2D.Double(this.bounds.getMinX() - paddingX, this.bounds.getMinY() - paddingY, this.bounds.getWidth() + 2.0 * paddingX, this.bounds.getHeight() + 2.0 * paddingY));
        double right = this.bounds.getMinX() - paddingX + this.bounds.getWidth() + 2.0 * paddingX;
        double bottom = this.bounds.getMinY() - paddingY + this.bounds.getHeight() + 2.0 * paddingY;
        if (this.resizeable.booleanValue()) {
            Path2D.Double corner = new Path2D.Double();
            ((Path2D)corner).moveTo(right - 8.0 - paddingX, bottom);
            ((Path2D)corner).lineTo(right, bottom - 8.0 - paddingY);
            ((Path2D)corner).lineTo(right, bottom);
            corner.closePath();
            g.setColor(new Color(20, 20, 20, 120));
            g.fill(corner);
            g.setColor(this.color);
            g.draw(new Line2D.Double(right - 8.0 - paddingX, bottom, right, bottom - 8.0 - paddingY));
        }
        Rectangle2D.Double header = new Rectangle2D.Double(this.bounds.getMinX() - paddingX, this.bounds.getMinY() - paddingY, this.bounds.getWidth() + 2.0 * paddingX, 10.0);
        g.setColor(new Color(20, 20, 20, 120));
        g.fill(header);
        g.setColor(this.color);
        g.draw(new Line2D.Double(this.bounds.getMinX(), this.bounds.getMinY() + 10.0, right, this.bounds.getMinY() + 10.0));
        g.setTransform(ot);
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return this.bounds;
    }

    public void setTransformCallback(TransformCallback transformCallback) {
        this.transformCallback = transformCallback;
    }

    @INode.ServerSide
    protected void resized(Point2D size) {
        if (this.transformCallback != null) {
            this.transformCallback.resized(size);
        }
    }

    @INode.ServerSide
    protected void moved(Point2D location) {
        if (this.transformCallback != null) {
            this.transformCallback.moved(location);
        }
    }

    @Override
    public boolean mouseMoved(MouseEvent.MouseMovedEvent e) {
        boolean dragging;
        boolean consume = false;
        Point2D scale = this.getScale(this.temp);
        double sx = scale.getX();
        double sy = scale.getY();
        Point2D localPos = NodeUtil.worldToLocal(this, e.controlPosition, this.temp);
        double mx = localPos.getX();
        double my = localPos.getY();
        AffineTransform i = AffineTransform.getTranslateInstance(-this.transform.getTranslateX() * sx, -this.transform.getTranslateY() * sy);
        Point2D p = i.transform(new Point2D.Double(sx * mx, sy * my), null);
        boolean bl = dragging = (e.buttons & 1) != 0;
        if (dragging && this.dragDelta != null) {
            double x = (p.getX() - this.dragDelta.getX()) / sx;
            double y = (p.getY() - this.dragDelta.getY()) / sy;
            if (Boolean.TRUE.equals(this.resize)) {
                double pointY;
                double height;
                double pointX;
                double width;
                if (this.bounds.getWidth() + x < this.minWidth) {
                    width = this.minWidth;
                    pointX = this.dragDelta.getX();
                } else {
                    width = this.bounds.getWidth() + x;
                    pointX = p.getX();
                }
                if (this.bounds.getHeight() + y < this.minHeight) {
                    height = this.minHeight;
                    pointY = this.dragDelta.getY();
                } else {
                    height = this.bounds.getHeight() + y;
                    pointY = p.getY();
                }
                this.bounds.setFrame(this.bounds.getX(), this.bounds.getY(), width, height);
                this.dragDelta = new Point2D.Double(pointX, pointY);
            } else if (Boolean.FALSE.equals(this.resize)) {
                if (this.transform == IdentityAffineTransform.INSTANCE) {
                    this.transform = AffineTransform.getTranslateInstance(x, y);
                } else {
                    this.transform.translate(x, y);
                }
            }
            this.repaint();
        } else {
            double paddingX = 0.0;
            double paddingY = 0.0;
            Path2D corner = TransformableSelectionNode.createCorner(this.path, this.bounds, 0.0, 0.0, sx, sy);
            Rectangle2D header = TransformableSelectionNode.createRectangle(this.rect, this.bounds, 0.0, 0.0, sx, sy);
            if (corner.contains(p)) {
                this.setCursor(12);
            } else if (header.contains(p)) {
                this.setCursor(12);
            } else {
                this.setCursor(0);
            }
        }
        return consume;
    }

    @Override
    protected boolean mouseButtonPressed(MouseEvent.MouseButtonPressedEvent e) {
        boolean consume = false;
        if (e.button == 1 && !e.hasAnyModifier(8896)) {
            Point2D scale = this.getScale(this.temp);
            double sx = scale.getX();
            double sy = scale.getY();
            Point2D localPos = NodeUtil.worldToLocal(this, e.controlPosition, this.temp);
            double mx = localPos.getX();
            double my = localPos.getY();
            AffineTransform i = AffineTransform.getTranslateInstance(-this.transform.getTranslateX() * sx, -this.transform.getTranslateY() * sy);
            Point2D p = i.transform(new Point2D.Double(sx * mx, sy * my), null);
            double paddingX = 0.0;
            double paddingY = 0.0;
            Path2D corner = TransformableSelectionNode.createCorner(this.path, this.bounds, 0.0, 0.0, sx, sy);
            Rectangle2D header = TransformableSelectionNode.createRectangle(this.rect, this.bounds, 0.0, 0.0, sx, sy);
            if (corner.contains(p)) {
                if (this.orig == null) {
                    this.orig = new Point2D.Double(this.bounds.getWidth(), this.bounds.getHeight());
                }
                this.resize = Boolean.TRUE;
                this.setCursor(5);
                consume = true;
            } else if (header.contains(p)) {
                if (this.orig == null) {
                    this.orig = new Point2D.Double(this.transform.getTranslateX(), this.transform.getTranslateY());
                }
                this.resize = Boolean.FALSE;
                this.setCursor(13);
                consume = true;
            } else {
                this.resize = null;
            }
            this.dragDelta = new Point2D.Double(p.getX(), p.getY());
            this.repaint();
        }
        return consume;
    }

    @Override
    protected boolean mouseButtonReleased(MouseEvent.MouseButtonReleasedEvent e) {
        if (this.orig != null) {
            this.setCursor(0);
            if (this.resize.booleanValue()) {
                Point2D.Double delta = new Point2D.Double(this.bounds.getWidth() - this.orig.getX(), this.bounds.getHeight() - this.orig.getY());
                this.resized(delta);
            } else {
                Point2D.Double delta = new Point2D.Double(this.transform.getTranslateX() - this.orig.getX(), this.transform.getTranslateY() - this.orig.getY());
                this.moved(delta);
            }
            this.orig = null;
            return true;
        }
        return false;
    }

    @Override
    public int getEventMask() {
        return EventTypes.MouseButtonPressedMask | EventTypes.MouseButtonReleasedMask | EventTypes.MouseMovedMask;
    }

    private Point2D getScale(Point2D result) {
        double sx = 1.0;
        double sy = 1.0;
        IG2DNode node = (IG2DNode)((Object)this.getParent());
        while (node != null) {
            sx *= node.getTransform().getScaleX();
            sy *= node.getTransform().getScaleY();
            node = (G2DParentNode)node.getParent();
        }
        result.setLocation(sx, sy);
        return result;
    }

    private static Rectangle2D createRectangle(Rectangle2D result, Rectangle2D bounds, double paddingX, double paddingY, double sx, double sy) {
        result.setFrame((bounds.getMinX() - paddingX) * sx, (bounds.getMinY() - paddingY) * sy, (bounds.getWidth() + 2.0 * paddingX) * sx, 10.0 * sy);
        return result;
    }

    private static Path2D createCorner(Path2D result, Rectangle2D bounds, double paddingX, double paddingY, double sx, double sy) {
        double right = bounds.getMinX() - paddingX + bounds.getWidth() + 2.0 * paddingX;
        double bottom = bounds.getMinY() - paddingY + bounds.getHeight() + 2.0 * paddingY;
        result.reset();
        result.moveTo((right - 8.0 - paddingX) * sx, bottom * sy);
        result.lineTo(right * sx, (bottom - 8.0 - paddingY) * sy);
        result.lineTo(right * sx, bottom * sy);
        result.closePath();
        return result;
    }

    public static interface TransformCallback {
        public void moved(Point2D var1);

        public void resized(Point2D var1);
    }
}

