/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.nodes.TransformNode;
import org.simantics.scenegraph.utils.InitValueSupport;

public class SingleElementNode
extends TransformNode
implements InitValueSupport {
    private static final long serialVersionUID = -4982578347433716440L;
    protected Composite composite;
    protected Boolean visible = Boolean.TRUE;
    protected Boolean hidden = Boolean.FALSE;
    protected Composite alphaComposite = null;

    @Override
    public boolean validate() {
        return this.visible != false && this.hidden == false;
    }

    @INode.SyncField(value={"composite"})
    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    @INode.SyncField(value={"visible"})
    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @INode.SyncField(value={"hidden"})
    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void render(Graphics2D g) {
        if (!this.visible.booleanValue() || this.hidden.booleanValue()) {
            return;
        }
        Composite oldComposite = null;
        if (this.composite != null) {
            oldComposite = g.getComposite();
            g.setComposite(this.composite);
        }
        if (this.alphaComposite != null) {
            if (oldComposite == null) {
                oldComposite = g.getComposite();
            }
            g.setComposite(this.alphaComposite);
        }
        super.render(g);
        if (oldComposite != null) {
            g.setComposite(oldComposite);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(" [");
        if (this.composite != null) {
            sb.append("composite=(");
            AlphaComposite ac = (AlphaComposite)this.composite;
            sb.append(ac.getRule());
            sb.append(", ");
            sb.append(ac.getAlpha());
            sb.append("), ");
        }
        sb.append("visible=");
        sb.append(this.visible);
        sb.append("]");
        return sb.toString();
    }

    @INode.PropertySetter(value="alpha")
    @INode.SyncField(value={"alphaComposite"})
    public void setAlphaComposite(Composite alphaComposite) {
        this.alphaComposite = alphaComposite;
    }

    @Override
    public void initValues() {
        this.alphaComposite = null;
        IG2DNode[] iG2DNodeArray = this.getSortedNodes();
        int n = iG2DNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IG2DNode node = iG2DNodeArray[n2];
            if (node instanceof InitValueSupport) {
                ((InitValueSupport)((Object)node)).initValues();
            }
            ++n2;
        }
    }
}

