/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import com.kitfox.svg.SVGCache;
import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGRoot;
import com.kitfox.svg.SVGUniverse;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.simantics.scenegraph.ExportableWidget;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.LoaderNode;
import org.simantics.scenegraph.ScenegraphUtils;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.utils.BufferedImage;
import org.simantics.scenegraph.utils.InitValueSupport;
import org.simantics.scenegraph.utils.MipMapBufferedImage;
import org.simantics.scenegraph.utils.MipMapVRamBufferedImage;
import org.simantics.scenegraph.utils.VRamBufferedImage;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.function.Function2;
import org.simantics.utils.threads.AWTThread;

@ExportableWidget.RasterOutputWidget
public class SVGNode
extends G2DNode
implements InitValueSupport,
LoaderNode {
    private static final long serialVersionUID = 8508750881358776559L;
    protected String data = null;
    protected String defaultData = null;
    protected Point targetSize = null;
    protected Boolean useMipMap = true;
    protected Rectangle2D bounds = null;
    transient BufferedImage buffer = null;
    transient String documentCache = null;
    transient SVGDiagram diagramCache = null;
    transient String dataHash = null;
    static transient Map<String, WeakReference<BufferedImage>> bufferCache = new HashMap<String, WeakReference<BufferedImage>>();
    static WeakHashMap<String, String> dataCache = new WeakHashMap();
    static WeakHashMap<String, String> digestCache = new WeakHashMap();
    static URL BROKEN_SVG_DATA = SVGNode.class.getResource("broken.svg");
    static URL EMPTY_SVG_DATA = SVGNode.class.getResource("empty.svg");

    @Override
    public void cleanup() {
        this.cleanDiagramCache();
    }

    protected void cleanDiagramCache() {
        SVGDiagram d = this.diagramCache;
        if (d != null) {
            this.diagramCache = null;
            SVGUniverse univ = SVGCache.getSVGUniverse();
            univ.decRefCountAndClear(d.getXMLBase());
        }
    }

    @INode.PropertySetter(value="SVG")
    @INode.SyncField(value={"data"})
    public void setData(String data) {
        String cached = dataCache.get(data);
        if (cached == null) {
            cached = data;
            dataCache.put(data, data);
        }
        this.data = cached;
        this.defaultData = cached;
    }

    @INode.SyncField(value={"targetSize"})
    public void setTargetSize(Point p) {
        this.targetSize = p;
    }

    @INode.SyncField(value={"targetSize"})
    public void setTargetSize(int x, int y) {
        this.targetSize = new Point(x, y);
    }

    @INode.SyncField(value={"useMipMap"})
    public void useMipMap(Boolean use) {
        this.useMipMap = use;
    }

    @INode.PropertySetter(value="Bounds")
    @INode.SyncField(value={"bounds"})
    public void setBounds(Rectangle2D bounds) {
        this.bounds = bounds;
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        if (this.bounds == null) {
            this.parseSVG();
        }
        return this.bounds;
    }

    @Override
    public void render(Graphics2D g2d) {
        if (this.data == null) {
            return;
        }
        if (!this.data.equals(this.documentCache) || this.diagramCache == null || this.buffer == null) {
            this.initBuffer(g2d);
        }
        AffineTransform ot = null;
        if (!this.transform.isIdentity()) {
            ot = g2d.getTransform();
            g2d.transform(this.transform);
        }
        if (this.buffer != null) {
            this.buffer.paint(g2d);
        }
        if (ot != null) {
            g2d.setTransform(ot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String parseSVG() {
        if (this.data == null) {
            return null;
        }
        try {
            SVGUniverse univ;
            SVGUniverse sVGUniverse = univ = SVGCache.getSVGUniverse();
            synchronized (sVGUniverse) {
                byte[] dataBytes = this.data.getBytes("UTF-8");
                this.dataHash = SVGNode.digest(dataBytes);
                if (this.diagramCache != null) {
                    univ.decRefCount(this.diagramCache.getXMLBase());
                }
                URI uri = univ.loadSVG((InputStream)new ByteArrayInputStream(dataBytes), this.dataHash);
                this.diagramCache = univ.getDiagram(uri, false);
                if (this.diagramCache != null) {
                    if (this.diagramCache.getRoot() == null) {
                        this.diagramCache = univ.getDiagram(univ.loadSVG(BROKEN_SVG_DATA), false);
                        this.dataHash = "broken";
                    } else if (this.diagramCache.getRoot().getBoundingBox().isEmpty()) {
                        this.diagramCache = univ.getDiagram(univ.loadSVG(EMPTY_SVG_DATA), false);
                        this.dataHash = "empty";
                    }
                }
                this.documentCache = this.data;
                if (this.diagramCache != null) {
                    this.setBounds((Rectangle2D)this.diagramCache.getRoot().getBoundingBox().clone());
                    univ.incRefCount(this.diagramCache.getXMLBase());
                } else {
                    this.setBounds(new Rectangle2D.Double());
                }
            }
        }
        catch (SVGException e) {
            this.setBounds((Rectangle2D)this.diagramCache.getViewRect().clone());
        }
        catch (IOException e) {
            this.diagramCache = null;
        }
        return this.dataHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Rectangle2D getBounds(String data) {
        if (data == null) {
            new Exception("null SVG data").printStackTrace();
            return null;
        }
        SVGDiagram diagramCache = null;
        try {
            SVGUniverse univ;
            byte[] dataBytes = data.getBytes("UTF-8");
            String digest = SVGNode.digest(dataBytes);
            SVGUniverse sVGUniverse = univ = SVGCache.getSVGUniverse();
            synchronized (sVGUniverse) {
                URI uri = univ.loadSVG((InputStream)new ByteArrayInputStream(dataBytes), digest);
                diagramCache = univ.getDiagram(uri, false);
                if (diagramCache != null) {
                    if (diagramCache.getRoot() == null) {
                        diagramCache = univ.getDiagram(univ.loadSVG(BROKEN_SVG_DATA));
                    } else if (diagramCache.getRoot().getBoundingBox().isEmpty()) {
                        diagramCache = univ.getDiagram(univ.loadSVG(EMPTY_SVG_DATA));
                    }
                }
            }
            Rectangle2D rect = null;
            if (diagramCache != null) {
                SVGRoot root = diagramCache.getRoot();
                Rectangle2D bbox = root.getBoundingBox();
                rect = (Rectangle2D)bbox.clone();
            } else {
                rect = new Rectangle2D.Double();
            }
            return rect;
        }
        catch (SVGException e) {
            return (Rectangle2D)diagramCache.getViewRect().clone();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Rectangle2D getRealBounds(String data) {
        if (data == null) {
            new Exception("null SVG data").printStackTrace();
            return null;
        }
        SVGDiagram diagramCache = null;
        try {
            SVGUniverse univ;
            byte[] dataBytes = data.getBytes("UTF-8");
            String digest = SVGNode.digest(dataBytes);
            SVGUniverse sVGUniverse = univ = SVGCache.getSVGUniverse();
            synchronized (sVGUniverse) {
                URI uri = univ.loadSVG((InputStream)new ByteArrayInputStream(dataBytes), digest);
                diagramCache = univ.getDiagram(uri, false);
                if (diagramCache != null) {
                    SVGRoot root = diagramCache.getRoot();
                    if (root == null) {
                        return new Rectangle2D.Double();
                    }
                    return (Rectangle2D)root.getBoundingBox().clone();
                }
            }
        }
        catch (SVGException e) {
            return (Rectangle2D)diagramCache.getViewRect().clone();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    protected void initBuffer(Graphics2D g2d) {
        if (!this.data.equals(this.documentCache) || this.diagramCache == null) {
            this.dataHash = this.parseSVG();
            if (this.diagramCache == null) {
                System.err.println("UNABLE TO PARSE SVG:\n" + this.data);
                return;
            }
        }
        if (this.buffer != null) {
            this.buffer = null;
        }
        this.diagramCache.setIgnoringClipHeuristic(true);
        if (bufferCache.containsKey(this.dataHash) && bufferCache.get(this.dataHash).get() != null) {
            this.buffer = (BufferedImage)bufferCache.get(this.dataHash).get();
        } else if (this.diagramCache.getViewRect().getWidth() == 0.0 || this.diagramCache.getViewRect().getHeight() == 0.0) {
            this.buffer = null;
        } else if (this.useMipMap.booleanValue()) {
            this.buffer = g2d.getDeviceConfiguration().getImageCapabilities().isAccelerated() ? new MipMapVRamBufferedImage(this.diagramCache, this.bounds, this.targetSize) : new MipMapBufferedImage(this.diagramCache, this.bounds, this.targetSize);
            bufferCache.put(this.dataHash, new WeakReference<BufferedImage>(this.buffer));
        } else {
            this.buffer = g2d.getDeviceConfiguration().getImageCapabilities().isAccelerated() ? new VRamBufferedImage(this.diagramCache, this.bounds, this.targetSize) : new BufferedImage(this.diagramCache, this.bounds, this.targetSize);
            bufferCache.put(this.dataHash, new WeakReference<BufferedImage>(this.buffer));
        }
    }

    public void setProperty(String field, Object value) {
        if ("data".equals(field)) {
            this.data = (String)value;
        } else if ("z".equals(field)) {
            this.setZIndex((Integer)value);
        } else if ("position".equals(field)) {
            Point point = (Point)value;
            this.setTransform(AffineTransform.getTranslateInstance(point.x, point.y));
        }
    }

    @Override
    public void initValues() {
        this.data = this.defaultData;
        this.dataHash = null;
        this.buffer = null;
    }

    static String digest(byte[] dataBytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(dataBytes);
            BigInteger number = new BigInteger(1, messageDigest);
            String dataHash = number.toString(16);
            String result = digestCache.get(dataHash);
            if (result == null) {
                result = dataHash;
                digestCache.put(dataHash, dataHash);
            }
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("MD5 digest must exist.");
        }
    }

    @Override
    public Function1<Object, Boolean> getPropertyFunction(String propertyName) {
        return ScenegraphUtils.getMethodPropertyFunction(AWTThread.getThreadAccess(), this, propertyName);
    }

    @Override
    public <T> T getProperty(String propertyName) {
        return null;
    }

    @Override
    public void setPropertyCallback(Function2<String, Object, Boolean> callback) {
    }

    public void synchronizeDocument(String document) {
        this.setData(document);
    }

    public void synchronizeTransform(double[] data) {
        this.setTransform(new AffineTransform(data));
    }
}

