/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.nodes.AnimatedSVGNode;

public class SVGHolderNode
extends G2DParentNode {
    private static final long serialVersionUID = 8698435757824280001L;
    protected Rectangle2D bounds = null;
    protected Float borderWidth = null;

    @INode.PropertySetter(value="VariableFilter")
    public void setScript(String script) {
        IG2DNode[] iG2DNodeArray = this.getSortedNodes();
        int n = iG2DNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IG2DNode node = iG2DNodeArray[n2];
            if (node instanceof AnimatedSVGNode) {
                ((AnimatedSVGNode)node).setScript(script);
            }
            ++n2;
        }
    }

    @INode.PropertySetter(value="SVG")
    public void setData(String data) {
        IG2DNode[] iG2DNodeArray = this.getSortedNodes();
        int n = iG2DNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IG2DNode node = iG2DNodeArray[n2];
            if (node instanceof AnimatedSVGNode) {
                ((AnimatedSVGNode)node).setData(data);
            }
            ++n2;
        }
    }

    @INode.PropertySetter(value="Stroke Width")
    @INode.SyncField(value={"border"})
    public void setBorderWidth(Float borderWidth) {
        this.borderWidth = borderWidth;
    }

    @INode.PropertySetter(value="Bounds")
    @INode.SyncField(value={"bounds"})
    public void setBounds(Rectangle2D bounds) {
        this.bounds = bounds;
    }

    @Override
    public void render(Graphics2D g2d) {
        Rectangle2D cb = this.getBoundsInLocal(false);
        double scaleX = this.bounds.getWidth() / cb.getWidth();
        double scaleY = this.bounds.getHeight() / cb.getHeight();
        double scale = Math.min(scaleX, scaleY);
        if (this.borderWidth != null && this.borderWidth.floatValue() > 0.0f && this.bounds != null) {
            Graphics2D g2 = (Graphics2D)g2d.create();
            g2.transform(this.transform);
            g2.setStroke(new BasicStroke(this.borderWidth.floatValue()));
            g2.setColor(Color.BLACK);
            g2.draw(this.bounds);
            g2.dispose();
        }
        int noBounds = 0;
        int clipped = 0;
        int rendered = 0;
        AffineTransform ot = g2d.getTransform();
        g2d.transform(this.transform);
        g2d.translate(-cb.getMinX() * scale + this.bounds.getMinX(), -cb.getMinY() * scale + this.bounds.getMinY());
        g2d.scale(scale, scale);
        Shape clipShape = g2d.getClip();
        Rectangle2D bounds = null;
        if (clipShape instanceof Rectangle2D) {
            bounds = (Rectangle2D)clipShape;
        } else if (clipShape != null) {
            bounds = clipShape.getBounds2D();
        }
        boolean noClipBounds = bounds == null;
        IG2DNode[] iG2DNodeArray = this.getSortedNodes();
        int n = iG2DNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IG2DNode node = iG2DNodeArray[n2];
            Rectangle2D localBounds = node.getBoundsInLocal();
            boolean hasNoBounds = localBounds == null;
            boolean visible = false;
            if (!noClipBounds && !hasNoBounds) {
                visible = node.intersects(bounds);
            } else {
                ++noBounds;
            }
            if (noClipBounds || hasNoBounds || visible) {
                if (node.validate()) {
                    node.render(g2d);
                }
                ++rendered;
            } else {
                ++clipped;
            }
            ++n2;
        }
        g2d.setTransform(ot);
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return this.bounds;
    }
}

