/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DNode;

public class ImageNode
extends G2DNode {
    private static final long serialVersionUID = -4982578347433716440L;
    protected Boolean visible = Boolean.TRUE;
    protected BufferedImage img = null;

    @INode.SyncField(value={"visible"})
    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @INode.ClientSide
    public void setImage(byte[] buf) {
        try {
            this.img = ImageIO.read(new ByteArrayInputStream(buf));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setImage(BufferedImage src) {
        this.img = src;
    }

    @Override
    public void render(Graphics2D g) {
        if (!this.visible.booleanValue() || this.img == null) {
            return;
        }
        AffineTransform ot = null;
        if (!this.transform.isIdentity()) {
            ot = g.getTransform();
            g.transform(this.transform);
        }
        g.drawImage((Image)this.img, 0, 0, null);
        if (ot != null) {
            g.setTransform(ot);
        }
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return new Rectangle2D.Double(this.img.getMinX(), this.img.getMinY(), this.img.getWidth(), this.img.getHeight());
    }
}

