/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.events;

import java.awt.Component;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.G2DFocusManager;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.FocusEvent;
import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.g2d.events.KeyEvent;
import org.simantics.scenegraph.g2d.events.ListenerList;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.TimeEvent;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;

public class NodeEventHandler
implements IEventHandler {
    private static final boolean DEBUG_EVENTS = false;
    private static final boolean DEBUG_HANDLER_SORT = false;
    TreePreOrderComparator COMPARATOR = new TreePreOrderComparator(TreePreOrderComparator.Order.DESCENDING);
    protected ListenerList<IEventHandler> focusListeners = new ListenerList<IEventHandler>(IEventHandler.class);
    protected ListenerList<IEventHandler> timeListeners = new ListenerList<IEventHandler>(IEventHandler.class);
    protected ListenerList<IEventHandler> commandListeners = new ListenerList<IEventHandler>(IEventHandler.class);
    protected IEventHandler[] sortedCommandListeners = null;
    protected ListenerList<IEventHandler> keyListeners = new ListenerList<IEventHandler>(IEventHandler.class);
    protected IEventHandler[] sortedKeyListeners = null;
    protected ListenerList<IEventHandler> mouseListeners = new ListenerList<IEventHandler>(IEventHandler.class);
    protected IEventHandler[] sortedMouseListeners = null;
    protected G2DSceneGraph sg;
    protected DragSource ds = new DragSource();

    public NodeEventHandler(G2DSceneGraph sg) {
        this.sg = sg;
    }

    private IEventHandler[] sort(IEventHandler[] sort) {
        IEventHandler[] copy = Arrays.copyOf(sort, sort.length);
        Arrays.sort(copy, this.COMPARATOR);
        return copy;
    }

    public void setRootPane(Component rootPane) {
        final DragSourceListener dsl = new DragSourceListener(){

            @Override
            public void dropActionChanged(DragSourceDragEvent dsde) {
            }

            @Override
            public void dragOver(DragSourceDragEvent dsde) {
            }

            @Override
            public void dragExit(DragSourceEvent dse) {
            }

            @Override
            public void dragEnter(DragSourceDragEvent dsde) {
            }

            @Override
            public void dragDropEnd(DragSourceDropEvent dsde) {
            }
        };
        this.ds.createDefaultDragGestureRecognizer(rootPane, 0x40000003, new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent dge) {
                MouseEvent.MouseDragBegin event = new MouseEvent.MouseDragBegin(NodeEventHandler.this, 0L, 0, 0, 0, 0, new Point2D.Double(), new Point2D.Double(), new Point2D.Double(), new Point2D.Double());
                NodeEventHandler.this.handleMouseEvent(event, 10);
                if (event.transferable != null) {
                    NodeEventHandler.this.ds.startDrag(dge, null, event.transferable, dsl);
                }
            }
        });
        this.ds.addDragSourceListener(dsl);
    }

    public boolean mousePressed(MouseEvent.MouseButtonPressedEvent event) {
        G2DFocusManager.INSTANCE.clearFocus();
        if (this.sg.getRootPane() != null && G2DFocusManager.INSTANCE.getFocusOwner() == null) {
            this.sg.getRootPane().requestFocusInWindow();
        }
        return false;
    }

    private boolean handleMouseEvent(MouseEvent e, int eventType) {
        IEventHandler[] sorted = this.sortedMouseListeners;
        if (sorted == null) {
            sorted = this.sort(this.mouseListeners.getListeners());
            this.sortedMouseListeners = sorted;
        }
        return this.handleEvent(e, this.sg.getFocusNode(), sorted);
    }

    private boolean handleEvent(Event e, IG2DNode focusNode, IEventHandler[] handlers) {
        IG2DNode h;
        if (focusNode instanceof IEventHandler && NodeEventHandler.eats((h = focusNode).getEventMask(), EventTypes.toTypeMask(e)) && h.handleEvent(e)) {
            return true;
        }
        IEventHandler[] iEventHandlerArray = handlers;
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            IEventHandler l = iEventHandlerArray[n2];
            if (l.handleEvent(e)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean handleFocusEvent(FocusEvent e) {
        return this.handleEvent(e, null, this.focusListeners.getListeners());
    }

    private boolean handleTimeEvent(TimeEvent e) {
        return this.handleEvent(e, null, this.timeListeners.getListeners());
    }

    private boolean handleCommandEvent(CommandEvent e) {
        IEventHandler[] sorted = this.sortedCommandListeners;
        if (sorted == null) {
            sorted = this.sort(this.commandListeners.getListeners());
            this.sortedCommandListeners = sorted;
        }
        return this.handleEvent(e, this.sg.getFocusNode(), sorted);
    }

    private boolean handleKeyEvent(KeyEvent e) {
        IEventHandler[] sorted = this.sortedKeyListeners;
        if (sorted == null) {
            sorted = this.sort(this.keyListeners.getListeners());
            this.sortedKeyListeners = sorted;
        }
        return this.handleEvent(e, this.sg.getFocusNode(), sorted);
    }

    @Override
    public int getEventMask() {
        return EventTypes.AnyMask;
    }

    @Override
    public boolean handleEvent(Event e) {
        int eventType = EventTypes.toType(e);
        switch (eventType) {
            case 1: {
                return this.handleCommandEvent((CommandEvent)e);
            }
            case 2: 
            case 3: {
                return this.handleFocusEvent((FocusEvent)e);
            }
            case 4: 
            case 5: {
                return this.handleKeyEvent((KeyEvent)e);
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return this.handleMouseEvent((MouseEvent)e, eventType);
            }
            case 15: {
                return this.handleTimeEvent((TimeEvent)e);
            }
        }
        return false;
    }

    public void add(IEventHandler item) {
        if (!(item instanceof IG2DNode)) {
            throw new IllegalArgumentException("event handler must be an IG2DNode");
        }
        int mask = item.getEventMask();
        if (NodeEventHandler.eats(mask, EventTypes.CommandMask)) {
            this.commandListeners.add(item);
            this.sortedCommandListeners = null;
        }
        if (NodeEventHandler.eats(mask, EventTypes.FocusMask)) {
            this.focusListeners.add(item);
        }
        if (NodeEventHandler.eats(mask, EventTypes.KeyMask)) {
            this.keyListeners.add(item);
            this.sortedKeyListeners = null;
        }
        if (NodeEventHandler.eats(mask, EventTypes.MouseMask)) {
            this.mouseListeners.add(item);
            this.sortedMouseListeners = null;
        }
        if (NodeEventHandler.eats(mask, EventTypes.TimeMask)) {
            this.timeListeners.add(item);
        }
    }

    public boolean remove(IEventHandler item) {
        if (!(item instanceof IG2DNode)) {
            throw new IllegalArgumentException("event handler must be an IG2DNode");
        }
        int mask = item.getEventMask();
        boolean removed = false;
        if (NodeEventHandler.eats(mask, EventTypes.CommandMask)) {
            removed |= this.commandListeners.remove(item);
            this.sortedCommandListeners = null;
        }
        if (NodeEventHandler.eats(mask, EventTypes.FocusMask)) {
            removed |= this.focusListeners.remove(item);
        }
        if (NodeEventHandler.eats(mask, EventTypes.KeyMask)) {
            removed |= this.keyListeners.remove(item);
            this.sortedKeyListeners = null;
        }
        if (NodeEventHandler.eats(mask, EventTypes.MouseMask)) {
            removed |= this.mouseListeners.remove(item);
            this.sortedMouseListeners = null;
        }
        if (NodeEventHandler.eats(mask, EventTypes.TimeMask)) {
            removed |= this.timeListeners.remove(item);
        }
        return removed;
    }

    private static boolean eats(int handlerMask, int eventTypeMask) {
        return (handlerMask & eventTypeMask) != 0;
    }

    private void debug(String msg) {
        System.out.println(String.valueOf(this.getClass().getSimpleName()) + ": " + msg);
    }

    public static class TreePreOrderComparator
    implements Comparator<IEventHandler> {
        private transient ThreadLocal<Temp> temp = new ThreadLocal<Temp>(){

            @Override
            protected Temp initialValue() {
                return new Temp();
            }
        };
        Order order;

        public TreePreOrderComparator(Order order) {
            this.order = order;
        }

        void getTreePath(INode node, ArrayList<INode> result) {
            result.clear();
            ParentNode<?> parent = node.getParent();
            while (parent != null) {
                result.add(parent);
                parent = parent.getParent();
            }
        }

        void notSameGraph(INode o1, INode o2) {
            throw new IllegalStateException("nodes " + o1 + " and " + o2 + " not part of same scene graph.\n\t root 1: " + o1.getRootNode() + "\n\troot 2: " + o2.getRootNode());
        }

        @Override
        public int compare(IEventHandler e1, IEventHandler e2) {
            INode root2;
            if (e1 == e2) {
                return 0;
            }
            Temp tmp = this.temp.get();
            ArrayList<INode> path1 = tmp.path1;
            ArrayList<INode> path2 = tmp.path2;
            INode o1 = (INode)((Object)e1);
            INode o2 = (INode)((Object)e2);
            this.getTreePath(o1, path1);
            this.getTreePath(o2, path2);
            INode root1 = path1.isEmpty() ? o1 : path1.get(path1.size() - 1);
            INode iNode = root2 = path2.isEmpty() ? o2 : path2.get(path2.size() - 1);
            if (root1 != root2) {
                this.notSameGraph(o1, o2);
            }
            try {
                IG2DNode g2;
                int i1 = path1.size() - 1;
                int i2 = path2.size() - 1;
                while (i1 >= 0 && i2 >= 0) {
                    INode p2;
                    INode p1 = path1.get(i1);
                    if (p1 != (p2 = path2.get(i2))) break;
                    --i1;
                    --i2;
                }
                if (i1 < 0) {
                    int n = Order.ASCENDING == this.order ? -1 : 1;
                    return n;
                }
                if (i2 < 0) {
                    int n = Order.ASCENDING == this.order ? 1 : -1;
                    return n;
                }
                INode n1 = path1.get(i1);
                INode n2 = path2.get(i2);
                IG2DNode g1 = n1 instanceof IG2DNode ? (IG2DNode)n1 : null;
                IG2DNode iG2DNode = g2 = n2 instanceof IG2DNode ? (IG2DNode)n2 : null;
                if (g1 != null && g2 != null) {
                    int z1 = g1.getZIndex();
                    int z2 = g2.getZIndex();
                    int c = this.compare(z1, z2);
                    int n = this.order == Order.ASCENDING ? c : -c;
                    return n;
                }
                return 0;
            }
            finally {
                path1.clear();
                path2.clear();
            }
        }

        @Override
        private int compare(int v1, int v2) {
            return v1 < v2 ? -1 : (v1 > v2 ? 1 : 0);
        }

        static enum Order {
            ASCENDING,
            DESCENDING;

        }

        static class Temp {
            ArrayList<INode> path1 = new ArrayList();
            ArrayList<INode> path2 = new ArrayList();

            Temp() {
            }
        }
    }
}

