/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.events;

import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import org.simantics.scenegraph.g2d.G2DFocusManager;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.events.ListenerList;
import org.simantics.scenegraph.utils.NodeUtil;

public class EventDelegator
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener,
FocusListener {
    private static final boolean ENABLED = true;
    private static final boolean WARN_DEPRECATION = false;
    protected ListenerList<MouseListener> mouseListeners = new ListenerList<MouseListener>(MouseListener.class);
    protected ListenerList<MouseWheelListener> mouseWheelListeners = new ListenerList<MouseWheelListener>(MouseWheelListener.class);
    protected ListenerList<MouseMotionListener> mouseMotionListeners = new ListenerList<MouseMotionListener>(MouseMotionListener.class);
    protected ListenerList<KeyListener> keyListeners = new ListenerList<KeyListener>(KeyListener.class);
    protected ListenerList<FocusListener> focusListeners = new ListenerList<FocusListener>(FocusListener.class);
    protected G2DSceneGraph sg = null;

    public EventDelegator(G2DSceneGraph sg) {
        this.sg = sg;
    }

    public <T extends IG2DNode, MouseListener> void addMouseListener(T node) {
        this.mouseListeners.add((MouseListener)((Object)node));
    }

    public <T extends IG2DNode, MouseListener> void removeMouseListener(T node) {
        this.mouseListeners.remove((MouseListener)((Object)node));
    }

    public <T extends IG2DNode, MouseMotionListener> void addMouseMotionListener(T node) {
        this.mouseMotionListeners.add((MouseMotionListener)((Object)node));
    }

    public <T extends IG2DNode, MouseMotionListener> void removeMouseMotionListener(T node) {
        this.mouseMotionListeners.remove((MouseMotionListener)((Object)node));
    }

    public <T extends IG2DNode, MouseWheelListener> void addMouseWheelListener(T node) {
        this.mouseWheelListeners.add((MouseWheelListener)((Object)node));
    }

    public <T extends IG2DNode, MouseWheelListener> void removeMouseWheelListener(T node) {
        this.mouseWheelListeners.remove((MouseWheelListener)((Object)node));
    }

    public <T extends IG2DNode, KeyListener> void addKeyListener(T node) {
        this.keyListeners.add((KeyListener)((Object)node));
    }

    public <T extends IG2DNode, KeyListener> void removeKeyListener(T node) {
        this.keyListeners.remove((KeyListener)((Object)node));
    }

    public <T extends IG2DNode, FocusListener> void addFocusListener(T node) {
        this.focusListeners.add((FocusListener)((Object)node));
    }

    public <T extends IG2DNode, FocusListener> void removeFocusListener(T node) {
        this.focusListeners.remove((FocusListener)((Object)node));
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        Point op = event.getPoint();
        MouseListener[] mouseListenerArray = this.mouseListeners.getListeners();
        int n = mouseListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            MouseListener l = mouseListenerArray[n2];
            MouseEvent e = (MouseEvent)NodeUtil.transformEvent(event, (IG2DNode)((Object)l));
            l.mouseClicked(e);
            event.translatePoint((int)(op.getX() - (double)event.getX()), (int)(op.getY() - (double)event.getY()));
            if (e.isConsumed()) break;
            ++n2;
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        Point op = event.getPoint();
        MouseListener[] mouseListenerArray = this.mouseListeners.getListeners();
        int n = mouseListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            MouseListener l = mouseListenerArray[n2];
            MouseEvent e = (MouseEvent)NodeUtil.transformEvent(event, (IG2DNode)((Object)l));
            l.mouseEntered(e);
            event.translatePoint((int)(op.getX() - (double)event.getX()), (int)(op.getY() - (double)event.getY()));
            if (e.isConsumed()) break;
            ++n2;
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
        Point op = event.getPoint();
        MouseListener[] mouseListenerArray = this.mouseListeners.getListeners();
        int n = mouseListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            MouseListener l = mouseListenerArray[n2];
            MouseEvent e = (MouseEvent)NodeUtil.transformEvent(event, (IG2DNode)((Object)l));
            l.mouseExited(e);
            event.translatePoint((int)(op.getX() - (double)event.getX()), (int)(op.getY() - (double)event.getY()));
            if (e.isConsumed()) break;
            ++n2;
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        G2DFocusManager.INSTANCE.clearFocus();
        Point op = event.getPoint();
        MouseListener[] mouseListenerArray = this.mouseListeners.getListeners();
        int n = mouseListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            MouseListener l = mouseListenerArray[n2];
            MouseEvent e = (MouseEvent)NodeUtil.transformEvent(event, (IG2DNode)((Object)l));
            l.mousePressed(e);
            event.translatePoint((int)(op.getX() - (double)event.getX()), (int)(op.getY() - (double)event.getY()));
            if (e.isConsumed()) break;
            ++n2;
        }
        if (this.sg.getRootPane() != null && G2DFocusManager.INSTANCE.getFocusOwner() == null) {
            this.sg.getRootPane().requestFocusInWindow();
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        Point op = event.getPoint();
        MouseListener[] mouseListenerArray = this.mouseListeners.getListeners();
        int n = mouseListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            MouseListener l = mouseListenerArray[n2];
            MouseEvent e = (MouseEvent)NodeUtil.transformEvent(event, (IG2DNode)((Object)l));
            l.mouseReleased(e);
            event.translatePoint((int)(op.getX() - (double)event.getX()), (int)(op.getY() - (double)event.getY()));
            if (e.isConsumed()) break;
            ++n2;
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        Point op = event.getPoint();
        MouseMotionListener[] mouseMotionListenerArray = this.mouseMotionListeners.getListeners();
        int n = mouseMotionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            MouseMotionListener l = mouseMotionListenerArray[n2];
            MouseEvent e = (MouseEvent)NodeUtil.transformEvent(event, (IG2DNode)((Object)l));
            l.mouseDragged(e);
            event.translatePoint((int)(op.getX() - (double)event.getX()), (int)(op.getY() - (double)event.getY()));
            if (e.isConsumed()) break;
            ++n2;
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        MouseMotionListener[] mouseMotionListenerArray = this.mouseMotionListeners.getListeners();
        int n = mouseMotionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            MouseMotionListener l = mouseMotionListenerArray[n2];
            MouseEvent e = (MouseEvent)NodeUtil.transformEvent(event, (IG2DNode)((Object)l));
            l.mouseMoved(e);
            if (e.isConsumed()) break;
            ++n2;
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        Point op = event.getPoint();
        MouseWheelListener[] mouseWheelListenerArray = this.mouseWheelListeners.getListeners();
        int n = mouseWheelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            MouseWheelListener l = mouseWheelListenerArray[n2];
            MouseWheelEvent e = (MouseWheelEvent)NodeUtil.transformEvent(event, (IG2DNode)((Object)l));
            l.mouseWheelMoved(e);
            event.translatePoint((int)(op.getX() - (double)event.getX()), (int)(op.getY() - (double)event.getY()));
            if (e.isConsumed()) break;
            ++n2;
        }
    }

    @Override
    public void keyPressed(KeyEvent event) {
        KeyListener[] keyListenerArray = this.keyListeners.getListeners();
        int n = keyListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            KeyListener l = keyListenerArray[n2];
            l.keyPressed(event);
            if (event.isConsumed()) break;
            ++n2;
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
        KeyListener[] keyListenerArray = this.keyListeners.getListeners();
        int n = keyListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            KeyListener l = keyListenerArray[n2];
            l.keyReleased(event);
            if (event.isConsumed()) break;
            ++n2;
        }
    }

    @Override
    public void keyTyped(KeyEvent event) {
        KeyListener[] keyListenerArray = this.keyListeners.getListeners();
        int n = keyListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            KeyListener l = keyListenerArray[n2];
            l.keyTyped(event);
            if (event.isConsumed()) break;
            ++n2;
        }
    }

    @Override
    public void focusGained(FocusEvent event) {
        FocusListener[] focusListenerArray = this.focusListeners.getListeners();
        int n = focusListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            FocusListener l = focusListenerArray[n2];
            l.focusGained(event);
            ++n2;
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
        FocusListener[] focusListenerArray = this.focusListeners.getListeners();
        int n = focusListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            FocusListener l = focusListenerArray[n2];
            l.focusLost(event);
            ++n2;
        }
    }
}

