/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.IdentityAffineTransform;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.FocusEvent;
import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.g2d.events.KeyEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.NodeEventHandler;
import org.simantics.scenegraph.g2d.events.TimeEvent;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.NodeUtil;

public abstract class G2DNode
extends Node
implements IG2DNode {
    private static final long serialVersionUID = 8283264115992894707L;
    protected int z = 0;
    protected AffineTransform transform = IdentityAffineTransform.INSTANCE;

    @Override
    @INode.SyncField(value={"z"})
    public void setZIndex(int z) {
        if (z != this.z) {
            G2DParentNode parent = (G2DParentNode)this.getParent();
            if (parent != null) {
                parent.invalidateChildOrder();
            }
            this.z = z;
        }
    }

    @Override
    public int getZIndex() {
        return this.z;
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public void cleanup() {
        this.retractMapping();
        this.repaint();
    }

    @Override
    public void repaint() {
        ParentNode<?> parent = this.getParent();
        while (parent != null && !(parent instanceof G2DSceneGraph)) {
            parent = parent.getParent();
        }
        if (parent == null || ((G2DSceneGraph)parent).getRootPane() == null) {
            return;
        }
        ((G2DSceneGraph)parent).getRootPane().repaint();
    }

    @Override
    public AffineTransform getTransform() {
        return this.transform;
    }

    @Override
    @INode.PropertySetter(value="Transform")
    @INode.SyncField(value={"transform"})
    public void setTransform(AffineTransform transform) {
        assert (transform != null);
        this.transform = transform.isIdentity() ? IdentityAffineTransform.INSTANCE : transform;
    }

    @Override
    public Rectangle2D getBounds() {
        Rectangle2D local = this.getBoundsInLocal();
        if (local == null) {
            return null;
        }
        return this.transform.createTransformedShape(local).getBounds2D();
    }

    @Override
    public abstract Rectangle2D getBoundsInLocal();

    @Override
    public Rectangle2D getBoundsInLocal(boolean ignoreNulls) {
        return this.getBoundsInLocal();
    }

    @Override
    public boolean contains(Point2D point) {
        Rectangle2D bounds = this.getBounds();
        if (bounds == null) {
            return false;
        }
        return bounds.contains(point);
    }

    public boolean containsLocal(Point2D localPoint) {
        Rectangle2D bounds = this.getBoundsInLocal();
        if (bounds == null) {
            return false;
        }
        return bounds.contains(localPoint);
    }

    @Override
    public boolean intersects(Rectangle2D b) {
        if (b == null) {
            return true;
        }
        Rectangle2D a = this.getBounds();
        if (a == null) {
            return true;
        }
        double ax = a.getX();
        double ay = a.getY();
        double aw = a.getWidth();
        double ah = a.getHeight();
        double bx = b.getX();
        double by = b.getY();
        double bw = b.getWidth();
        double bh = b.getHeight();
        return ax + aw >= bx && ay + ah >= by && ax <= bx + bw && ay <= by + bh;
    }

    @Override
    public Point2D localToParent(Point2D point) {
        return this.transform.transform(point, null);
    }

    @Override
    public Rectangle2D localToParent(Rectangle2D rect) {
        return this.transform.createTransformedShape(rect).getBounds2D();
    }

    @Override
    public Point2D parentToLocal(Point2D point) {
        AffineTransform inverse = null;
        try {
            inverse = this.transform.createInverse();
            return inverse.transform(point, null);
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
            return point;
        }
    }

    public Point2D parentToLocal(Point2D src, Point2D dst) {
        AffineTransform inverse = null;
        try {
            inverse = this.transform.createInverse();
            return inverse.transform(src, dst);
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
            return src;
        }
    }

    @Override
    public Rectangle2D parentToLocal(Rectangle2D rect) {
        AffineTransform inverse = null;
        try {
            inverse = this.transform.createInverse();
            return inverse.createTransformedShape(rect).getBounds2D();
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
            return rect;
        }
    }

    @Override
    public Point2D localToControl(Point2D point) {
        Node node = this;
        while (node != null) {
            point = node.getTransform().transform(point, null);
            node = (G2DParentNode)node.getParent();
        }
        return point;
    }

    @Override
    public Rectangle2D localToControl(Rectangle2D rect) {
        Shape shape = rect;
        Node node = this;
        while (node != null) {
            shape = node.getTransform().createTransformedShape(shape);
            node = (G2DParentNode)node.getParent();
        }
        return shape.getBounds2D();
    }

    @Override
    public Point2D controlToLocal(Point2D point) {
        AffineTransform at = NodeUtil.getGlobalToLocalTransform(this, null);
        if (at == null) {
            return point;
        }
        return at.transform(point, null);
    }

    @Override
    public Rectangle2D controlToLocal(Rectangle2D rect) {
        AffineTransform at = NodeUtil.getGlobalToLocalTransform(this, null);
        if (at == null) {
            return rect;
        }
        return GeometryUtils.transformRectangle(at, rect);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " [z=" + this.z + ",transform=" + this.transform + "]";
    }

    @Override
    public G2DSceneGraph getRootNode2D() {
        ParentNode<?> root = this.getRootNode();
        return (G2DSceneGraph)root;
    }

    @Override
    public boolean hasFocus() {
        return this.getFocusNode() == this;
    }

    @Override
    public IG2DNode getFocusNode() {
        return this.getRootNode2D().getFocusNode();
    }

    @Override
    public void setFocusNode(IG2DNode node) {
        this.getRootNode2D().setFocusNode(node);
    }

    protected NodeEventHandler getEventHandler() {
        return NodeUtil.getNodeEventHandler(this);
    }

    protected void addEventHandler(IEventHandler handler) {
        this.getEventHandler().add(handler);
    }

    protected void removeEventHandler(IEventHandler handler) {
        this.getEventHandler().remove(handler);
    }

    @Override
    public int getEventMask() {
        return 0;
    }

    @Override
    public boolean handleEvent(Event e) {
        int eventType = EventTypes.toType(e);
        switch (eventType) {
            case 1: {
                return this.handleCommand((CommandEvent)e);
            }
            case 2: 
            case 3: {
                return this.handleFocusEvent((FocusEvent)e);
            }
            case 4: {
                return this.keyPressed((KeyEvent.KeyPressedEvent)e);
            }
            case 5: {
                return this.keyReleased((KeyEvent.KeyReleasedEvent)e);
            }
            case 6: {
                return this.mouseButtonPressed((MouseEvent.MouseButtonPressedEvent)e);
            }
            case 7: {
                return this.mouseButtonReleased((MouseEvent.MouseButtonReleasedEvent)e);
            }
            case 8: {
                return this.mouseClicked((MouseEvent.MouseClickEvent)e);
            }
            case 9: {
                return this.mouseDoubleClicked((MouseEvent.MouseDoubleClickedEvent)e);
            }
            case 13: {
                return this.mouseMoved((MouseEvent.MouseMovedEvent)e);
            }
            case 10: {
                return this.mouseDragged((MouseEvent.MouseDragBegin)e);
            }
            case 11: {
                return this.mouseEntered((MouseEvent.MouseEnterEvent)e);
            }
            case 12: {
                return this.mouseExited((MouseEvent.MouseExitEvent)e);
            }
            case 14: {
                return this.mouseWheelMoved((MouseEvent.MouseWheelMovedEvent)e);
            }
            case 15: {
                return this.handleTimeEvent((TimeEvent)e);
            }
        }
        return false;
    }

    protected boolean keyReleased(KeyEvent.KeyReleasedEvent e) {
        return false;
    }

    protected boolean keyPressed(KeyEvent.KeyPressedEvent e) {
        return false;
    }

    protected boolean handleCommand(CommandEvent e) {
        return false;
    }

    protected boolean handleFocusEvent(FocusEvent e) {
        return false;
    }

    protected boolean handleKeyEvent(KeyEvent e) {
        return false;
    }

    protected boolean mouseButtonPressed(MouseEvent.MouseButtonPressedEvent e) {
        return false;
    }

    protected boolean mouseButtonReleased(MouseEvent.MouseButtonReleasedEvent e) {
        return false;
    }

    protected boolean mouseClicked(MouseEvent.MouseClickEvent e) {
        return false;
    }

    protected boolean mouseDoubleClicked(MouseEvent.MouseDoubleClickedEvent e) {
        return false;
    }

    protected boolean mouseMoved(MouseEvent.MouseMovedEvent e) {
        return false;
    }

    protected boolean mouseDragged(MouseEvent.MouseDragBegin e) {
        return false;
    }

    protected boolean mouseEntered(MouseEvent.MouseEnterEvent e) {
        return false;
    }

    protected boolean mouseExited(MouseEvent.MouseExitEvent e) {
        return false;
    }

    protected boolean mouseWheelMoved(MouseEvent.MouseWheelMovedEvent e) {
        return false;
    }

    protected boolean handleTimeEvent(TimeEvent e) {
        return false;
    }

    protected void setCursor(int cursorType) {
        Container rootPane = NodeUtil.findRootPane(this);
        if (rootPane != null) {
            rootPane.setCursor(Cursor.getPredefinedCursor(cursorType));
        }
    }

    protected void setCursor(Cursor cursor) {
        Container rootPane = NodeUtil.findRootPane(this);
        if (rootPane != null) {
            rootPane.setCursor(cursor);
        }
    }
}

