/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph;

import java.beans.PropertyChangeListener;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.utils.NodeUtil;

public abstract class Node
implements INode {
    private static final long serialVersionUID = -5540999051056414851L;
    public static transient long IDCOUNTER = 1L;
    protected transient ParentNode<?> parent = null;
    protected transient INode.Location location = INode.Location.LOCAL;
    protected transient PropertyChangeListener propertyChangeListener = null;
    protected Long id = IDCOUNTER++;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public ParentNode<?> getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ParentNode<?> parent) {
        this.parent = parent;
    }

    @Override
    public ParentNode<?> getRootNode() {
        return this.parent != null ? this.parent.getRootNode() : null;
    }

    @Override
    public void remove() {
        if (this.parent != null) {
            this.parent.asyncRemoveNode(this);
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void attach() {
    }

    @Override
    public void cleanup() {
        this.retractMapping();
    }

    @Override
    public void delete() {
        this.parent.asyncRemoveNode(this);
    }

    protected void retractMapping() {
        NodeUtil.tryUnmap(this);
    }

    @Override
    public <TC> TC appendParent(String id, Class<TC> nc) {
        assert (this.parent != null);
        String identifier = "" + this.id;
        for (String s : this.parent.children.keySet()) {
            if (this.parent.children.get(s) != this) continue;
            identifier = s;
            break;
        }
        this.parent.unlinkChild(this);
        TC instance = this.parent.addNode(id, nc);
        ((ParentNode)instance).appendChild(identifier, this);
        return instance;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getSimpleClassName()) + " (" + this.id + ")";
    }

    @Override
    public String getSimpleClassName() {
        return Node.getSimpleClassName(this.getClass());
    }

    public static String getSimpleClassName(Class<?> clazz) {
        String name = clazz.getSimpleName();
        int pos = name.indexOf("$$");
        if (pos >= 0) {
            name = name.substring(0, pos);
        }
        return name;
    }

    @INode.ClientSide
    public void setLookupId(String id) {
        NodeUtil.getLookupService(this).map(id, this);
    }

    protected <T extends INode> T lookupNode(String id, Class<T> clazz) {
        return (T)((INode)NodeUtil.lookup(this, id, clazz));
    }

    protected String lookupId(INode node) {
        return NodeUtil.lookupId(node);
    }
}

