/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.wizards.functions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.simantics.browsing.ui.swt.AdaptableHintContext;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Files;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.RuntimeBindingConstructionException;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.PossibleRelatedValue;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.TransferableGraphRequest2;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.layer0.Layer0;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.datastructures.ArrayMap;
import org.simantics.utils.datastructures.Pair;

public class WizardFunctionsExportPage
extends WizardPage {
    private Text filePathField;
    private static String previouslyBrowsedFile = "";
    private Button browseDirectoriesButton;
    GraphExplorerComposite functionLibraryExplorer;
    private boolean selectionMade = false;

    public WizardFunctionsExportPage() {
        this("wizardFunctionsExportPage", null, null);
    }

    public WizardFunctionsExportPage(String pageName) {
        this(pageName, null, null);
    }

    public WizardFunctionsExportPage(String pageName, String initialPath, IStructuredSelection currentSelection) {
        super(pageName);
        this.setPageComplete(false);
        this.setTitle("Export Function Library");
        this.setDescription("Choose the Function Library and the export location, then press Finish.");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        this.createProjectsRoot(workArea);
        this.createTree(workArea);
    }

    private void createProjectsRoot(Composite workArea) {
        Label title = new Label(workArea, 0);
        title.setText("Select the export location for Function Library:");
        Composite projectGroup = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        this.filePathField = new Text(projectGroup, 2048);
        GridData directoryPathData = new GridData(4, 0, true, false);
        directoryPathData.widthHint = new PixelConverter((Control)this.filePathField).convertWidthInCharsToPixels(25);
        this.filePathField.setLayoutData((Object)directoryPathData);
        this.filePathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                previouslyBrowsedFile = WizardFunctionsExportPage.this.filePathField.getText();
            }
        });
        if (previouslyBrowsedFile != null) {
            this.filePathField.setText(previouslyBrowsedFile);
            this.validatePage();
        }
        this.browseDirectoriesButton = new Button(projectGroup, 8);
        this.browseDirectoriesButton.setText("Browse");
        this.setButtonLayoutData(this.browseDirectoriesButton);
        this.browseDirectoriesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardFunctionsExportPage.this.handleLocationDirectoryButtonPressed();
            }
        });
    }

    private void createTree(Composite workArea) {
        Label title = new Label(workArea, 0);
        title.setText("Select Function Library to export:");
        try {
            Resource input = (Resource)SimanticsUI.getSession().syncRequest((Read)new Read<Resource>(){

                public Resource perform(ReadGraph graph) throws DatabaseException {
                    Resource model = (Resource)SimanticsUI.getProject().get();
                    return model;
                }
            });
            this.functionLibraryExplorer = new GraphExplorerComposite((Map)ArrayMap.keys((Object[])new String[]{"displaySelectors", "displayFilter"}).values(new Object[]{false, false}), null, workArea, 2052);
            this.functionLibraryExplorer.setBrowseContexts(new String[]{"http://www.simantics.org/Sysdyn-1.1/FunctionTree"});
            this.functionLibraryExplorer.finish();
            this.functionLibraryExplorer.setInput(null, (Object)input);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.functionLibraryExplorer);
            ((Tree)this.functionLibraryExplorer.getExplorer().getControl()).addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    WizardFunctionsExportPage.this.setMessage(null);
                    WizardFunctionsExportPage.this.selectionMade = true;
                    WizardFunctionsExportPage.this.validatePage();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    WizardFunctionsExportPage.this.setMessage(null);
                    WizardFunctionsExportPage.this.selectionMade = true;
                    WizardFunctionsExportPage.this.validatePage();
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.filePathField.setFocus();
    }

    protected void handleLocationDirectoryButtonPressed() {
        String selectedFile;
        Shell shell = this.filePathField.getShell();
        FileDialog dialog = new FileDialog(shell, 8192);
        String[] ext = new String[]{"*.sysdynFunctions"};
        dialog.setFilterExtensions(ext);
        dialog.setText("Export Function Library");
        String dirName = this.filePathField.getText().trim();
        File path = new File(dirName);
        if (path.exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedFile = dialog.open()) != null) {
            this.filePathField.setText(selectedFile);
            this.validatePage();
        }
    }

    public static <T> T getExplorerResource(GraphExplorerComposite explorer, Class<T> clazz) {
        if (explorer == null) {
            return null;
        }
        ISelection selection = ((ISelectionProvider)explorer.getAdapter(ISelectionProvider.class)).getSelection();
        if (selection == null) {
            return null;
        }
        IStructuredSelection iss = (IStructuredSelection)selection;
        AdaptableHintContext inc = (AdaptableHintContext)iss.getFirstElement();
        if (inc == null) {
            return null;
        }
        Object resource = inc.getAdapter(clazz);
        return (T)resource;
    }

    public boolean createProjects(Resource selection) {
        final String selected = previouslyBrowsedFile;
        if (selected == null) {
            return false;
        }
        final Resource functionLibrary = WizardFunctionsExportPage.getExplorerResource(this.functionLibraryExplorer, Resource.class);
        if (functionLibrary == null) {
            return false;
        }
        String name = null;
        try {
            name = (String)SimanticsUI.getSession().syncRequest((Read)new Read<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    if (!graph.hasStatement(functionLibrary, Layer0.getInstance((ReadGraph)graph).PartOf)) {
                        return null;
                    }
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    String name = (String)graph.syncRequest((AsyncRead)new PossibleRelatedValue(functionLibrary, l0.HasName, (Binding)Bindings.STRING));
                    return name;
                }
            });
        }
        catch (DatabaseException e1) {
            e1.printStackTrace();
        }
        if (name == null) {
            return false;
        }
        SimanticsUI.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                String name = (String)graph.syncRequest((AsyncRead)new PossibleRelatedValue(functionLibrary, l0.HasName, (Binding)Bindings.STRING));
                ArrayList<Pair> roots = new ArrayList<Pair>();
                roots.add(Pair.make((Object)functionLibrary, (Object)name));
                TransferableGraph1 tg = (TransferableGraph1)graph.syncRequest((Read)new TransferableGraphRequest2(roots, functionLibrary));
                try {
                    Files.createFile((File)new File(selected), (Binding)Bindings.getBindingUnchecked(TransferableGraph1.class), (Object)tg);
                }
                catch (RuntimeBindingConstructionException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        return true;
    }

    void validatePage() {
        if (previouslyBrowsedFile.isEmpty() || !this.selectionMade) {
            this.setPageComplete(false);
            return;
        }
        if (this.functionLibraryExplorer != null) {
            final Resource selectedResource = WizardFunctionsExportPage.getExplorerResource(this.functionLibraryExplorer, Resource.class);
            String root = null;
            try {
                root = (String)SimanticsUI.getSession().syncRequest((Read)new Read<String>(){

                    public String perform(ReadGraph graph) throws DatabaseException {
                        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                        Resource model = graph.getPossibleObject(selectedResource, l0.PartOf);
                        String rootName = NameUtils.getSafeName((ReadGraph)graph, (Resource)model);
                        return rootName;
                    }
                });
                if (root != null && root.equalsIgnoreCase("Development Project")) {
                    this.setPageComplete(false);
                    this.setMessage("Select Function Library folder under the Model or from the Shared Functions folder.");
                    return;
                }
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        }
        this.setPageComplete(true);
    }
}

