/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.simantics.Simantics;
import org.simantics.db.Issue;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.issue.StandardIssue;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.indexing.IndexUtils;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.issues.common.IssueUtils;
import org.simantics.layer0.Layer0;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.SysdynModel;
import org.simantics.sysdyn.manager.SysdynModelManager;
import org.simantics.sysdyn.representation.IndependentVariable;
import org.simantics.sysdyn.representation.expressions.IExpression;
import org.simantics.sysdyn.representation.utils.UnitUtils;
import org.simantics.sysdyn.ui.validation.ModuleStandardIssue;
import org.simantics.sysdyn.utils.Function;
import org.simantics.sysdyn.utils.ModelUtils;

public class UnitFunction {
    @SCLValue(type="ReadGraph -> Resource -> [Issue]")
    public static List<Issue> unitValidator(ReadGraph graph, Resource component) throws DatabaseException {
        SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(component, SR.Variable) && !graph.isInstanceOf(component, SR.Cloud)) {
            return UnitFunction.variableValidator(graph, component);
        }
        if (graph.isInstanceOf(component, SR.Module)) {
            return UnitFunction.moduleValidator(graph, component);
        }
        return Collections.emptyList();
    }

    private static List<Issue> variableValidator(ReadGraph graph, Resource variable) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
        Resource configuration = graph.getPossibleObject(variable, L0.PartOf);
        if (configuration == null) {
            return Collections.emptyList();
        }
        String unit = null;
        if (graph.isInstanceOf(variable, SR.Shadow)) {
            Resource original = graph.getPossibleObject(variable, SR.Shadow_original);
            if (original == null) {
                return Collections.emptyList();
            }
            unit = (String)graph.getPossibleRelatedValue(original, SR.Variable_unit);
        } else {
            unit = (String)graph.getPossibleRelatedValue(variable, SR.Variable_unit);
        }
        if (unit == null || unit.trim().length() == 0) {
            return Collections.singletonList(new StandardIssue(SR.Validations_UnitWarning, new Resource[]{variable}));
        }
        if (!graph.isInstanceOf(variable, SR.IndependentVariable)) {
            return Collections.emptyList();
        }
        Resource expressionList = graph.getPossibleObject(variable, SR.Variable_expressionList);
        if (expressionList == null) {
            return Collections.emptyList();
        }
        SysdynModelManager smm = SysdynModelManager.getInstance((Session)graph.getSession());
        SysdynModel sm = smm.getModel(graph, configuration);
        sm.getMapping().domainModified(variable);
        sm.update(graph);
        Object var = sm.getMapping().get(variable);
        ArrayList<Issue> issues = new ArrayList<Issue>();
        for (Resource expression : ListUtils.toList((ReadGraph)graph, (Resource)expressionList)) {
            String result;
            for (Resource r : graph.getObjects(expression, SR.Expression_equation)) {
                graph.getValue(r);
            }
            sm.getMapping().domainModified(expression);
            sm.update(graph);
            Object expr = sm.getMapping().get(expression);
            if (expr == null || var == null || !(expr instanceof IExpression) || !(var instanceof IndependentVariable) || (result = ((IExpression)expr).validateUnits(graph, sm)) == null) continue;
            StandardIssue issue = new StandardIssue(SR.Validations_UnitWarning, new Resource[]{variable, expression, graph.getPossibleObject(variable, SR.Variable_unit)});
            issues.add((Issue)issue);
        }
        return issues;
    }

    private static List<Issue> moduleValidator(ReadGraph graph, Resource module) throws DatabaseException {
        ArrayList functions;
        String right;
        String left;
        Resource reference;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
        if (module == null) {
            return Collections.emptyList();
        }
        Resource configuration = graph.getPossibleObject(module, L0.PartOf);
        if (configuration == null) {
            return Collections.emptyList();
        }
        SysdynModel model = ModelUtils.getModel((ReadGraph)graph, (Resource)module);
        String result = null;
        ArrayList<Issue> issues = new ArrayList<Issue>();
        for (Resource outputRelation : graph.getObjects(module, SR.Variable_isTailOf)) {
            Resource output;
            reference = graph.getPossibleObject(outputRelation, SR.Dependency_refersTo);
            if (reference == null || (output = graph.getPossibleObject(outputRelation, SR.Variable_HasHead)) == null || (result = UnitUtils.matchUnits((String)(left = (String)graph.getPossibleRelatedValue(output, SR.Variable_unit)), (String)(right = (String)graph.getPossibleRelatedValue(reference, SR.Variable_unit)), (ArrayList)(functions = Function.getAllBuiltInFunctions((ReadGraph)graph)), (boolean)UnitUtils.allowEquivalents((ReadGraph)graph, (SysdynModel)model))) == null) continue;
            issues.add((Issue)new ModuleStandardIssue(SR.Validations_ModuleOutputUnitWarning, module, output, reference));
        }
        for (Resource inputRelation : graph.getObjects(module, SR.Variable_isHeadOf)) {
            Resource variable;
            reference = graph.getPossibleObject(inputRelation, SR.Dependency_refersTo);
            if (reference == null || (variable = graph.getPossibleObject(inputRelation, SR.Variable_HasTail)) == null || (result = UnitUtils.matchUnits((String)(left = (String)graph.getPossibleRelatedValue(variable, SR.Variable_unit)), (String)(right = (String)graph.getPossibleRelatedValue(reference, SR.Variable_unit)), (ArrayList)(functions = Function.getAllBuiltInFunctions((ReadGraph)graph)), (boolean)UnitUtils.allowEquivalents((ReadGraph)graph, (SysdynModel)model))) == null) continue;
            issues.add((Issue)new ModuleStandardIssue(SR.Validations_ModuleInputUnitWarning, module, variable, reference));
        }
        return issues;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String unitWarningDescription(ReadGraph graph, Resource converter, Variable property) throws DatabaseException {
        List contexts = IssueUtils.getContextsForProperty((ReadGraph)graph, (Variable)property);
        if (contexts.size() == 0) {
            return "Error, No contexts";
        }
        Resource variable = (Resource)contexts.get(0);
        String unit = (String)graph.getPossibleRelatedValue(variable, SysdynResource.getInstance((ReadGraph)graph).Variable_unit);
        if (unit == null || unit.length() == 0) {
            return "No unit defined";
        }
        if (contexts.size() < 2) {
            return "Error, not enough contexts";
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource configuration = graph.getPossibleObject(variable, L0.PartOf);
        if (configuration == null) {
            return "Error, No Confiugration";
        }
        SysdynModelManager smm = SysdynModelManager.getInstance((Session)graph.getSession());
        SysdynModel sm = smm.getModel(graph, configuration);
        SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
        for (Resource r : graph.getObjects((Resource)contexts.get(1), SR.Expression_equation)) {
            graph.getValue(r);
        }
        Object expr = sm.getMapping().get((Resource)contexts.get(1));
        String result = ((IExpression)expr).validateUnits(graph, sm);
        return result;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String moduleOutputUnitWarningDescription(ReadGraph graph, Resource converter, Variable property) throws DatabaseException {
        List contexts = IssueUtils.getContextsForProperty((ReadGraph)graph, (Variable)property);
        if (contexts.size() < 3) {
            return "Error, No contexts";
        }
        Resource output = (Resource)contexts.get(1);
        Resource reference = (Resource)contexts.get(2);
        return UnitFunction.moduleInterfaceDescription(graph, output, reference, "Module output has different unit. (", ")");
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String moduleInputUnitWarningDescription(ReadGraph graph, Resource converter, Variable property) throws DatabaseException {
        List contexts = IssueUtils.getContextsForProperty((ReadGraph)graph, (Variable)property);
        if (contexts.size() < 3) {
            return "Error, No contexts";
        }
        Resource output = (Resource)contexts.get(1);
        Resource reference = (Resource)contexts.get(2);
        return UnitFunction.moduleInterfaceDescription(graph, output, reference, "Module input has different unit. (", ")");
    }

    private static String moduleInterfaceDescription(ReadGraph graph, Resource leftResource, Resource rightResource, String prefix, String suffix) throws DatabaseException {
        if (leftResource == null) {
            return "Erroneus error: left == null";
        }
        if (rightResource == null) {
            return "Erroneus error: right == null";
        }
        SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
        String left = (String)graph.getPossibleRelatedValue(leftResource, SR.Variable_unit);
        if (left == null || left.isEmpty()) {
            return "No unit defined for " + NameUtils.getSafeName((ReadGraph)graph, (Resource)leftResource);
        }
        String right = (String)graph.getPossibleRelatedValue(rightResource, SR.Variable_unit);
        if (right == null || right.isEmpty()) {
            return "No unit defined for " + NameUtils.getSafeName((ReadGraph)graph, (Resource)rightResource);
        }
        SysdynModel model = ModelUtils.getModel((ReadGraph)graph, (Resource)leftResource);
        ArrayList functions = Function.getAllBuiltInFunctions((ReadGraph)graph);
        String result = UnitUtils.matchUnits((String)left, (String)right, (ArrayList)functions, (boolean)UnitUtils.allowEquivalents((ReadGraph)graph, (SysdynModel)model));
        if (result != null) {
            result = String.valueOf(prefix) + result + suffix;
        }
        return result;
    }

    @SCLValue(type="ReadGraph -> [Resource] -> [Resource]")
    public static List<Resource> moduleInterfaceExtension(ReadGraph graph, List<Resource> rs) throws DatabaseException {
        SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
        HashSet<Resource> components = new HashSet<Resource>();
        HashSet<Resource> searchedModuleTypes = new HashSet<Resource>();
        for (Resource r : rs) {
            Resource connection2;
            if (!graph.isInstanceOf(r, SR.Variable)) continue;
            if (graph.isInstanceOf(r, SR.Input) && (connection2 = graph.getPossibleObject(r, SR.Variable_isHeadOf)) != null) {
                components.add(graph.getPossibleObject(connection2, SR.Variable_HasTail));
            }
            for (Resource connection2 : graph.getObjects(r, SR.Variable_isTailOf)) {
                Resource head = graph.getPossibleObject(connection2, SR.Variable_HasHead);
                if (head == null || !graph.isInstanceOf(head, SR.Module)) continue;
                components.add(head);
            }
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            Resource configuration = graph.getPossibleObject(r, L0.PartOf);
            Resource possibleModule = graph.getPossibleObject(configuration, L0.PartOf);
            if (!graph.isInheritedFrom(possibleModule, SR.Module) || searchedModuleTypes.contains(possibleModule)) continue;
            searchedModuleTypes.add(possibleModule);
            for (Resource model : (Collection)graph.syncRequest((Read)new ObjectsWithType((Resource)Simantics.getProject().get(), L0.ConsistsOf, SR.SysdynModel))) {
                Collection found = IndexUtils.findByType((ReadGraph)graph, (Resource)model, (Resource)possibleModule);
                components.addAll(found);
            }
        }
        if (!components.isEmpty()) {
            rs.addAll(components);
        }
        return rs;
    }
}

