/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.utils;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.SysdynModel;
import org.simantics.sysdyn.representation.Configuration;
import org.simantics.sysdyn.representation.IElement;
import org.simantics.sysdyn.representation.Module;
import org.simantics.sysdyn.representation.Shadow;
import org.simantics.sysdyn.representation.Sheet;
import org.simantics.sysdyn.representation.Variable;
import org.simantics.sysdyn.ui.modelica.ModelicaSourceViewerConfiguration;
import org.simantics.sysdyn.utils.Function;
import org.simantics.ui.SimanticsUI;

public abstract class NameValidator {
    protected abstract boolean nameIsTaken(ReadGraph var1, Resource var2, String var3) throws DatabaseException;

    public abstract void renameInEquations(WriteGraph var1, Resource var2, String var3, String var4) throws DatabaseException;

    public abstract void renameInAllEquations(WriteGraph var1, Resource var2, String var3, String var4) throws DatabaseException;

    public boolean isValid(ReadGraph graph, Resource resource, String name) throws DatabaseException {
        if (name.length() < 1) {
            return false;
        }
        if (this.nameIsTaken(graph, resource, name)) {
            return false;
        }
        boolean allowSpaces = this.doesResourceAllowSpacedName(graph, resource);
        return this.isValidModelica(name, allowSpaces);
    }

    protected boolean doesResourceAllowSpacedName(ReadGraph graph, Resource resource) {
        SpreadsheetResource sheet;
        SysdynResource sr;
        block4: {
            sr = SysdynResource.getInstance((ReadGraph)graph);
            sheet = SpreadsheetResource.getInstance((ReadGraph)graph);
            if (resource != null) break block4;
            return false;
        }
        try {
            if (graph.isInstanceOf(resource, sr.Variable) || graph.isInstanceOf(resource, sr.Enumeration) || graph.isInstanceOf(resource, sr.EnumerationIndex) || graph.isInstanceOf(resource, sheet.Spreadsheet) || graph.isInstanceOf(resource, sr.SysdynModel)) {
                return true;
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean isValid(final Resource resource, final String name) {
        boolean result = false;
        try {
            result = (Boolean)SimanticsUI.getSession().syncRequest((Read)new Read<Boolean>(){

                public Boolean perform(ReadGraph graph) throws DatabaseException {
                    return NameValidator.this.isValid(graph, resource, name);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean isValidModelica(String name, boolean allowSpaces) {
        String[] splitNames;
        String lowerCase = name.toLowerCase();
        String pattern = "[a-zA-Z][a-zA-Z0-9]*" + (allowSpaces ? "( [a-zA-Z][a-zA-Z0-9]*)*" : "");
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(lowerCase);
        if (!m.matches()) {
            return false;
        }
        String[] stringArray = splitNames = name.split("\\s+");
        int n = splitNames.length;
        int n2 = 0;
        while (n2 < n) {
            String splitName = stringArray[n2];
            if (ModelicaSourceViewerConfiguration.keywords.contains(splitName)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected boolean nameTakenBySheet(ReadGraph graph, Resource configurationResource, Resource resource, String name) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
        for (Resource r : graph.getObjects(configurationResource, l0.ConsistsOf)) {
            if (!graph.isInstanceOf(r, SHEET.Book)) continue;
            for (Resource s : graph.getObjects(r, l0.ConsistsOf)) {
                if (!NameUtils.getSafeName((ReadGraph)graph, (Resource)s).equals(name) || s.equals(resource)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean nameTakenBySheet(SysdynModel sysdynModel, String name) {
        Configuration configuration = sysdynModel.getConfiguration();
        if (configuration == null) {
            return true;
        }
        for (IElement e : configuration.getElements()) {
            if (!(e instanceof Sheet) || !((Sheet)e).getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    protected boolean nameTakenByItemUnderLibrary(ReadGraph graph, Resource library, Resource resource, String name) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource r : graph.getObjects(library, l0.ConsistsOf)) {
            if (!NameUtils.getSafeName((ReadGraph)graph, (Resource)r).equals(name) || r.equals(resource)) continue;
            return true;
        }
        return false;
    }

    protected boolean nameTakenBySharedFunctionLibrary(ReadGraph graph, Resource model, Resource resource, String name) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        Collection linkedResources = graph.getObjects(model, l0.IsLinkedTo);
        for (Resource r : linkedResources) {
            if (!graph.isInstanceOf(r, sr.SharedFunctionOntology) || !NameUtils.getSafeName((ReadGraph)graph, (Resource)r).equals(name) || r.equals(resource)) continue;
            return true;
        }
        return false;
    }

    protected boolean nameTakenByBuiltInFunction(ReadGraph graph, String name) throws DatabaseException {
        for (Function f : Function.getAllBuiltInFunctions((ReadGraph)graph)) {
            if (!f.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    protected boolean nameTakenByTopLevelVariableOrModule(ReadGraph graph, SysdynModel sysdynModel, Resource resource, String name) throws DatabaseException {
        Configuration configuration = sysdynModel.getConfiguration();
        if (configuration == null) {
            return true;
        }
        IElement current = sysdynModel.getElement(resource);
        for (IElement e : configuration.getElements()) {
            Module m;
            Variable v;
            if (!(e instanceof Variable && !(e instanceof Shadow) ? !(v = (Variable)e).equals(current) && v.getName() != null && v.getName().equals(name) : e instanceof Module && !(m = (Module)e).equals(current) && m.getName() != null && m.getName().equals(name))) continue;
            return true;
        }
        return false;
    }

    protected boolean nameTakenByFunctionFunctionLibraryOrModuleType(ReadGraph graph, Resource library, String name) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        for (Resource r : graph.getObjects(library, l0.ConsistsOf)) {
            if (!graph.isInstanceOf(r, sr.SysdynModelicaFunctionLibrary) && !graph.isInstanceOf(r, sr.SysdynModelicaFunction) && !graph.isInheritedFrom(r, sr.Module) || !NameUtils.getSafeName((ReadGraph)graph, (Resource)r).equals(name)) continue;
            return true;
        }
        return false;
    }
}

