/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.utils;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.expressionParser.ExpressionParser;
import org.simantics.sysdyn.expressionParser.ParseException;
import org.simantics.sysdyn.expressionParser.Token;
import org.simantics.sysdyn.expressionParser.TokenMgrError;
import org.simantics.sysdyn.manager.SysdynModel;
import org.simantics.sysdyn.manager.SysdynModelManager;
import org.simantics.sysdyn.representation.Configuration;
import org.simantics.sysdyn.representation.Enumeration;
import org.simantics.sysdyn.representation.EnumerationIndex;
import org.simantics.sysdyn.representation.IElement;
import org.simantics.sysdyn.representation.Model;
import org.simantics.sysdyn.representation.Module;
import org.simantics.sysdyn.representation.Sheet;
import org.simantics.sysdyn.representation.Variable;
import org.simantics.sysdyn.ui.properties.widgets.expressions.ExpressionField;
import org.simantics.sysdyn.ui.properties.widgets.expressions.IExpression;
import org.simantics.sysdyn.ui.utils.ArrayVariableUtils;
import org.simantics.sysdyn.ui.utils.SyntaxError;
import org.simantics.ui.SimanticsUI;

public class ExpressionUtils {
    public static boolean isParameter(String expression) {
        try {
            Double.parseDouble(expression.trim());
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static Color variableFoundColor(LocalResourceManager resourceManager) {
        return resourceManager.createColor(ColorDescriptor.createFrom((RGB)new RGB(0, 0, 0)));
    }

    public static Color variableNotFoundColor(LocalResourceManager resourceManager) {
        return resourceManager.createColor(ColorDescriptor.createFrom((RGB)new RGB(255, 125, 0)));
    }

    public static Color variableTimeAndSelfColor(LocalResourceManager resourceManager) {
        return resourceManager.createColor(ColorDescriptor.createFrom((RGB)new RGB(127, 127, 127)));
    }

    public static void validateExpressionFields(final Resource variable, IExpression expression, Table variableTable, LocalResourceManager resourceManager) {
        HashMap<ExpressionField, ArrayList<Position>> positions;
        if (variable == null || expression == null || variableTable == null) {
            return;
        }
        Resource configuration = null;
        try {
            configuration = (Resource)SimanticsUI.getSession().syncRequest((Read)new Read<Resource>(){

                public Resource perform(ReadGraph graph) throws DatabaseException {
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    Resource configuration = variable;
                    while (configuration != null) {
                        if ((configuration = graph.getPossibleObject(configuration, Layer0.getInstance((ReadGraph)graph).PartOf)) == null || graph.isInstanceOf(configuration, sr.Configuration)) break;
                    }
                    return configuration;
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return;
        }
        if (configuration == null) {
            return;
        }
        ExpressionParser parser = new ExpressionParser((Reader)new StringReader(""));
        HashSet<String> variables = new HashSet<String>();
        HashMap<ExpressionField, HashMap<String, List<Token>>> references = new HashMap<ExpressionField, HashMap<String, List<Token>>>();
        HashMap<ExpressionField, HashMap> ranges = new HashMap<ExpressionField, HashMap>();
        HashMap<ExpressionField, HashMap> forIndices = new HashMap<ExpressionField, HashMap>();
        HashMap<ExpressionField, HashMap> enumerationReferences = new HashMap<ExpressionField, HashMap>();
        HashMap<ExpressionField, HashMap> functionReferences = new HashMap<ExpressionField, HashMap>();
        boolean parsingSucceeded = false;
        for (ExpressionField ef : expression.getExpressionFields()) {
            ef.resetAnnotations();
            String textString = ef.getExpression();
            parser.ReInit((Reader)new StringReader(textString));
            try {
                parser.expr();
                HashMap refs = parser.getReferences();
                references.put(ef, refs);
                variables.addAll(refs.keySet());
                ranges.put(ef, parser.getRanges());
                forIndices.put(ef, parser.getForIndices());
                enumerationReferences.put(ef, parser.getEnumerationReferences());
                functionReferences.put(ef, parser.getFunctionCallReferences());
                parsingSucceeded = true;
            }
            catch (ParseException e1) {
                ef.setSyntaxError(new SyntaxError(e1.currentToken, "Syntax Error"));
                if (!textString.equals("")) continue;
                parsingSucceeded = true;
            }
            catch (TokenMgrError err) {
                ef.setSyntaxError(new SyntaxError(0, textString.length(), "SyntaxError", "Expression contains unsupported characters"));
            }
        }
        SysdynModelManager sdm = SysdynModelManager.getInstance((Session)SimanticsUI.getSession());
        SysdynModel model = sdm.getModel(configuration);
        Configuration conf = model.getConfiguration();
        HashMap<String, Variable> modelVariables = new HashMap<String, Variable>();
        HashSet<String> ignoreVariables = new HashSet<String>();
        if (!variables.isEmpty() || !functionReferences.isEmpty()) {
            HashSet<String> noSuchVariables = new HashSet<String>();
            ArrayList elements = conf.getElements();
            for (IElement e : elements) {
                if (e instanceof Variable) {
                    Variable v = (Variable)e;
                    modelVariables.put(v.getName(), v);
                    continue;
                }
                if (!(e instanceof Module)) continue;
                ignoreVariables.add(((Module)e).getName());
            }
            if (variables.contains("time")) {
                variables.remove("time");
            }
            for (ExpressionField ef : forIndices.keySet()) {
                for (Token t : ((HashMap)forIndices.get((Object)ef)).keySet()) {
                    if (!variables.contains(t.image)) continue;
                    variables.remove(t.image);
                }
            }
            for (ExpressionField ef : functionReferences.keySet()) {
                for (String key : ((HashMap)functionReferences.get((Object)ef)).keySet()) {
                    List<SyntaxError> errors = ExpressionUtils.examineSheetReferences(conf, key, (List)((HashMap)functionReferences.get((Object)ef)).get(key), ef.getExpression(), references.get((Object)ef));
                    if (errors == null) continue;
                    for (SyntaxError error : errors) {
                        ef.setSyntaxError(error);
                    }
                }
            }
            for (String v : variables) {
                ReferenceOption option = ExpressionUtils.getReferenceOption(conf, v);
                switch (option) {
                    case DOES_NOT_EXIST: {
                        noSuchVariables.add(v);
                        break;
                    }
                    case CANNOT_BE_CONNECTED: {
                        ignoreVariables.add(v);
                    }
                }
            }
            if (!noSuchVariables.isEmpty()) {
                noSuchVariables.removeAll(ignoreVariables);
                for (String s : noSuchVariables) {
                    variables.remove(s);
                }
                positions = ExpressionUtils.getPositionsForVariables(references, noSuchVariables);
                for (ExpressionField ef : positions.keySet()) {
                    ef.setNoSuchVariableAnnotations((List<Position>)positions.get((Object)ef));
                }
            }
        }
        String selfName = null;
        if (variableTable != null && !variableTable.isDisposed()) {
            try {
                selfName = (String)SimanticsUI.getSession().syncRequest((Read)new Read<String>(){

                    public String perform(ReadGraph graph) throws DatabaseException {
                        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                        Object selfName = graph.getPossibleRelatedValue(variable, l0.HasName);
                        if (selfName != null) {
                            return (String)selfName;
                        }
                        return null;
                    }
                });
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
            TableItem[] connectedVariables = variableTable.getItems();
            TableItem[] tableItemArray = connectedVariables;
            int option = connectedVariables.length;
            int ef = 0;
            while (ef < option) {
                TableItem ti = tableItemArray[ef];
                if (ti.getText().equals("time") || ti.getText().equals(selfName)) {
                    ti.setForeground(ExpressionUtils.variableTimeAndSelfColor(resourceManager));
                } else if (parsingSucceeded && !variables.contains(ti.getText())) {
                    ti.setForeground(ExpressionUtils.variableNotFoundColor(resourceManager));
                } else if (parsingSucceeded) {
                    ti.setForeground(ExpressionUtils.variableFoundColor(resourceManager));
                    variables.remove(ti.getText());
                }
                ++ef;
            }
            variables.removeAll(ignoreVariables);
            variables.remove(selfName);
            if (!variables.isEmpty()) {
                positions = ExpressionUtils.getPositionsForVariables(references, variables);
                for (ExpressionField ef2 : positions.keySet()) {
                    ef2.setMissingLinkAnnotations((List<Position>)positions.get((Object)ef2));
                }
            }
        }
        for (ExpressionField ef : ranges.keySet()) {
            ArrayList<SyntaxError> errors = new ArrayList<SyntaxError>();
            errors.addAll(ExpressionUtils.examineArrayRanges(conf, (HashMap)ranges.get((Object)ef), (HashMap)forIndices.get((Object)ef)));
            errors.addAll(ExpressionUtils.examineEnumerationReferences(conf, (HashMap)enumerationReferences.get((Object)ef)));
            for (SyntaxError error : errors) {
                ef.setSyntaxError(error);
            }
        }
    }

    public static List<SyntaxError> examineArrayRanges(final Configuration configuration, final HashMap<String, List<List<Token>>> ranges, final HashMap<Token, List<Token>> forIndices) {
        List result = Collections.emptyList();
        try {
            result = (List)SimanticsUI.getSession().syncRequest((Read)new Read<List<SyntaxError>>(){

                public List<SyntaxError> perform(ReadGraph graph) throws DatabaseException {
                    return ExpressionUtils.examineArrayRanges(graph, configuration, ranges, forIndices);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static List<SyntaxError> examineEnumerationReferences(Configuration configuration, HashMap<String, List<Token>> enumRefList) {
        ArrayList<SyntaxError> result = new ArrayList<SyntaxError>();
        for (String enumeration : enumRefList.keySet()) {
            for (Token et : enumRefList.get(enumeration)) {
                Object o = ExpressionUtils.getElement(configuration, enumeration);
                if (o != null && o instanceof Enumeration) {
                    boolean isFound = false;
                    Enumeration e = (Enumeration)o;
                    if (enumeration.equals(et.image) || "size".equals(et.image) || "elements".equals(et.image)) {
                        isFound = true;
                    } else {
                        for (EnumerationIndex ei : e.getEnumerationIndexes()) {
                            if (!ei.getName().equals(et.image)) continue;
                            isFound = true;
                            break;
                        }
                    }
                    if (isFound) continue;
                    StringBuilder sb = new StringBuilder();
                    sb.append("Enumeration ");
                    sb.append(enumeration);
                    sb.append(" has no such index.\nAvailable indexes are: ");
                    Iterator iterator = e.getEnumerationIndexes().iterator();
                    while (iterator.hasNext()) {
                        sb.append(((EnumerationIndex)iterator.next()).getName());
                        if (!iterator.hasNext()) continue;
                        sb.append(", ");
                    }
                    result.add(new SyntaxError(et, sb.toString()));
                    continue;
                }
                result.add(new SyntaxError(et, "No such enumeration (" + enumeration + ")"));
            }
        }
        return result;
    }

    public static List<SyntaxError> examineArrayRanges(ReadGraph graph, Configuration configuration, HashMap<String, List<List<Token>>> ranges, HashMap<Token, List<Token>> forIndices) throws DatabaseException {
        HashMap<Token, SyntaxError> errors = new HashMap<Token, SyntaxError>();
        for (String name : ranges.keySet()) {
            if (ranges.get(name) == null) continue;
            for (List<Token> l : ranges.get(name)) {
                Map<Integer, SyntaxError> invalidRanges;
                String[] rangeReferences = new String[l.size()];
                int i = 0;
                while (i < l.size()) {
                    rangeReferences[i] = l.get((int)i).image;
                    ++i;
                }
                Object o = ExpressionUtils.getElement(configuration, name);
                if (o == null || !(o instanceof Variable) || (invalidRanges = ArrayVariableUtils.isRangeValid(graph, (Variable)o, rangeReferences)) == null || invalidRanges.isEmpty()) continue;
                for (Integer i2 : invalidRanges.keySet()) {
                    SyntaxError error = invalidRanges.get(i2);
                    error.setToken(l.get(i2));
                    errors.put(l.get(i2), error);
                }
            }
        }
        HashSet<Token> removes = new HashSet<Token>();
        for (Token t : forIndices.keySet()) {
            for (Token rt : errors.keySet()) {
                if (!rt.image.equals(t.image)) continue;
                removes.add(rt);
            }
        }
        for (Token t : removes) {
            errors.remove(t);
        }
        return new ArrayList<SyntaxError>(errors.values());
    }

    public static List<SyntaxError> examineSheetReferences(Configuration configuration, String functionKey, List<Token> functionTokens, String expression, HashMap<String, List<Token>> expressionReferences) {
        ArrayList<SyntaxError> result = new ArrayList<SyntaxError>();
        String[] parts = functionKey.split("\\.");
        Object current = configuration;
        int i = 0;
        while (i < parts.length && current != null) {
            current = ExpressionUtils.getElement(current, parts[i]);
            ++i;
        }
        if (current == null && configuration.getModuleType() != null && (current = configuration.getModuleType().getParent()) instanceof Model) {
            current = ExpressionUtils.getElement(((Model)current).getModelConfiguration(), parts[0]);
        }
        if (current != null && current instanceof Sheet) {
            Sheet sheet = (Sheet)current;
            int start = 0;
            int end = 0;
            int call = 0;
            String cellOrRange = null;
            while ((call = expression.indexOf(functionKey, end)) >= 0) {
                start = expression.indexOf("(", call) + 1;
                end = expression.indexOf(")", start);
                if (start < 0 || end < 0 || end < start) break;
                Pattern p = Pattern.compile("[-\\+\\*\\/\\(\\)\\{\\}\\[\\],\\.\\t\\n\\r\\f]");
                Matcher m = p.matcher(cellOrRange = expression.substring(start, end));
                if (!m.find() && cellOrRange.split(":").length <= 2) continue;
                result.add(new SyntaxError(start, end - start, "SyntaxError", "Not a valid cell or range", cellOrRange));
            }
            for (Token cell : functionTokens) {
                List<Token> refs = expressionReferences.get(cell.image);
                if (refs != null) {
                    refs.remove(cell);
                }
                if (sheet.getCells().containsKey((Object)cell.image)) continue;
                result.add(new SyntaxError(cell.image, "Invalid cell", cell.beginLine, cell.beginColumn, cell.endLine, cell.endColumn));
            }
        }
        return result;
    }

    public static ReferenceOption getReferenceOption(Configuration conf, String name) {
        String[] parts = name.split("\\.");
        Object element = conf;
        int i = 0;
        while (i < parts.length && element != null) {
            element = ExpressionUtils.getElement(element, parts[i]);
            ++i;
        }
        if (element == null) {
            return ReferenceOption.DOES_NOT_EXIST;
        }
        if (Boolean.TRUE.equals(element)) {
            return ReferenceOption.CANNOT_BE_CONNECTED;
        }
        if (element instanceof Variable || element instanceof Module) {
            if (element instanceof Enumeration || element instanceof Sheet || element instanceof Module || parts.length > 1) {
                return ReferenceOption.CANNOT_BE_CONNECTED;
            }
            return ReferenceOption.CAN_BE_CONNECTED;
        }
        return ReferenceOption.DOES_NOT_EXIST;
    }

    private static Object getElement(Object parent, String name) {
        block9: {
            Enumeration e2;
            block10: {
                block8: {
                    Configuration c = null;
                    if (parent instanceof Module) {
                        Module m = (Module)parent;
                        c = m.getType().getConfiguration();
                    } else if (parent instanceof Configuration) {
                        c = (Configuration)parent;
                    }
                    if (c == null) break block8;
                    for (Enumeration e2 : c.getElements()) {
                        if (e2 instanceof Variable && ((Variable)e2).getName().equals(name)) {
                            return e2;
                        }
                        if (!(e2 instanceof Module) || !((Module)e2).getName().equals(name)) continue;
                        return e2;
                    }
                    break block9;
                }
                if (!(parent instanceof Sheet)) break block10;
                Sheet s = (Sheet)parent;
                for (String key : s.getCells().keySet()) {
                    if (!key.equals(name)) continue;
                    return Boolean.TRUE;
                }
                break block9;
            }
            if (!(parent instanceof Enumeration)) break block9;
            e2 = (Enumeration)parent;
            if (name.equals("size") || name.equals("elements")) {
                return Boolean.TRUE;
            }
            for (EnumerationIndex ei : e2.getEnumerationIndexes()) {
                if (!ei.getName().equals(name)) continue;
                return Boolean.TRUE;
            }
        }
        return null;
    }

    private static HashMap<ExpressionField, ArrayList<Position>> getPositionsForVariables(HashMap<ExpressionField, HashMap<String, List<Token>>> references, Set<String> variables) {
        HashMap<ExpressionField, ArrayList<Position>> result = new HashMap<ExpressionField, ArrayList<Position>>();
        for (String s : variables) {
            List<Object> tlist = new ArrayList();
            for (ExpressionField ef : references.keySet()) {
                ArrayList<Position> positions = new ArrayList<Position>();
                tlist = references.get((Object)ef).get(s);
                if (tlist != null) {
                    for (Token token : tlist) {
                        StyledText st = ef.getSourceViewer().getTextWidget();
                        if (st == null) continue;
                        int start = st.getOffsetAtLine(token.beginLine - 1) + token.beginColumn - 1;
                        int offset = st.getOffsetAtLine(token.endLine - 1) + token.endColumn - start;
                        positions.add(new Position(start, offset));
                    }
                }
                if (result.keySet().contains((Object)ef)) {
                    result.get((Object)ef).addAll((ArrayList)positions.clone());
                    continue;
                }
                result.put(ef, (ArrayList)positions.clone());
            }
        }
        return result;
    }

    public static enum ReferenceOption {
        DOES_NOT_EXIST,
        CAN_BE_CONNECTED,
        CANNOT_BE_CONNECTED;

    }
}

