/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.trend;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DefaultPieDataset;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.request.PossibleActiveExperiment;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.diagram.G2DUtils;
import org.simantics.jfreechart.chart.AbstractDataset;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.operation.Layer0X;
import org.simantics.sysdyn.Functions;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.sysdyn.adapter.VariableRVIUtils;
import org.simantics.sysdyn.manager.SysdynDataSet;
import org.simantics.ui.SimanticsUI;

public class PieDataset
extends AbstractDataset
implements org.simantics.jfreechart.chart.PieDataset<String> {
    private List<Resource> seriesList;
    private String realizationURI;
    private DefaultPieDataset dataset;
    private HashMap<String, Color> colorMap;
    private HashMap<String, Boolean> explodedMap;
    private DatasetListener listener;

    public PieDataset(ReadGraph graph, Resource resource) throws DatabaseException {
        super(graph, resource);
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
        JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
        Resource model = resource;
        while ((model = graph.getPossibleObject(model, l0.PartOf)) != null && !graph.isInstanceOf(model, mr.StructuralModel)) {
        }
        this.realizationURI = null;
        Resource realization = (Resource)graph.syncRequest((Read)new PossibleActiveExperiment(model));
        if (realization == null) {
            Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
            realization = graph.getPossibleObject(model, L0X.HasBaseRealization);
        }
        if (realization != null) {
            this.realizationURI = graph.getURI(realization);
        }
        if (this.realizationURI == null) {
            return;
        }
        Resource seriesList = graph.getPossibleObject(resource, jfree.Dataset_seriesList);
        if (seriesList != null) {
            this.seriesList = ListUtils.toList((ReadGraph)graph, (Resource)seriesList);
        }
    }

    public HashMap<String, Color> getColorMap() {
        return this.colorMap;
    }

    public HashMap<String, Boolean> getExplodedMap() {
        return this.explodedMap;
    }

    public Dataset getDataset() {
        if (this.seriesList == null || this.seriesList.isEmpty() || SimanticsUI.getSession() == null) {
            return null;
        }
        if (this.dataset == null) {
            this.dataset = new DefaultPieDataset();
        }
        if (this.listener == null) {
            this.listener = new DatasetListener();
            SimanticsUI.getSession().asyncRequest((Read)new Read<ArrayList<TempSeries>>(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public ArrayList<TempSeries> perform(ReadGraph graph) throws DatabaseException {
                    JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
                    ArrayList<TempSeries> series = new ArrayList<TempSeries>();
                    if (PieDataset.this.seriesList != null) {
                        PieDataset.this.colorMap = new HashMap();
                        PieDataset.this.explodedMap = new HashMap();
                        for (Resource r : PieDataset.this.seriesList) {
                            String label = (String)graph.getPossibleRelatedValue(r, Layer0.getInstance((ReadGraph)graph).HasLabel);
                            String rvi = (String)graph.getPossibleRelatedValue(r, jfree.variableRVI);
                            if (rvi == null) continue;
                            try {
                                ArrayList result2;
                                Resource c = graph.getPossibleObject(r, jfree.color);
                                Color color = c == null ? null : G2DUtils.getColor((ReadGraph)graph, (Resource)c);
                                Boolean exploded = (Boolean)graph.getPossibleRelatedValue(r, jfree.Series_exploded, (Binding)Bindings.BOOLEAN);
                                Variable v = Variables.getVariable((ReadGraph)graph, (String)(String.valueOf(PieDataset.this.realizationURI) + rvi));
                                Variable dsVariable = v.browsePossible(graph, "#" + Functions.ACTIVE_DATASETS + "#");
                                if (dsVariable == null) {
                                    return series;
                                }
                                Object object = dsVariable.getValue(graph);
                                if (object == null || !(object instanceof ArrayList)) {
                                    return series;
                                }
                                ArrayList datasets = new ArrayList();
                                for (Object o : (ArrayList)object) {
                                    if (!(o instanceof SysdynDataSet)) continue;
                                    datasets.add((SysdynDataSet)o);
                                }
                                String[] filter = (String[])graph.getPossibleRelatedValue(r, jfree.variableFilter);
                                if (filter != null && (result2 = VariableRVIUtils.getDataset(datasets, (String[])filter)) != null) {
                                    datasets = result2;
                                }
                                Double chartTime = null;
                                if (!datasets.isEmpty()) {
                                    Resource chart;
                                    Resource plot;
                                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                                    Resource datasetResource = graph.getPossibleObject(r, l0.PartOf);
                                    if (datasetResource != null && (plot = graph.getPossibleObject(datasetResource, l0.PartOf)) != null && (chart = graph.getPossibleObject(plot, l0.PartOf)) != null) {
                                        chartTime = (Double)graph.getPossibleRelatedValue(chart, jfree.Chart_time);
                                    }
                                }
                                for (SysdynDataSet dataset : datasets) {
                                    String name;
                                    double[] va = dataset.values;
                                    if (va == null || va.length == 0) continue;
                                    Double time = (Double)graph.getPossibleRelatedValue(r, jfree.Series_time, (Binding)Bindings.DOUBLE);
                                    if (time == null) {
                                        time = chartTime;
                                    }
                                    if (time == null) {
                                        Variable run = Variables.getVariable((ReadGraph)graph, (String)PieDataset.this.realizationURI);
                                        if (run == null) {
                                            return null;
                                        }
                                        Variable timeVar = run.browsePossible(graph, "#" + Functions.TIME + "#");
                                        if (timeVar != null) {
                                            time = (Double)timeVar.getValue(graph, (Binding)Bindings.DOUBLE);
                                        }
                                    }
                                    Double value = null;
                                    if (time == null) {
                                        value = va[va.length - 1];
                                    } else {
                                        double[] ta = dataset.times;
                                        int i = 0;
                                        while (i < ta.length) {
                                            double t = ta[i];
                                            if (time <= t) {
                                                value = va[i];
                                                break;
                                            }
                                            ++i;
                                        }
                                        if (value == null) {
                                            value = va[va.length - 1];
                                        }
                                    }
                                    String string = name = label == null || label.isEmpty() ? dataset.name : label;
                                    if (dataset.resultIndex != null) {
                                        name = String.valueOf(name) + "(" + dataset.resultIndex + ")";
                                    }
                                    if (dataset.result != null) {
                                        name = String.valueOf(name) + " : " + dataset.result;
                                    }
                                    PieDataset.this.colorMap.put(name, color);
                                    PieDataset.this.explodedMap.put(name, exploded);
                                    series.add(new TempSeries(name, value));
                                }
                            }
                            catch (MissingVariableException missingVariableException) {
                                // empty catch block
                            }
                        }
                    }
                    return series;
                }
            }, (Listener)this.listener);
        }
        return this.dataset;
    }

    public AbstractRenderer getRenderer() {
        return null;
    }

    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            this.listener.dispose();
            this.listener = null;
        }
    }

    private class DatasetListener
    implements Listener<ArrayList<TempSeries>> {
        private boolean disposed = false;

        private DatasetListener() {
        }

        public void execute(final ArrayList<TempSeries> series) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PieDataset.this.dataset.clear();
                    int i = 0;
                    while (i < series.size()) {
                        TempSeries s = (TempSeries)series.get(i);
                        PieDataset.this.dataset.setValue((Comparable)((Object)s.name), (Number)s.value);
                        ++i;
                    }
                }
            });
        }

        public void exception(Throwable t) {
            t.printStackTrace();
        }

        public boolean isDisposed() {
            return this.disposed;
        }

        public void dispose() {
            this.disposed = true;
        }
    }

    private class TempSeries {
        public String name;
        public Double value;

        public TempSeries(String name, Double value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return "TempSeries: " + this.name + ", " + this.value;
        }
    }
}

