/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets.expressions;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.SysdynModel;
import org.simantics.sysdyn.manager.SysdynModelManager;
import org.simantics.sysdyn.representation.Stock;
import org.simantics.sysdyn.representation.Valve;
import org.simantics.sysdyn.ui.properties.widgets.expressions.ExpressionField;
import org.simantics.sysdyn.ui.properties.widgets.expressions.ExpressionWidgetInput;
import org.simantics.sysdyn.ui.properties.widgets.expressions.IExpression;
import org.simantics.utils.datastructures.Pair;

public class StockExpression
implements IExpression {
    private final ExpressionWidgetInput input;
    private ExpressionField integralExpression;
    private ExpressionField initialExpression;
    private ExpressionField lastSelectedText;
    private TextViewerUndoManager undoManager;

    public StockExpression(ExpressionWidgetInput input) {
        this.input = input;
    }

    @Override
    public void createExpressionFields(Composite parent, Map<String, Object> data, Table allowedVariables) {
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(parent);
        String initialEquation = data.get("initialEquation") != null ? (String)data.get("initialEquation") : "";
        String integralEquation = data.get("integral") != null ? (String)data.get("integral") : StockExpression.getDefaultIntegral(this.input.expression);
        Label label = new Label(parent, 0);
        label.setText("Integral");
        Composite integralComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)integralComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(integralComposite);
        this.integralExpression = new ExpressionField(integralComposite, 2048, allowedVariables, true, this.input);
        this.integralExpression.setExpression(integralEquation);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.integralExpression);
        this.integralExpression.getSourceViewer().getTextWidget().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                StockExpression.this.lastSelectedText = StockExpression.this.integralExpression;
            }
        });
        this.undoManager = new TextViewerUndoManager(100);
        this.integralExpression.getSourceViewer().setUndoManager((IUndoManager)this.undoManager);
        this.undoManager.connect((ITextViewer)this.integralExpression.getSourceViewer());
        Button defaultButton = new Button(integralComposite, 8);
        defaultButton.setText("Use default");
        defaultButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        StockExpression.this.integralExpression.setExpression(StockExpression.getDefaultIntegral(((StockExpression)StockExpression.this).input.expression));
                        Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                            public void perform(WriteGraph graph) throws DatabaseException {
                                graph.markUndoPoint();
                                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                                graph.deny(((StockExpression)(this).StockExpression.this).input.expression, sr.StockExpression_useCustomIntegral);
                                graph.claimLiteral(((StockExpression)(this).StockExpression.this).input.expression, sr.StockExpression_integralEquation, (Object)StockExpression.getDefaultIntegral((ReadGraph)graph, ((StockExpression)(this).StockExpression.this).input.expression));
                                CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                                graph.addMetadata((Metadata)cm.add("Use default"));
                            }
                        });
                    }
                }
            }
        });
        label = new Label(parent, 0);
        label.setText("Initial\nValue");
        this.initialExpression = new ExpressionField(parent, 2048, allowedVariables, true, this.input);
        this.initialExpression.setExpression(initialEquation);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.initialExpression);
        this.initialExpression.getSourceViewer().getTextWidget().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                StockExpression.this.lastSelectedText = StockExpression.this.initialExpression;
            }
        });
        this.lastSelectedText = this.initialExpression;
    }

    @Override
    public void focus() {
        this.lastSelectedText.focus();
    }

    @Override
    public List<ExpressionField> getExpressionFields() {
        return Arrays.asList(this.integralExpression, this.initialExpression);
    }

    @Override
    public void readData(final Resource expression, final Map<String, Object> data) {
        Pair equations = null;
        if (expression != null && data.get("initialEquation") == null) {
            try {
                equations = (Pair)Simantics.getSession().syncRequest((Read)new Read<Pair<String, String>>(){

                    public Pair<String, String> perform(ReadGraph graph) throws DatabaseException {
                        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                        if (graph.isInstanceOf(expression, sr.StockExpression)) {
                            String initialEquation = (String)graph.getPossibleRelatedValue(expression, sr.StockExpression_initialEquation);
                            String integralEquation = (String)graph.getPossibleRelatedValue(expression, sr.StockExpression_integralEquation);
                            initialEquation = initialEquation != null ? initialEquation : "";
                            return new Pair((Object)integralEquation, (Object)initialEquation);
                        }
                        return new Pair(null, (Object)"");
                    }
                });
            }
            catch (DatabaseException e1) {
                e1.printStackTrace();
            }
            data.put("initialEquation", equations.second);
        }
        if (equations.first == null) {
            try {
                Simantics.getSession().syncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                        graph.claimLiteral(((StockExpression)StockExpression.this).input.expression, sr.StockExpression_integralEquation, (Object)StockExpression.getDefaultIntegral((ReadGraph)graph, ((StockExpression)StockExpression.this).input.expression));
                        graph.markUndoPoint();
                        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                        graph.addMetadata((Metadata)cm.add("Set expression"));
                    }
                });
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
            data.put("integral", StockExpression.getDefaultIntegral(expression));
        } else {
            try {
                final String integral = (String)equations.first;
                Simantics.getSession().syncRequest((Read)new ReadRequest(){

                    public void run(ReadGraph graph) throws DatabaseException {
                        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                        if (graph.hasStatement(((StockExpression)StockExpression.this).input.expression, sr.StockExpression_useCustomIntegral)) {
                            data.put("integral", integral);
                        } else {
                            data.put("integral", StockExpression.getDefaultIntegral(graph, expression));
                        }
                    }
                });
            }
            catch (DatabaseException e) {
                data.put("integral", equations.first);
                e.printStackTrace();
            }
        }
    }

    @Override
    public void replaceSelection(String var) {
        if (this.lastSelectedText != null) {
            IDocument doc = this.lastSelectedText.getDocument();
            try {
                Point selection = this.lastSelectedText.getSelection();
                doc.replace(selection.x, selection.y, var);
                this.lastSelectedText.setSelection(selection.x + var.length());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void save(final Resource expression, final Map<String, Object> data) {
        final String currentInitial = this.initialExpression.getExpression();
        final String currentIntegral = this.integralExpression.getExpression();
        if (currentIntegral == null) {
            this.integralExpression.setExpression(StockExpression.getDefaultIntegral(expression));
        }
        if (!currentInitial.equals(data.get("initialEquation")) || currentIntegral == null || !currentIntegral.equals(data.get("integral"))) {
            Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph g) throws DatabaseException {
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)g);
                    Layer0 l0 = Layer0.getInstance((ReadGraph)g);
                    if (!g.isInstanceOf(expression, sr.StockExpression)) {
                        Resource variable = g.getPossibleObject(expression, l0.PartOf);
                        Resource expressionList = g.getPossibleObject(variable, sr.Variable_expressionList);
                        Resource temp = g.newResource();
                        ListUtils.replace((WriteGraph)g, (Resource)expressionList, (Resource)expression, (Resource)temp);
                        for (Resource predicate : g.getPredicates(expression)) {
                            g.deny(expression, predicate);
                        }
                        g.claim(expression, l0.InstanceOf, null, sr.StockExpression);
                        ListUtils.replace((WriteGraph)g, (Resource)expressionList, (Resource)temp, (Resource)expression);
                        RemoverUtil.remove((WriteGraph)g, (Resource)temp);
                        g.claim(expression, l0.PartOf, variable);
                    }
                    g.claimLiteral(expression, sr.StockExpression_initialEquation, (Object)currentInitial);
                    if (!currentIntegral.equals(g.getPossibleRelatedValue(expression, sr.StockExpression_integralEquation, (Binding)Bindings.STRING))) {
                        g.claim(expression, sr.StockExpression_useCustomIntegral, expression);
                    }
                    g.claimLiteral(expression, sr.StockExpression_integralEquation, (Object)currentIntegral);
                    StockExpression.this.updateData(data);
                    g.markUndoPoint();
                    Layer0Utils.addCommentMetadata((WriteGraph)g, (String)("Saved Stock Expression " + currentIntegral + " " + expression.toString() + " with Initial Value " + currentInitial));
                }
            });
        }
        this.initialExpression.setExpression(currentInitial);
        this.integralExpression.setExpression(currentIntegral);
    }

    @Override
    public void updateData(Map<String, Object> data) {
        if (this.initialExpression != null && this.initialExpression.getExpression() != null) {
            data.put("initialEquation", this.initialExpression.getExpression());
        }
        if (this.integralExpression != null && this.integralExpression.getExpression() != null) {
            data.put("integral", this.integralExpression.getExpression());
        }
    }

    private static String getDefaultIntegral(ReadGraph graph, Resource expression) throws DatabaseException {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource variable = graph.getPossibleObject(expression, l0.PartOf);
        if (variable == null) {
            return "";
        }
        SysdynModelManager sdm = SysdynModelManager.getInstance((Session)graph.getSession());
        SysdynModel model = sdm.getModel(graph, graph.getSingleObject(variable, l0.PartOf));
        model.update(graph);
        Stock stock = (Stock)model.getElement(variable);
        String range = (String)graph.getPossibleRelatedValue(expression, sr.Expression_arrayRange);
        if (range == null) {
            range = "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("");
        for (Valve in : stock.getIncomingValves()) {
            builder.append(" + " + in.getName() + range);
        }
        for (Valve out : stock.getOutgoingValves()) {
            builder.append(" - " + out.getName() + range);
        }
        if (builder.indexOf(" + ") == 0) {
            builder.delete(0, 3);
        }
        return builder.toString().trim();
    }

    private static String getDefaultIntegral(final Resource expression) {
        String integral = "";
        if (expression == null) {
            return integral;
        }
        try {
            integral = (String)Simantics.getSession().syncRequest((Read)new Read<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    return StockExpression.getDefaultIntegral(graph, expression);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return integral;
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        this.initialExpression.getSourceViewer().getTextWidget().addKeyListener(listener);
        this.integralExpression.getSourceViewer().getTextWidget().addKeyListener(listener);
    }

    @Override
    public void addModifyListener(ModifyListener listener) {
        this.initialExpression.getSourceViewer().getTextWidget().addModifyListener(listener);
        this.integralExpression.getSourceViewer().getTextWidget().addModifyListener(listener);
    }

    @Override
    public void addFocusListener(FocusListener listener) {
        this.initialExpression.getSourceViewer().getTextWidget().addFocusListener(listener);
        this.integralExpression.getSourceViewer().getTextWidget().addFocusListener(listener);
    }

    @Override
    public void addVerifyKeyListener(VerifyKeyListener listener) {
        this.initialExpression.getSourceViewer().getTextWidget().addVerifyKeyListener(listener);
        this.integralExpression.getSourceViewer().getTextWidget().addVerifyKeyListener(listener);
    }

    @Override
    public IUndoManager getUndoManager() {
        return this.undoManager;
    }
}

