/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.impl.SelectionListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.utils.ui.ISelectionUtils;

public class IsOutputWidget
implements Widget {
    Resource variable = null;
    Button isOutputButton;

    public IsOutputWidget(Composite parent, WidgetSupport support, int style) {
        support.register((Widget)this);
        this.isOutputButton = new Button(parent, support, style |= 0x20);
        this.isOutputButton.setText("Is Output");
    }

    public void setInput(ISessionContext context, Object input) {
        Resource resource;
        ISelection selection;
        if (input instanceof ISelection && (selection = (ISelection)input) instanceof IStructuredSelection && (resource = (Resource)ISelectionUtils.filterSingleSelection((Object)selection, Resource.class)) != null) {
            this.variable = resource;
        }
        if (this.variable == null) {
            return;
        }
        try {
            context.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    final boolean isOutput = graph.hasStatement(IsOutputWidget.this.variable, sr.IsOutput);
                    final org.eclipse.swt.widgets.Button button = IsOutputWidget.this.getWidget();
                    button.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (button.isDisposed()) {
                                return;
                            }
                            if (isOutput) {
                                button.setSelection(true);
                            } else {
                                button.setSelection(false);
                            }
                        }
                    });
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        this.isOutputButton.addSelectionListener((SelectionListener)new SelectionListenerImpl<Resource>(context){

            public void apply(WriteGraph graph, Resource input) throws DatabaseException {
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                if (graph.hasStatement(input, sr.IsOutput)) {
                    graph.deny(input, sr.IsOutput);
                    Layer0Utils.addCommentMetadata((WriteGraph)graph, (String)("Modified Is Output for " + graph.getPossibleRelatedValue2(input, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING) + " to False"));
                } else {
                    graph.claim(input, SysdynResource.getInstance((ReadGraph)graph).IsOutput, null, input);
                    Layer0Utils.addCommentMetadata((WriteGraph)graph, (String)("Modified Is Output for " + graph.getPossibleRelatedValue2(input, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING) + " to True"));
                }
            }
        });
    }

    public org.eclipse.swt.widgets.Button getWidget() {
        return this.isOutputButton.getWidget();
    }
}

