/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.swt.AdaptableHintContext;
import org.simantics.browsing.ui.swt.SingleSelectionInputSource;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.browsing.ui.swt.widgets.impl.SelectionListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Write;
import org.simantics.jfreechart.chart.properties.LabelPropertyTabContributor;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.ui.browser.nodes.SharedFunctionLibraryNode;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.datastructures.ArrayMap;
import org.simantics.utils.ui.AdaptionUtils;

public class SharedFunctionLibrariesTab
extends LabelPropertyTabContributor
implements Widget {
    GraphExplorerComposite availableSharedFunctionLibraries;
    GraphExplorerComposite usedSharedFunctionLibraries;
    Resource model;

    public SharedFunctionLibrariesTab(Object id) {
        super(id);
    }

    public void createControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
        support.register((Widget)this);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(body);
        Composite available = new Composite(body, 0);
        GridLayoutFactory.fillDefaults().applyTo(available);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)available);
        Label label = new Label(available, 0);
        label.setText("Available Shared Function Libraries");
        this.availableSharedFunctionLibraries = new GraphExplorerComposite((Map)ArrayMap.keys((Object[])new String[]{"displaySelectors", "displayFilter"}).values(new Object[]{false, false}), site, available, 67586){

            protected void handleDrop(Object data, NodeContext target) {
                if (!(data instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection iss = (IStructuredSelection)data;
                if (iss == null || iss.isEmpty()) {
                    return;
                }
                for (Object o : iss) {
                    IAdaptable a;
                    SharedFunctionLibraryNode node;
                    if (!(o instanceof IAdaptable) || (node = (SharedFunctionLibraryNode)((Object)(a = (IAdaptable)o).getAdapter(SharedFunctionLibraryNode.class))) == null) continue;
                    SimanticsUI.getSession().asyncRequest((Write)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            if (SharedFunctionLibrariesTab.this.getModel() != null && node.data != null) {
                                graph.deny(SharedFunctionLibrariesTab.this.getModel(), Layer0.getInstance((ReadGraph)graph).IsLinkedTo, (Resource)node.data);
                            }
                        }
                    });
                }
            }
        };
        this.availableSharedFunctionLibraries.setBrowseContexts(new String[]{"http://www.simantics.org/Sysdyn-1.1/AvailableSharedFunctionLibraries"});
        this.availableSharedFunctionLibraries.setInputSource((GraphExplorerComposite.InputSource)new SingleSelectionInputSource(Resource.class));
        this.availableSharedFunctionLibraries.finish();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.availableSharedFunctionLibraries);
        Composite middleButtons = new Composite(body, 0);
        GridLayoutFactory.fillDefaults().applyTo(middleButtons);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, true).applyTo((Control)middleButtons);
        Button add = new Button(middleButtons, support, 0);
        add.setText(" -> ");
        add.addSelectionListener((SelectionListener)new SelectionListenerImpl<Resource>(context){
            List<Resource> selectedLibraries;

            public void beforeApply() {
                this.selectedLibraries = SharedFunctionLibrariesTab.this.getSelectedResources(SharedFunctionLibrariesTab.this.availableSharedFunctionLibraries);
            }

            public void apply(WriteGraph graph, Resource input) throws DatabaseException {
                if (this.selectedLibraries != null) {
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    StringBuilder sb = new StringBuilder();
                    sb.append("Added Shared Function Library ");
                    for (Resource library : this.selectedLibraries) {
                        graph.claim(input, l0.IsLinkedTo, library);
                        sb.append(String.valueOf(NameUtils.getSafeName((ReadGraph)graph, (Resource)library)) + " ");
                    }
                    sb.append("to " + NameUtils.getSafeName((ReadGraph)graph, (Resource)input));
                    Layer0Utils.addCommentMetadata((WriteGraph)graph, (String)sb.toString());
                }
            }
        });
        Button remove = new Button(middleButtons, support, 0);
        remove.setText(" <- ");
        remove.addSelectionListener((SelectionListener)new SelectionListenerImpl<Resource>(context){
            List<Resource> selectedLibraries;

            public void beforeApply() {
                this.selectedLibraries = SharedFunctionLibrariesTab.this.getSelectedResources(SharedFunctionLibrariesTab.this.usedSharedFunctionLibraries);
            }

            public void apply(WriteGraph graph, Resource input) throws DatabaseException {
                if (this.selectedLibraries != null) {
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    StringBuilder sb = new StringBuilder();
                    sb.append("Removed Shared Function Library ");
                    for (Resource library : this.selectedLibraries) {
                        graph.deny(input, l0.IsLinkedTo, library);
                        sb.append(String.valueOf(NameUtils.getSafeName((ReadGraph)graph, (Resource)library)) + " ");
                    }
                    sb.append("from " + NameUtils.getSafeName((ReadGraph)graph, (Resource)input));
                    Layer0Utils.addCommentMetadata((WriteGraph)graph, (String)sb.toString());
                }
            }
        });
        Composite used = new Composite(body, 0);
        GridLayoutFactory.fillDefaults().applyTo(used);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)used);
        label = new Label(used, 0);
        label.setText("Selected Shared Function Libraries");
        this.usedSharedFunctionLibraries = new GraphExplorerComposite((Map)ArrayMap.keys((Object[])new String[]{"displaySelectors", "displayFilter"}).values(new Object[]{false, false}), site, used, 67586){

            protected void handleDrop(Object data, NodeContext target) {
                if (!(data instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection iss = (IStructuredSelection)data;
                if (iss == null || iss.isEmpty()) {
                    return;
                }
                for (Object o : iss) {
                    IAdaptable a;
                    SharedFunctionLibraryNode node;
                    if (!(o instanceof IAdaptable) || (node = (SharedFunctionLibraryNode)((Object)(a = (IAdaptable)o).getAdapter(SharedFunctionLibraryNode.class))) == null) continue;
                    SimanticsUI.getSession().asyncRequest((Write)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            if (SharedFunctionLibrariesTab.this.getModel() != null && node.data != null) {
                                graph.claim(SharedFunctionLibrariesTab.this.getModel(), Layer0.getInstance((ReadGraph)graph).IsLinkedTo, (Resource)node.data);
                            }
                        }
                    });
                }
            }
        };
        this.usedSharedFunctionLibraries.setBrowseContexts(new String[]{"http://www.simantics.org/Sysdyn-1.1/SelectedSharedFunctionLibraries"});
        this.usedSharedFunctionLibraries.setInputSource((GraphExplorerComposite.InputSource)new SingleSelectionInputSource(Resource.class));
        this.usedSharedFunctionLibraries.finish();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.usedSharedFunctionLibraries);
    }

    private List<Resource> getSelectedResources(GraphExplorerComposite explorer) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        ISelection selection = ((ISelectionProvider)explorer.getAdapter(ISelectionProvider.class)).getSelection();
        if (selection == null) {
            return result;
        }
        IStructuredSelection iss = (IStructuredSelection)selection;
        List selections = iss.toList();
        for (AdaptableHintContext ahc : selections) {
            Resource resource = (Resource)ahc.getAdapter(Resource.class);
            result.add(resource);
        }
        return result;
    }

    private Resource getModel() {
        return this.model;
    }

    public void setInput(ISessionContext context, Object input) {
        this.availableSharedFunctionLibraries.setInput(context, input);
        this.usedSharedFunctionLibraries.setInput(context, input);
        this.model = (Resource)AdaptionUtils.adaptToSingle((Object)input, Resource.class);
    }
}

