/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.handlers.newComponents;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.browsing.ui.common.node.AbstractNode;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.ui.AdaptionUtils;

public class NewFunctionLibraryHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        AbstractNode node = (AbstractNode)AdaptionUtils.adaptToSingle((Object)sel, AbstractNode.class);
        if (node == null) {
            return null;
        }
        this.createLibrary((Resource)node.data, false);
        return null;
    }

    protected void createLibrary(final Resource model, final boolean shared) {
        SimanticsUI.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph g) throws DatabaseException {
                g.markUndoPoint();
                Layer0 l0 = Layer0.getInstance((ReadGraph)g);
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)g);
                if (!(g.isInstanceOf(model, sr.SysdynModel) || g.isInstanceOf(model, sr.SysdynModelicaFunctionLibrary) || g.isInstanceOf(model, sr.SharedFunctionOntology))) {
                    return;
                }
                Resource root = model;
                String name = "FunctionLibrary";
                Resource libraryType = sr.SysdynModelicaFunctionLibrary;
                if (shared) {
                    try {
                        root = g.getResource("http://SharedOntologies");
                    }
                    catch (ResourceNotFoundException e) {
                        root = g.getResource("http:/");
                        root = GraphUtils.create2((WriteGraph)g, (Resource)l0.Library, (Object[])new Object[]{l0.HasName, "SharedOntologies", l0.PartOf, root});
                    }
                    name = "Shared" + name;
                    libraryType = sr.SharedFunctionOntology;
                }
                name = NameUtils.findFreshName((ReadGraph)g, (String)name, (Resource)root, (Resource)l0.ConsistsOf, (String)"%s%d");
                Resource functionLibrary = GraphUtils.create2((WriteGraph)g, (Resource)libraryType, (Object[])new Object[]{l0.HasName, name, l0.HasDescription, "", l0.PartOf, root});
                if (shared) {
                    g.claim(model, l0.IsLinkedTo, functionLibrary);
                }
                Layer0Utils.addCommentMetadata((WriteGraph)g, (String)("Created new Function Library " + name + " " + functionLibrary.toString()));
            }
        });
    }
}

