/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.handlers.exports;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.RuntimeBindingConstructionException;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.primitiverequest.PossibleRelatedValue;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.ModelTransferableGraphSourceRequest;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.Activator;
import org.simantics.sysdyn.ui.utils.imports.ImportUtilsUI;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.datastructures.Pair;

public class ExportModuleHandler
extends AbstractHandler {
    /*
     * Unable to fully structure code
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        modulesymbol = ResourceAdaptionUtils.toSingleResource((Object)sel);
        if (modulesymbol == null) {
            return null;
        }
        name = null;
        try {
            name = (String)SimanticsUI.getSession().syncRequest((Read)new Read<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
                    StructuralResource2 sr2 = StructuralResource2.getInstance((ReadGraph)graph);
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    Resource component = graph.getPossibleObject(modulesymbol, mr.SymbolToComponentType);
                    if (component == null || !graph.hasStatement(component, Layer0.getInstance((ReadGraph)graph).PartOf)) {
                        return null;
                    }
                    Resource configuration = graph.getPossibleObject(component, sr2.IsDefinedBy);
                    if (configuration == null) {
                        return null;
                    }
                    ArrayList<String> dependencies = null;
                    for (Resource r : (Collection)graph.syncRequest((Read)new ObjectsWithType(configuration, l0.ConsistsOf, sr.Module))) {
                        if (dependencies == null) {
                            dependencies = new ArrayList<String>();
                        }
                        String name = NameUtils.getSafeName((ReadGraph)graph, (Resource)r);
                        String instanceOf = NameUtils.getSafeName((ReadGraph)graph, (Resource)graph.getSingleObject(r, l0.InstanceOf));
                        dependencies.add(String.valueOf(name) + " : " + instanceOf);
                    }
                    if (dependencies != null && !dependencies.isEmpty()) {
                        throw new ContainsDependenciesException(dependencies);
                    }
                    String name = (String)graph.getPossibleRelatedValue(component, l0.HasName, (Binding)Bindings.STRING);
                    return name;
                }
            });
        }
        catch (ContainsDependenciesException e1) {
            shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
            mb = new MessageBox(shell, 32);
            sb = new StringBuilder();
            sb.append("This version does not support exporting modules with other module instances.\n\n");
            sb.append("Dependencies:\n");
            ** for (s : e1.getDependencies())
        }
lbl-1000:
        // 1 sources

        {
            sb.append("    " + s + "\n");
            continue;
        }
lbl21:
        // 1 sources

        mb.setMessage(sb.toString());
        mb.setText("Module contains dependencies.");
        mb.open();
        return null;
        catch (DatabaseException e1) {
            e1.printStackTrace();
        }
        if (name == null) {
            return null;
        }
        shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        fd = new FileDialog(shell, 8192);
        fd.setText("Export Module");
        fd.setFileName(name);
        path = Activator.getDefault().getPreferenceStore().getString(ImportUtilsUI.IMPORTMODULETPATH);
        if (path.isEmpty() || !new File(path).exists()) {
            path = Platform.getLocation().toOSString();
        }
        fd.setFilterPath(path);
        filterExt = new String[]{"*.sysdynModule"};
        fd.setFilterExtensions(filterExt);
        fd.setOverwrite(true);
        selected = fd.open();
        if (selected == null) {
            return null;
        }
        Activator.getDefault().getPreferenceStore().setValue(ImportUtilsUI.IMPORTMODULETPATH, new File(selected).getParent());
        SimanticsUI.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
                final Resource component = graph.getPossibleObject(modulesymbol, mr.SymbolToComponentType);
                if (component == null || !graph.hasStatement(component, Layer0.getInstance((ReadGraph)graph).PartOf)) {
                    return;
                }
                String name = (String)graph.syncRequest((AsyncRead)new PossibleRelatedValue(component, l0.HasName, (Binding)Bindings.STRING));
                final ArrayList<Pair> roots = new ArrayList<Pair>();
                roots.add(Pair.make((Object)component, (Object)name));
                graph.asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                        StructuralResource2 sr2 = StructuralResource2.getInstance((ReadGraph)graph);
                        Resource configuration = graph.getPossibleObject(component, sr2.IsDefinedBy);
                        if (!graph.hasStatement(configuration, l0.PartOf, component) && !graph.hasStatement(modulesymbol, l0.PartOf, component)) {
                            Resource previousPartof = graph.getSingleObject(configuration, l0.PartOf);
                            graph.deny(configuration, l0.PartOf);
                            graph.deny(modulesymbol, l0.PartOf);
                            graph.claim(configuration, l0.PartOf, l0.ConsistsOf, component);
                            graph.claim(modulesymbol, l0.PartOf, l0.ConsistsOf, component);
                            ExportModuleHandler.this.export(graph, selected, roots, component);
                            graph.deny(configuration, l0.PartOf);
                            graph.deny(modulesymbol, l0.PartOf);
                            graph.claim(configuration, l0.PartOf, l0.ConsistsOf, previousPartof);
                            graph.claim(modulesymbol, l0.PartOf, l0.ConsistsOf, previousPartof);
                        } else {
                            ExportModuleHandler.this.export(graph, selected, roots, component);
                        }
                    }
                });
            }
        });
        return null;
    }

    private void export(WriteGraph graph, final String path, ArrayList<Pair<Resource, String>> roots, final Resource component) {
        try {
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            StructuralResource2 sr2 = StructuralResource2.getInstance((ReadGraph)graph);
            Resource configuration = graph.getPossibleObject(component, sr2.IsDefinedBy);
            ArrayList<Pair> replacements = new ArrayList<Pair>();
            for (Resource enumeration : (Collection)graph.syncRequest((Read)new ObjectsWithType(configuration, l0.ConsistsOf, sr.Enumeration))) {
                if (!graph.hasStatement(enumeration, sr.Redeclaration_replacedEnumeration_Inverse)) continue;
                for (Resource replacement : graph.getObjects(enumeration, sr.Redeclaration_replacedEnumeration_Inverse)) {
                    replacements.add(new Pair((Object)enumeration, (Object)replacement));
                }
            }
            for (Pair replacement : replacements) {
                graph.deny((Resource)replacement.first, sr.Redeclaration_replacedEnumeration_Inverse, (Resource)replacement.second);
            }
            SimanticsUI.getSession().asyncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    TransferableGraphConfiguration2 conf = new TransferableGraphConfiguration2(graph, component);
                    TransferableGraphSource s = (TransferableGraphSource)graph.syncRequest((Read)new ModelTransferableGraphSourceRequest(conf));
                    try {
                        TransferableGraphs.writeTransferableGraph((RequestProcessor)graph, (String)"sysdynModule", (int)1, (TransferableGraphSource)s, (File)new File(path));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            for (Pair replacement : replacements) {
                graph.claim((Resource)replacement.first, sr.Redeclaration_replacedEnumeration_Inverse, (Resource)replacement.second);
            }
        }
        catch (RuntimeBindingConstructionException e) {
            e.printStackTrace();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    class ContainsDependenciesException
    extends DatabaseException {
        private static final long serialVersionUID = -1533706136673146020L;
        private final Collection<String> dependencies;

        ContainsDependenciesException(Collection<String> dependencies) {
            this.dependencies = dependencies;
        }

        public Collection<String> getDependencies() {
            return this.dependencies;
        }
    }
}

