/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.handlers;

import java.util.concurrent.Semaphore;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.message.MessageService;
import org.simantics.project.IProject;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.model.ExperimentLoadingFailed;
import org.simantics.simulation.project.IExperimentActivationListener;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.sysdyn.ui.listeners.SysdynExperimentManagerListener;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.DataContainer;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.dialogs.ShowMessage;

public class SysdynExperimentActivator
extends AbstractHandler {
    public static void scheduleActivation(RequestProcessor processor, IProject project, IExperimentManager experimentManager, Resource experiment) {
        String jobName = "Activate Experiment";
        String experimentName = SysdynExperimentActivator.getName(processor, experiment);
        if (experimentName != null) {
            jobName = String.valueOf(jobName) + " '" + experimentName + "'";
        }
        SysdynExperimentActivator.scheduleActivation(jobName, project, experimentManager, experiment);
    }

    public static void scheduleActivation(String jobName, final IProject project, final IExperimentManager experimentManager, final Resource experiment) {
        new Job(jobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IStatus iStatus = SysdynExperimentActivator.activate(monitor, project, experimentManager, experiment);
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        }.schedule();
    }

    public static IStatus activate(IProgressMonitor monitor, IProject project, IExperimentManager experimentManager, Resource experiment) {
        return new SysdynExperimentActivator().activateExperiment(monitor, project, experimentManager, experiment);
    }

    private static String getName(RequestProcessor processor, final Resource resource) {
        try {
            return (String)processor.syncRequest((Read)new Read<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    try {
                        return (String)graph.adapt(resource, String.class);
                    }
                    catch (AdaptionException e) {
                        return NameUtils.getSafeName((ReadGraph)graph, (Resource)resource);
                    }
                }
            });
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogWarning((Throwable)e);
            return null;
        }
    }

    private IStatus activateExperiment(IProgressMonitor monitor, IProject project, IExperimentManager manager, Resource experimentResource) {
        final SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)"Activating experiment", (int)100000);
        SysdynExperimentManagerListener.listenManager(manager);
        IExperiment[] experiments = manager.getExperiments();
        SubMonitor shutdownMon = mon.newChild(10000);
        int workPerExperiment = experiments.length > 0 ? 10000 / experiments.length : 10000;
        IExperiment[] iExperimentArray = experiments;
        int n = experiments.length;
        int n2 = 0;
        while (n2 < n) {
            IExperiment e = iExperimentArray[n2];
            if (e.getState() != ExperimentState.DISPOSED) {
                e.shutdown((IProgressMonitor)shutdownMon.newChild(workPerExperiment));
            }
            ++n2;
        }
        mon.setWorkRemaining(90000);
        final Semaphore activated = new Semaphore(0);
        final DataContainer problem = new DataContainer();
        manager.startExperiment(experimentResource, new IExperimentActivationListener(){

            public void onExperimentActivated(IExperiment experiment) {
                MessageService.defaultLog((IStatus)new Status(1, "org.simantics.simulation.ui", 0, "Activated experiment " + experiment.getIdentifier(), null));
                activated.release();
            }

            public void onFailure(Throwable e) {
                problem.set((Object)e);
                activated.release();
            }

            public void onMessage(IStatus message) {
                MessageService.getDefault().log(message);
            }

            public IProgressMonitor getProgressMonitor() {
                return mon;
            }
        }, true);
        try {
            activated.acquire();
            Throwable t = (Throwable)problem.get();
            if (t != null) {
                if (t instanceof ExperimentLoadingFailed) {
                    ErrorLogger.defaultLogError((Throwable)t);
                    ShowMessage.showError((String)"Experiment Activation Failed", (String)t.getMessage());
                } else {
                    ExceptionUtils.logAndShowError((Throwable)t);
                }
            }
            return Status.OK_STATUS;
        }
        catch (InterruptedException e) {
            return Status.CANCEL_STATUS;
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Resource experiment = ResourceAdaptionUtils.toSingleResource((Object)selection);
        if (experiment == null) {
            return null;
        }
        IProject project = SimanticsUI.getProject();
        if (project == null) {
            return null;
        }
        IExperimentManager experimentManager = (IExperimentManager)project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        if (experimentManager == null) {
            ErrorLogger.defaultLogWarning((String)"Experiment manager not available.", (Throwable)new Exception());
            return null;
        }
        SysdynExperimentActivator.scheduleActivation((RequestProcessor)SimanticsUI.getSession(), project, experimentManager, experiment);
        return null;
    }
}

