/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.handlers;

import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.diagram.handler.CopyPasteHandler;
import org.simantics.diagram.handler.DiagramSelection;
import org.simantics.diagram.handler.DiagramSelectionRepresentation;
import org.simantics.diagram.synchronization.CopyAdvisor;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.modeling.mapping.ElementCopyAdvisor;
import org.simantics.modeling.mapping.MappedElementCopyAdvisor;
import org.simantics.modeling.ui.diagramEditor.DiagramEditor;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.sysdyn.ui.editor.DiagramViewer;
import org.simantics.sysdyn.ui.editor.participant.SysdynSpecialComponentCopyAdvisor;
import org.simantics.sysdyn.ui.handlers.PasteSpecialDialog;
import org.simantics.utils.datastructures.hints.IHintContext;

public class PasteSpecialHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (!(editor instanceof DiagramEditor)) {
            return null;
        }
        DiagramViewer viewer = (DiagramViewer)((DiagramEditor)editor).getViewer();
        if (viewer == null) {
            return null;
        }
        Object d = viewer.getAdapter(IDiagram.class);
        if (d != null && d instanceof IDiagram) {
            ICanvasContext ctx;
            CopyPasteHandler handler;
            IDiagram diagram = (IDiagram)d;
            MappedElementCopyAdvisor standardCopyAdvisor = (MappedElementCopyAdvisor)diagram.getHint(SynchronizationHints.COPY_ADVISOR);
            Shell shell = viewer.getComposite().getShell();
            if (shell == null) {
                return null;
            }
            PasteSpecialDialog dialog = new PasteSpecialDialog(shell);
            if (dialog.open() == 1) {
                return null;
            }
            String prefix = dialog.getPrefix();
            String suffix = dialog.getSuffix();
            diagram.setHint(SynchronizationHints.COPY_ADVISOR, (Object)new MappedElementCopyAdvisor((CopyAdvisor)new ElementCopyAdvisor(), (CopyAdvisor)new SysdynSpecialComponentCopyAdvisor(prefix, suffix)));
            Object v = viewer.getAdapter(ICanvasContext.class);
            if (v != null && v instanceof ICanvasContext && (handler = (CopyPasteHandler)(ctx = (ICanvasContext)v).getAtMostOneItemOfClass(CopyPasteHandler.class)) != null) {
                handler.paste(Commands.PASTE, this.getClipboardDiagramSelection());
            }
            diagram.setHint(SynchronizationHints.COPY_ADVISOR, (Object)standardCopyAdvisor);
        }
        return null;
    }

    public DiagramSelection getClipboardDiagramSelection() {
        for (Set content : Simantics.getClipboard().getContents()) {
            DiagramSelection sel = (DiagramSelection)ClipboardUtils.accept((Set)content, (IHintContext.Key)DiagramSelectionRepresentation.KEY_DIAGRAM_SELECTION);
            if (sel == null) continue;
            return sel;
        }
        return DiagramSelection.EMPTY;
    }
}

