/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.IToolMode;
import org.simantics.sysdyn.ui.elements.SysdynElementHints;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class DiagramToolHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IToolMode mode;
        final ICanvasContext context = (ICanvasContext)HandlerUtil.getActiveEditor((ExecutionEvent)event).getAdapter(ICanvasContext.class);
        if (context == null) {
            throw new ExecutionException("Could not get context from editor");
        }
        String value = (String)event.getCommand().getState("org.eclipse.ui.commands.radioState").getValue();
        if ("pointer".equals(value)) {
            mode = Hints.POINTERTOOL;
        } else if ("dependency".equals(value)) {
            mode = SysdynElementHints.DEPENDENCY_TOOL;
        } else if ("flow".equals(value)) {
            mode = SysdynElementHints.FLOW_TOOL;
        } else if ("lock".equals(value)) {
            mode = SysdynElementHints.LOCK_TOOL;
        } else {
            return null;
        }
        ThreadUtils.syncExec((IThreadWorkQueue)context.getThreadAccess(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (mode.equals(SysdynElementHints.DEPENDENCY_TOOL) || mode.equals(SysdynElementHints.FLOW_TOOL)) {
                    context.getDefaultHintContext().setHint(Hints.KEY_TOOL, (Object)Hints.CONNECTTOOL);
                    context.getDefaultHintContext().setHint(SysdynElementHints.SYSDYN_KEY_TOOL, (Object)mode);
                } else if (mode.equals(SysdynElementHints.LOCK_TOOL)) {
                    context.getDefaultHintContext().setHint(Hints.KEY_TOOL, (Object)Hints.POINTERTOOL);
                    context.getDefaultHintContext().setHint(SysdynElementHints.SYSDYN_KEY_TOOL, (Object)mode);
                } else {
                    context.getDefaultHintContext().setHint(Hints.KEY_TOOL, (Object)mode);
                    context.getDefaultHintContext().removeHint(SysdynElementHints.SYSDYN_KEY_TOOL);
                }
            }
        });
        return null;
    }
}

