/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.elements.profiles;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.diagram.elements.TextNode;
import org.simantics.diagram.profile.StyleBase;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.modeling.ModelingResources;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Observer;
import org.simantics.scenegraph.profile.common.ProfileVariables;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.elements.profiles.ShadowResult;

public class ShadowStyle
extends StyleBase<ShadowResult> {
    private static String SHADOW_DECORATION_NODE = "SHADOW_DECORATION_NODE";
    private static Stroke SHADOW_DECORATION_STROKE = new BasicStroke(0.2f);

    public ShadowResult calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource element, Variable configuration) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
        AffineTransform transform = DiagramGraphUtil.getAffineTransform((ReadGraph)graph, (Resource)element);
        Resource component = graph.getPossibleObject(element, MOD.ElementToComponent);
        Resource original = graph.getPossibleObject(component, SR.Shadow_original);
        Collection shadows = graph.getObjects(component, SR.Shadow_original_Inverse);
        for (Resource r : graph.getObjects(runtimeDiagram, SR.ConfigurationDiagram_selection)) {
            Resource selection = graph.getPossibleObject(r, MOD.ElementToComponent);
            if (original != null) {
                Collection otherShadows = graph.getObjects(original, SR.Shadow_original_Inverse);
                otherShadows.remove(component);
                if (selection.equals(original) || otherShadows.contains(selection)) {
                    return new ShadowResult(ShadowResult.Style.SHADOW, transform);
                }
            }
            if (!shadows.contains(selection)) continue;
            return new ShadowResult(ShadowResult.Style.ORIGINAL, transform);
        }
        return new ShadowResult(ShadowResult.Style.NONE, transform);
    }

    public void applyStyleForNode(EvaluationContext observer, INode _node, ShadowResult result) {
        if (result == null || result.getStyle() == ShadowResult.Style.NONE) {
            this.cleanupStyleForNode(_node);
            return;
        }
        A node = (A)ProfileVariables.claimChild((INode)_node, (String)"", (String)SHADOW_DECORATION_NODE, A.class, (Observer)observer);
        if (node == null) {
            return;
        }
        AffineTransform at = result.getTransform();
        INode n = (INode)NodeUtil.getNearestChildByClass((G2DParentNode)((SingleElementNode)_node), TextNode.class);
        Rectangle2D expandedElementBounds = GeometryUtils.expandRectangle((Rectangle2D)NodeUtil.getLocalElementBounds((INode)n), (double)0.0);
        node.setFill(false);
        node.setColor(result.getStyle() == ShadowResult.Style.SHADOW ? Color.BLUE : Color.MAGENTA);
        node.setStroke(SHADOW_DECORATION_STROKE);
        node.setValue("shape", expandedElementBounds);
        node.setTransform(at);
        int zIndex = -1;
        if (n != null) {
            at = ((TextNode)n).getTransform();
            zIndex = ((TextNode)n).getZIndex() - 1;
        } else {
            n = _node;
        }
        node.setZIndex(zIndex);
    }

    protected void cleanupStyleForNode(INode node) {
        ProfileVariables.denyChild((INode)node, (String)"", (String)SHADOW_DECORATION_NODE);
    }

    public static class A
    extends ShapeNode {
        private static final long serialVersionUID = -5273246617906214956L;

        public Rectangle2D getBoundsInLocal() {
            return null;
        }

        public Rectangle2D getBoundsInLocal(boolean b) {
            return null;
        }

        public Rectangle2D getBounds() {
            return null;
        }
    }
}

