/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.editor.participant;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.participant.ConnectionBuilder;
import org.simantics.diagram.participant.ControlPoint;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.graph.AddElement;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.diagram.participant.pointertool.TerminalUtil;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementClasses;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.EdgeVisuals;
import org.simantics.g2d.element.impl.Element;
import org.simantics.g2d.elementclass.FlagClass;
import org.simantics.layer0.Layer0;
import org.simantics.structural2.modelingRules.ConnectionJudgement;
import org.simantics.structural2.modelingRules.IModelingRules;
import org.simantics.sysdyn.ui.elements.SysdynElementClasses;
import org.simantics.sysdyn.ui.elements.ValveFactory;
import org.simantics.sysdyn.ui.elements.connections.ConnectionClasses;
import org.simantics.utils.datastructures.Pair;

public class SysdynConnectionBuilder
extends ConnectionBuilder {
    public SysdynConnectionBuilder(IDiagram diagram) {
        super(diagram);
    }

    public void create(WriteGraph graph, ConnectionJudgement judgment, Deque<ControlPoint> controlPoints, TerminalUtil.TerminalInfo startTerminal, TerminalUtil.TerminalInfo endTerminal) throws DatabaseException {
        if (startTerminal == null) {
            return;
        }
        if (endTerminal == null) {
            return;
        }
        graph.markUndoPoint();
        if (this.needsValve(startTerminal, endTerminal)) {
            this.createValveAndConnections(graph, judgment, controlPoints, startTerminal, endTerminal);
        } else {
            this.createConnection(graph, judgment, controlPoints, startTerminal, endTerminal, false);
        }
        String startElementName = (String)startTerminal.e.getHint(ElementHints.KEY_TEXT);
        String endElementName = (String)endTerminal.e.getHint(ElementHints.KEY_TEXT);
        String startElementResource = startTerminal.e.getHint(ElementHints.KEY_OBJECT).toString();
        String endElementResource = endTerminal.e.getHint(ElementHints.KEY_OBJECT).toString();
        Layer0Utils.addCommentMetadata((WriteGraph)graph, (String)("Created dependency starting from " + startElementName + " " + startElementResource + " and ending to " + endElementName + " " + endElementResource));
    }

    public TerminalUtil.TerminalInfo createConnection(WriteGraph graph, ConnectionJudgement judgment, Deque<ControlPoint> controlPoints, TerminalUtil.TerminalInfo startTerminal, TerminalUtil.TerminalInfo endTerminal, boolean createValve) throws DatabaseException {
        ArrayList terminals;
        TerminalUtil.TerminalInfo newValve = null;
        this.cu = new ConnectionUtil(graph);
        Resource connection = this.getOrCreateConnection((ReadGraph)graph, new TerminalUtil.TerminalInfo[]{startTerminal, endTerminal});
        AddElement.claimFreshElementName((WriteGraph)graph, (Resource)this.diagramResource, (Resource)connection);
        List bps = this.createBranchPoints(graph, connection, controlPoints);
        Resource firstBranchPoint = null;
        Resource lastBranchPoint = null;
        if (!bps.isEmpty()) {
            Iterator it = bps.iterator();
            Pair prev = (Pair)it.next();
            firstBranchPoint = (Resource)prev.second;
            while (it.hasNext()) {
                Pair next = (Pair)it.next();
                this.cu.connect((Resource)prev.second, (Resource)next.second);
                prev = next;
            }
            lastBranchPoint = (Resource)prev.second;
        }
        ConnectionBuilder.Connector startConnector = null;
        ConnectionBuilder.Connector endConnector = null;
        IElement startFlag = null;
        IElement endFlag = null;
        if (startTerminal != null) {
            startConnector = this.createConnectorForNode(graph, connection, startTerminal, EdgeVisuals.EdgeEnd.Begin, judgment);
        } else if (this.createFlags) {
            startFlag = this.createFlag(graph, connection, EdgeVisuals.EdgeEnd.Begin, controlPoints.getFirst(), FlagClass.Type.In, "");
            terminals = new ArrayList();
            ElementUtils.getTerminals((IElement)startFlag, terminals, (boolean)false);
            Topology.Terminal st = (Topology.Terminal)terminals.get(1);
            startConnector = this.createConnectorForNode(graph, connection, (Resource)ElementUtils.getObject((IElement)startFlag), st, EdgeVisuals.EdgeEnd.Begin, judgment);
        }
        if (endTerminal != null) {
            endConnector = this.createConnectorForNode(graph, connection, endTerminal, EdgeVisuals.EdgeEnd.End, judgment);
        } else if (this.createFlags) {
            endFlag = createValve ? this.createValveElement(graph, connection, EdgeVisuals.EdgeEnd.End, controlPoints.getLast()) : this.createFlag(graph, connection, EdgeVisuals.EdgeEnd.End, controlPoints.getLast(), FlagClass.Type.Out, "");
            terminals = new ArrayList();
            ElementUtils.getTerminals((IElement)endFlag, terminals, (boolean)false);
            Topology.Terminal et = (Topology.Terminal)terminals.get(0);
            endConnector = this.createConnectorForNode(graph, connection, (Resource)ElementUtils.getObject((IElement)endFlag), et, EdgeVisuals.EdgeEnd.End, judgment);
            if (createValve) {
                newValve = new TerminalUtil.TerminalInfo();
                newValve.e = endFlag;
                newValve.t = (Topology.Terminal)terminals.get(1);
                newValve.posElem = TerminalUtil.getTerminalPosOnElement((IElement)endFlag, (Topology.Terminal)newValve.t);
                newValve.posDia = TerminalUtil.getTerminalPosOnDiagram((IElement)endFlag, (Topology.Terminal)newValve.t);
            }
        }
        if (firstBranchPoint == null || lastBranchPoint == null) {
            this.cu.connect(startConnector.getConnector(), endConnector.getConnector());
        } else {
            this.cu.connect(startConnector.getConnector(), firstBranchPoint);
            this.cu.connect(lastBranchPoint, endConnector.getConnector());
        }
        IModelingRules modelingRules = (IModelingRules)this.diagram.getHint(DiagramModelHints.KEY_MODELING_RULES);
        if (judgment.connectionType != null && modelingRules != null) {
            modelingRules.setConnectionType(graph, connection, judgment.connectionType);
        }
        this.cu = null;
        return newValve;
    }

    public IElement createValveElement(WriteGraph graph, Resource connection, EdgeVisuals.EdgeEnd end, ControlPoint cp) throws DatabaseException {
        ElementClass valveClass = this.elementClassProvider.get(SysdynElementClasses.VALVE);
        IElement valveElement = Element.spawnNew((ElementClass)valveClass);
        Resource valveClassResource = (Resource)ElementUtils.checkedAdapt((ElementClass)valveClass, Resource.class);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        G2DResource G2D = G2DResource.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource valve = graph.newResource();
        graph.claim(valve, L0.InstanceOf, null, valveClassResource);
        graph.claim(valve, L0.PartOf, this.diagramResource);
        AddElement.claimFreshElementName((WriteGraph)graph, (Resource)this.diagramResource, (Resource)valve);
        valveElement.setHint(ElementHints.KEY_OBJECT, (Object)valve);
        OrderedSetUtils.add((WriteGraph)graph, (Resource)this.diagramResource, (Resource)valve);
        AffineTransform at = AffineTransform.getTranslateInstance(cp.getPosition().getX(), cp.getPosition().getY());
        valveElement.setHint(ElementHints.KEY_TRANSFORM, (Object)at);
        double[] matrix = new double[6];
        at.getMatrix(matrix);
        graph.claimLiteral(valve, DIA.HasTransform, G2D.Transform, (Object)matrix);
        if (this.layerManager != null) {
            this.layerManager.removeFromAllLayers(graph, valve);
            this.layerManager.putElementOnVisibleLayers(this.diagram, graph, valve);
        }
        return valveElement;
    }

    private boolean needsValve(TerminalUtil.TerminalInfo startTerminal, TerminalUtil.TerminalInfo endTerminal) {
        if (!this.elementClassProvider.get(ElementClasses.CONNECTION).equals((Object)this.elementClassProvider.get(ConnectionClasses.FLOW))) {
            return false;
        }
        if (startTerminal != null && startTerminal.e != null && startTerminal.e.getElementClass().getId().equals(ValveFactory.class.getSimpleName())) {
            return false;
        }
        return endTerminal == null || endTerminal.e == null || !endTerminal.e.getElementClass().getId().equals(ValveFactory.class.getSimpleName());
    }

    private void createValveAndConnections(WriteGraph graph, ConnectionJudgement judgment, Deque<ControlPoint> controlPoints, TerminalUtil.TerminalInfo startTerminal, TerminalUtil.TerminalInfo endTerminal) throws DatabaseException {
        ControlPoint cpfirst = controlPoints.getFirst();
        ControlPoint cplast = controlPoints.getLast();
        double startX = cpfirst.getPosition().getX();
        double startY = cpfirst.getPosition().getY();
        double x = cplast.getPosition().getX();
        double y = cplast.getPosition().getY();
        Point2D.Double pos = new Point2D.Double(startX - (startX - x) / 2.0, startY - (startY - y) / 2.0);
        controlPoints.getLast().setPosition((Point2D)pos);
        TerminalUtil.TerminalInfo newValve = this.createConnection(graph, judgment, controlPoints, startTerminal, null, true);
        controlPoints.getLast().setPosition(x, y);
        this.createConnection(graph, judgment, controlPoints, newValve, endTerminal, false);
    }
}

