/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.editor;

import gnu.trove.TIntIntHashMap;
import java.util.Collection;
import java.util.HashMap;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.URIStringUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.mapping.constraint.instructions.TypedBracketInstruction;
import org.simantics.modeling.services.ComponentNamingUtil;
import org.simantics.modeling.services.NamingException;
import org.simantics.operation.Layer0X;
import org.simantics.project.IProject;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.elements.ShadowVariableReferenceDialogRunnable;
import org.simantics.utils.threads.SWTThread;

public class SysdynCreationInstruction
extends TypedBracketInstruction.CreationInstruction {
    IProject project;
    Resource configurationRoot;
    int lComponentType;
    int lConfiguration;

    public SysdynCreationInstruction(IProject project, Resource configurationRoot, int variableId, int componentType, int configuration) {
        super(variableId);
        this.project = project;
        this.configurationRoot = configurationRoot;
        this.lComponentType = componentType;
        this.lConfiguration = configuration;
    }

    public Resource create(WriteGraph g, Object[] bindings) throws DatabaseException {
        Resource componentType = (Resource)bindings[this.lComponentType];
        Resource configuration = (Resource)bindings[this.lConfiguration];
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)g);
        try {
            String proposition = URIStringUtils.escape((String)ComponentNamingUtil.findFreshInstanceName((ReadGraph)g, (IProject)this.project, (Resource)configuration, (Resource)configuration, (Resource)componentType));
            Resource result = GraphUtils.create((WriteGraph)g, (Object[])new Object[]{l0.HasName, proposition});
            g.claim(result, L0X.Represents, result);
            SysdynResource SR = SysdynResource.getInstance((ReadGraph)g);
            g.claim(result, SR.IndependentVariable_isUninitialized, result);
            if (SR.Shadow.equals(componentType)) {
                Layer0 L0 = Layer0.getInstance((ReadGraph)g);
                Collection referrableVariables = (Collection)g.syncRequest((Read)new ObjectsWithType(configuration, L0.ConsistsOf, SR.IndependentVariable));
                referrableVariables.addAll((Collection)g.syncRequest((Read)new ObjectsWithType(configuration, L0.ConsistsOf, SR.Input)));
                HashMap<String, Resource> names = new HashMap<String, Resource>();
                for (Resource var : referrableVariables) {
                    String name = NameUtils.getSafeName((ReadGraph)g, (Resource)var);
                    names.put(name, var);
                }
                SWTThread.getThreadAccess().asyncExec((Runnable)new ShadowVariableReferenceDialogRunnable(result, names));
            }
            return result;
        }
        catch (NamingException e1) {
            throw new DatabaseException((Throwable)e1);
        }
    }

    public void mapVariables(TIntIntHashMap map) {
        super.mapVariables(map);
        this.lComponentType = map.get(this.lComponentType);
        this.lConfiguration = map.get(this.lConfiguration);
    }
}

