/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.browser.nodes;

import org.simantics.browsing.ui.common.node.DeleteException;
import org.simantics.browsing.ui.common.node.IDeletableNode;
import org.simantics.browsing.ui.common.node.IDropTargetNode;
import org.simantics.browsing.ui.common.node.IModifiableNode;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.graph.impl.LabelModifier;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.browser.nodes.VariableNode;
import org.simantics.sysdyn.ui.utils.FunctionNameValidator;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.utils.ResourceAdaptionUtils;

public class FunctionNode
extends VariableNode<Resource>
implements IDeletableNode,
IModifiableNode,
IDropTargetNode {
    public FunctionNode(Resource resource) {
        super(resource);
    }

    @Override
    public Labeler.Modifier getModifier(String columnId) {
        try {
            Resource hasName = Layer0.getInstance((RequestProcessor)SimanticsUI.getSession()).HasName;
            LabelModifier modifier = new LabelModifier(SimanticsUI.getSession(), (Resource)this.data, hasName){

                public String isValid(String label) {
                    if (!new FunctionNameValidator().isValid((Resource)FunctionNode.this.data, label)) {
                        return "Not valid";
                    }
                    return null;
                }
            };
            return modifier;
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void delete() throws DeleteException {
        SimanticsUI.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                RemoverUtil.remove((WriteGraph)graph, (Resource)((Resource)FunctionNode.this.data));
            }
        });
    }

    public void drop(Object data) {
        final Resource[] resources = ResourceAdaptionUtils.toResources((Object)data);
        final Resource thisFunction = (Resource)this.data;
        if (resources.length > 0) {
            SimanticsUI.getSession().asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    Resource library = null;
                    Resource[] resourceArray = resources;
                    int n = resources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Resource tobeMoved = resourceArray[n2];
                        if (graph.isInstanceOf(tobeMoved, sr.SysdynModelicaFunction) || graph.isInstanceOf(tobeMoved, sr.SysdynModelicaFunctionLibrary)) {
                            if (library == null) {
                                library = graph.getSingleObject(thisFunction, l0.PartOf);
                            }
                            graph.deny(tobeMoved, l0.PartOf);
                            graph.claim(tobeMoved, l0.PartOf, library);
                        }
                        ++n2;
                    }
                }
            });
        }
    }
}

