/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.browser.nodes;

import java.util.Collection;
import org.simantics.browsing.ui.common.node.AbstractNode;
import org.simantics.browsing.ui.common.node.DeleteException;
import org.simantics.browsing.ui.common.node.IDeletableNode;
import org.simantics.browsing.ui.common.node.IDoubleClickableNode;
import org.simantics.browsing.ui.common.node.IModifiableNode;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.graph.impl.LabelModifier;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.project.IProject;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.browser.nodes.SimulationResultNode;
import org.simantics.sysdyn.ui.browser.nodes.SimulationResultSetNode;
import org.simantics.sysdyn.ui.handlers.SysdynExperimentActivator;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ExceptionUtils;

public class ExperimentNode
extends AbstractNode<Resource>
implements IDoubleClickableNode,
IDeletableNode,
IModifiableNode {
    public ExperimentNode(Resource resource) {
        super((Object)resource);
    }

    public boolean handleDoubleClick() {
        if (this.data == null) {
            return false;
        }
        IProject project = SimanticsUI.getProject();
        IExperimentManager experimentManager = (IExperimentManager)project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        if (experimentManager == null) {
            ErrorLogger.defaultLogWarning((String)"Experiment manager not available.", (Throwable)new Exception());
            return false;
        }
        SysdynExperimentActivator.scheduleActivation((RequestProcessor)SimanticsUI.getSession(), project, experimentManager, (Resource)this.data);
        return true;
    }

    public Labeler.Modifier getModifier(String columnId) {
        LabelModifier modifier = new LabelModifier(SimanticsUI.getSession(), (Resource)this.data){

            public String isValid(String label) {
                if (label.isEmpty()) {
                    return "Empty label not allowed";
                }
                return null;
            }
        };
        return modifier;
    }

    public void delete() throws DeleteException {
        try {
            SimanticsUI.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException, CancelTransactionException {
                    Collection resultSets;
                    Collection results = graph.getObjects((Resource)ExperimentNode.this.data, SysdynResource.getInstance((ReadGraph)graph).Experiment_result);
                    if (results != null) {
                        for (Resource result : results) {
                            SimulationResultNode.unlinkResult(graph, result);
                        }
                    }
                    if ((resultSets = graph.getObjects((Resource)ExperimentNode.this.data, SysdynResource.getInstance((ReadGraph)graph).Experiment_resultSet)) != null) {
                        for (Resource resultSet : resultSets) {
                            SimulationResultSetNode.unlinkResultSet(graph, resultSet);
                        }
                    }
                    String ontologyName = (String)graph.getPossibleRelatedValue2((Resource)ExperimentNode.this.data, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING);
                    RemoverUtil.remove((WriteGraph)graph, (Resource)((Resource)ExperimentNode.this.data));
                    Layer0Utils.addCommentMetadata((WriteGraph)graph, (String)("Removed experiment " + ontologyName + " " + ((Resource)ExperimentNode.this.data).toString()));
                }
            });
        }
        catch (DatabaseException e) {
            ExceptionUtils.logAndShowError((Throwable)e);
        }
    }
}

