/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.Log;

public class JDBCXYDataset
extends AbstractXYDataset
implements XYDataset,
TableXYDataset,
RangeInfo {
    private transient Connection connection;
    private String[] columnNames = new String[0];
    private ArrayList rows = new ArrayList();
    private double maxValue = 0.0;
    private double minValue = 0.0;
    private boolean isTimeSeries = false;

    private JDBCXYDataset() {
    }

    public JDBCXYDataset(String url, String driverName, String user, String password) throws SQLException, ClassNotFoundException {
        this();
        Class.forName(driverName);
        this.connection = DriverManager.getConnection(url, user, password);
    }

    public JDBCXYDataset(Connection con) throws SQLException {
        this();
        this.connection = con;
    }

    public JDBCXYDataset(Connection con, String query) throws SQLException {
        this(con);
        this.executeQuery(query);
    }

    public boolean isTimeSeries() {
        return this.isTimeSeries;
    }

    public void setTimeSeries(boolean timeSeries) {
        this.isTimeSeries = timeSeries;
    }

    public void executeQuery(String query) throws SQLException {
        this.executeQuery(this.connection, query);
    }

    public void executeQuery(Connection con, String query) throws SQLException {
        if (con == null) {
            throw new SQLException("There is no database to execute the query.");
        }
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            statement = con.createStatement();
            resultSet = statement.executeQuery(query);
            ResultSetMetaData metaData = resultSet.getMetaData();
            int numberOfColumns = metaData.getColumnCount();
            int numberOfValidColumns = 0;
            int[] columnTypes = new int[numberOfColumns];
            int column = 0;
            while (column < numberOfColumns) {
                try {
                    int type = metaData.getColumnType(column + 1);
                    switch (type) {
                        case -7: 
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 91: 
                        case 92: 
                        case 93: {
                            ++numberOfValidColumns;
                            columnTypes[column] = type;
                            break;
                        }
                        default: {
                            Log.warn((Object)("Unable to load column " + column + " (" + type + "," + metaData.getColumnClassName(column + 1) + ")"));
                            columnTypes[column] = 0;
                            break;
                        }
                    }
                }
                catch (SQLException e) {
                    columnTypes[column] = 0;
                    throw e;
                }
                ++column;
            }
            if (numberOfValidColumns <= 1) {
                throw new SQLException("Not enough valid columns where generated by query.");
            }
            this.columnNames = new String[numberOfValidColumns - 1];
            int currentColumn = 0;
            int column2 = 1;
            while (column2 < numberOfColumns) {
                if (columnTypes[column2] != 0) {
                    this.columnNames[currentColumn] = metaData.getColumnLabel(column2 + 1);
                    ++currentColumn;
                }
                ++column2;
            }
            if (this.rows != null) {
                column2 = 0;
                while (column2 < this.rows.size()) {
                    ArrayList row = (ArrayList)this.rows.get(column2);
                    row.clear();
                    ++column2;
                }
                this.rows.clear();
            }
            switch (columnTypes[0]) {
                case 91: 
                case 92: 
                case 93: {
                    this.isTimeSeries = true;
                    break;
                }
                default: {
                    this.isTimeSeries = false;
                    break;
                }
            }
            while (resultSet.next()) {
                ArrayList<Object> newRow = new ArrayList<Object>();
                int column3 = 0;
                while (column3 < numberOfColumns) {
                    Object xObject = resultSet.getObject(column3 + 1);
                    switch (columnTypes[column3]) {
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            newRow.add(xObject);
                            break;
                        }
                        case 91: 
                        case 92: 
                        case 93: {
                            newRow.add(new Long(((Date)xObject).getTime()));
                            break;
                        }
                        case 0: {
                            break;
                        }
                        default: {
                            System.err.println("Unknown data");
                            columnTypes[column3] = 0;
                        }
                    }
                    ++column3;
                }
                this.rows.add(newRow);
            }
            if (this.rows.size() == 0) {
                ArrayList<Integer> newRow = new ArrayList<Integer>();
                int column4 = 0;
                while (column4 < numberOfColumns) {
                    if (columnTypes[column4] != 0) {
                        newRow.add(new Integer(0));
                    }
                    ++column4;
                }
                this.rows.add(newRow);
            }
            if (this.rows.size() < 1) {
                this.maxValue = 0.0;
                this.minValue = 0.0;
            } else {
                ArrayList row = (ArrayList)this.rows.get(0);
                this.maxValue = Double.NEGATIVE_INFINITY;
                this.minValue = Double.POSITIVE_INFINITY;
                int rowNum = 0;
                while (rowNum < this.rows.size()) {
                    row = (ArrayList)this.rows.get(rowNum);
                    int column5 = 1;
                    while (column5 < numberOfColumns) {
                        Object testValue = row.get(column5);
                        if (testValue != null) {
                            double test = ((Number)testValue).doubleValue();
                            if (test < this.minValue) {
                                this.minValue = test;
                            }
                            if (test > this.maxValue) {
                                this.maxValue = test;
                            }
                        }
                        ++column5;
                    }
                    ++rowNum;
                }
            }
            this.fireDatasetChanged();
        }
        catch (Throwable throwable) {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public Number getX(int seriesIndex, int itemIndex) {
        ArrayList row = (ArrayList)this.rows.get(itemIndex);
        return (Number)row.get(0);
    }

    @Override
    public Number getY(int seriesIndex, int itemIndex) {
        ArrayList row = (ArrayList)this.rows.get(itemIndex);
        return (Number)row.get(seriesIndex + 1);
    }

    @Override
    public int getItemCount(int seriesIndex) {
        return this.rows.size();
    }

    @Override
    public int getItemCount() {
        return this.getItemCount(0);
    }

    @Override
    public int getSeriesCount() {
        return this.columnNames.length;
    }

    @Override
    public Comparable getSeriesKey(int seriesIndex) {
        if (seriesIndex < this.columnNames.length && this.columnNames[seriesIndex] != null) {
            return this.columnNames[seriesIndex];
        }
        return "";
    }

    public int getLegendItemCount() {
        return this.getSeriesCount();
    }

    public String[] getLegendItemLabels() {
        return this.columnNames;
    }

    public void close() {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            System.err.println("JdbcXYDataset: swallowing exception.");
        }
    }

    @Override
    public double getRangeLowerBound(boolean includeInterval) {
        return this.minValue;
    }

    @Override
    public double getRangeUpperBound(boolean includeInterval) {
        return this.maxValue;
    }

    @Override
    public Range getRangeBounds(boolean includeInterval) {
        return new Range(this.minValue, this.maxValue);
    }
}

