/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;

public class XYSplineRenderer
extends XYLineAndShapeRenderer {
    private Vector points;
    private int precision;

    public XYSplineRenderer() {
        this(5);
    }

    public XYSplineRenderer(int precision) {
        if (precision <= 0) {
            throw new IllegalArgumentException("Requires precision > 0.");
        }
        this.precision = precision;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int p) {
        if (p <= 0) {
            throw new IllegalArgumentException("Requires p > 0.");
        }
        this.precision = p;
        this.fireChangeEvent();
    }

    @Override
    public XYItemRendererState initialise(Graphics2D g2, Rectangle2D dataArea, XYPlot plot, XYDataset data, PlotRenderingInfo info) {
        XYLineAndShapeRenderer.State state = (XYLineAndShapeRenderer.State)super.initialise(g2, dataArea, plot, data, info);
        state.setProcessVisibleItemsOnly(false);
        this.points = new Vector();
        this.setDrawSeriesLineAsPath(true);
        return state;
    }

    @Override
    protected void drawPrimaryLineAsPath(XYItemRendererState state, Graphics2D g2, XYPlot plot, XYDataset dataset, int pass, int series, int item, ValueAxis domainAxis, ValueAxis rangeAxis, Rectangle2D dataArea) {
        ControlPoint p;
        RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
        RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
        double x1 = dataset.getXValue(series, item);
        double y1 = dataset.getYValue(series, item);
        double transX1 = domainAxis.valueToJava2D(x1, dataArea, xAxisLocation);
        double transY1 = rangeAxis.valueToJava2D(y1, dataArea, yAxisLocation);
        if (!(Double.isNaN(transX1) || Double.isNaN(transY1) || this.points.contains(p = new ControlPoint(plot.getOrientation() == PlotOrientation.HORIZONTAL ? (float)transY1 : (float)transX1, plot.getOrientation() == PlotOrientation.HORIZONTAL ? (float)transX1 : (float)transY1)))) {
            this.points.add(p);
        }
        if (item == dataset.getItemCount(series) - 1) {
            XYLineAndShapeRenderer.State s = (XYLineAndShapeRenderer.State)state;
            if (this.points.size() > 1) {
                ControlPoint cp0 = (ControlPoint)this.points.get(0);
                s.seriesPath.moveTo(cp0.x, cp0.y);
                if (this.points.size() == 2) {
                    ControlPoint cp1 = (ControlPoint)this.points.get(1);
                    s.seriesPath.lineTo(cp1.x, cp1.y);
                } else {
                    int np = this.points.size();
                    float[] d = new float[np];
                    float[] x = new float[np];
                    float oldy = 0.0f;
                    float oldt = 0.0f;
                    float[] a = new float[np];
                    float[] h = new float[np];
                    int i = 0;
                    while (i < np) {
                        ControlPoint cpi = (ControlPoint)this.points.get(i);
                        x[i] = cpi.x;
                        d[i] = cpi.y;
                        ++i;
                    }
                    i = 1;
                    while (i <= np - 1) {
                        h[i] = x[i] - x[i - 1];
                        ++i;
                    }
                    float[] sub = new float[np - 1];
                    float[] diag = new float[np - 1];
                    float[] sup = new float[np - 1];
                    int i2 = 1;
                    while (i2 <= np - 2) {
                        diag[i2] = (h[i2] + h[i2 + 1]) / 3.0f;
                        sup[i2] = h[i2 + 1] / 6.0f;
                        sub[i2] = h[i2] / 6.0f;
                        a[i2] = (d[i2 + 1] - d[i2]) / h[i2 + 1] - (d[i2] - d[i2 - 1]) / h[i2];
                        ++i2;
                    }
                    this.solveTridiag(sub, diag, sup, a, np - 2);
                    oldt = x[0];
                    oldy = d[0];
                    s.seriesPath.moveTo(oldt, oldy);
                    i2 = 1;
                    while (i2 <= np - 1) {
                        int j = 1;
                        while (j <= this.precision) {
                            float t1 = h[i2] * (float)j / (float)this.precision;
                            float t2 = h[i2] - t1;
                            float y = ((-a[i2 - 1] / 6.0f * (t2 + h[i2]) * t1 + d[i2 - 1]) * t2 + (-a[i2] / 6.0f * (t1 + h[i2]) * t2 + d[i2]) * t1) / h[i2];
                            float t = x[i2 - 1] + t1;
                            s.seriesPath.lineTo(t, y);
                            oldt = t;
                            oldy = y;
                            ++j;
                        }
                        ++i2;
                    }
                }
                this.drawFirstPassShape(g2, pass, series, item, s.seriesPath);
            }
            this.points = new Vector();
        }
    }

    private void solveTridiag(float[] sub, float[] diag, float[] sup, float[] b, int n) {
        int i = 2;
        while (i <= n) {
            sub[i] = sub[i] / diag[i - 1];
            diag[i] = diag[i] - sub[i] * sup[i - 1];
            b[i] = b[i] - sub[i] * b[i - 1];
            ++i;
        }
        b[n] = b[n] / diag[n];
        i = n - 1;
        while (i >= 1) {
            b[i] = (b[i] - sup[i] * b[i + 1]) / diag[i];
            --i;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XYSplineRenderer)) {
            return false;
        }
        XYSplineRenderer that = (XYSplineRenderer)obj;
        if (this.precision != that.precision) {
            return false;
        }
        return super.equals(obj);
    }

    class ControlPoint {
        public float x;
        public float y;

        public ControlPoint(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ControlPoint)) {
                return false;
            }
            ControlPoint that = (ControlPoint)obj;
            return this.x == that.x;
        }
    }
}

