/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.common;

import java.util.concurrent.atomic.AtomicReference;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceAsyncRead;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.issues.Severity;
import org.simantics.issues.ontology.IssueResource;

public class MaxIssueSeveritySingle
extends ResourceAsyncRead<Severity> {
    public MaxIssueSeveritySingle(Resource resource) {
        super(resource);
    }

    public void perform(AsyncReadGraph graph, final AsyncProcedure<Severity> procedure) {
        final IssueResource ISSUE = (IssueResource)graph.getService(IssueResource.class);
        graph.forEachObject(this.resource, ISSUE.Issue_HasContext_Inverse, (AsyncMultiProcedure)new AsyncMultiProcedure<Resource>(){
            AtomicReference<Severity> maxSeverity = new AtomicReference();

            public void execute(AsyncReadGraph graph, Resource issue) {
                MaxIssueSeveritySingle.this.acceptIfNotResolved(graph, (AsyncProcedure<Severity>)procedure, ISSUE, issue, this.maxSeverity);
            }

            public void finished(AsyncReadGraph graph) {
                procedure.execute(graph, (Object)this.maxSeverity.get());
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                procedure.exception(graph, throwable);
            }
        });
    }

    private void acceptIfNotResolved(AsyncReadGraph graph, final AsyncProcedure<Severity> procedure, final IssueResource ISSUE, final Resource issue, final AtomicReference<Severity> maxSeverity) {
        graph.forHasStatement(issue, ISSUE.Resolved, (AsyncProcedure)new AsyncProcedure<Boolean>(){

            public void execute(AsyncReadGraph graph, Boolean resolved) {
                if (resolved.booleanValue()) {
                    return;
                }
                MaxIssueSeveritySingle.this.acceptIfSourceIsActive(graph, (AsyncProcedure<Severity>)procedure, ISSUE, issue, maxSeverity);
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                procedure.exception(graph, throwable);
            }
        });
    }

    private void acceptIfSourceIsActive(AsyncReadGraph graph, final AsyncProcedure<Severity> procedure, final IssueResource ISSUE, final Resource issue, final AtomicReference<Severity> maxSeverity) {
        graph.forPossibleObject(issue, ISSUE.IssueSource_Manages_Inverse, (AsyncProcedure)new AsyncProcedure<Resource>(){

            public void execute(AsyncReadGraph graph, Resource issueSource) {
                if (issueSource != null) {
                    graph.forPossibleRelatedValue(issueSource, ISSUE.IssueSource_active, (AsyncProcedure)new AsyncProcedure<Boolean>(){

                        public void execute(AsyncReadGraph graph, Boolean active) {
                            if (!Boolean.FALSE.equals(active)) {
                                MaxIssueSeveritySingle.this.compareSeverity(graph, (AsyncProcedure<Severity>)procedure, ISSUE, issue, maxSeverity);
                            }
                        }

                        public void exception(AsyncReadGraph graph, Throwable throwable) {
                            procedure.exception(graph, throwable);
                        }
                    });
                }
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                procedure.exception(graph, throwable);
            }
        });
    }

    private void compareSeverity(AsyncReadGraph graph, final AsyncProcedure<Severity> procedure, final IssueResource ISSUE, Resource issue, final AtomicReference<Severity> maxSeverity) {
        graph.forPossibleObject(issue, ISSUE.Issue_HasSeverity, (AsyncProcedure)new AsyncProcedure<Resource>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(AsyncReadGraph graph, Resource severity) {
                if (severity != null) {
                    AtomicReference atomicReference = maxSeverity;
                    synchronized (atomicReference) {
                        maxSeverity.set(Severity.moreSevere((Severity)((Severity)maxSeverity.get()), (Severity)MaxIssueSeveritySingle.toSeverity(ISSUE, severity)));
                    }
                }
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                procedure.exception(graph, throwable);
            }
        });
    }

    private static Severity toSeverity(IssueResource ISSUE, Resource severity) {
        if (ISSUE.Severity_Fatal.equals(severity)) {
            return Severity.FATAL;
        }
        if (ISSUE.Severity_Error.equals(severity)) {
            return Severity.ERROR;
        }
        if (ISSUE.Severity_Warning.equals(severity)) {
            return Severity.WARNING;
        }
        if (ISSUE.Severity_Info.equals(severity)) {
            return Severity.INFO;
        }
        if (ISSUE.Severity_Note.equals(severity)) {
            return Severity.NOTE;
        }
        return null;
    }
}

