/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.common;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.QuaternaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.issues.Severity;
import org.simantics.issues.common.IssueUtils;
import org.simantics.issues.common.preferences.IssuePrefs;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;

public class ListModelIssuesBySeverity
extends QuaternaryRead<Resource, Boolean, Boolean, Severity, Map<Severity, List<Resource>>> {
    public ListModelIssuesBySeverity(Resource model, boolean onlyUnresolved, boolean respectVisibility, Severity minSeverity) {
        super((Object)model, (Object)onlyUnresolved, (Object)respectVisibility, (Object)minSeverity);
    }

    public Map<Severity, List<Resource>> perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        Severity[] keys = Severity.values();
        List[] values = new List[keys.length];
        Resource project = Simantics.getProjectResource();
        boolean showHidden = false;
        boolean showNormal = true;
        boolean showUser = true;
        if (((Boolean)this.parameter3).booleanValue() && project != null) {
            showHidden = IssuePrefs.showHiddenIssues(graph, project);
            showNormal = IssuePrefs.showNormalIssues(graph, project);
            showUser = IssuePrefs.showUserIssues(graph, project);
        }
        boolean ignoreResolved = (Boolean)this.parameter2;
        for (Resource issue : (Collection)graph.syncRequest((Read)new ObjectsWithType((Resource)this.parameter, L0.ConsistsOf, ISSUE.Issue))) {
            Severity s;
            boolean normal;
            if (ignoreResolved && graph.hasStatement(issue, ISSUE.Resolved)) continue;
            boolean hidden = graph.hasStatement(issue, ISSUE.Hidden);
            boolean user = graph.hasStatement(issue, ISSUE.UserIssue);
            boolean bl = normal = !hidden && !user;
            if (!showHidden && hidden || !showUser && user || !showNormal && normal || (s = IssueUtils.toSeverity(ISSUE, graph.getPossibleObject(issue, ISSUE.Issue_HasSeverity))) == null || s.compareTo((Enum)((Severity)this.parameter4)) > 0) continue;
            int index = s.ordinal();
            ArrayList<Resource> list = values[index];
            if (list == null) {
                list = values[index] = new ArrayList<Resource>();
            }
            list.add(issue);
        }
        THashMap result = new THashMap(values.length);
        int i = 0;
        while (i < values.length) {
            if (values[i] != null) {
                result.put((Object)keys[i], (Object)values[i]);
            }
            ++i;
        }
        return result;
    }
}

