/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.common;

import java.util.HashSet;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead2;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.issues.common.AllVisibleIssues;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;

public class IssuesOfSeverity
extends ResourceRead2<Set<Variable>> {
    public IssuesOfSeverity(Resource project, Resource expectedSeverity) {
        super(project, expectedSeverity);
    }

    protected Resource getExpectedSeverity(ReadGraph graph, IssueResource issue) {
        return this.resource2;
    }

    public Set<Variable> perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        HashSet<Variable> result = new HashSet<Variable>();
        Resource expectedSeverity = this.getExpectedSeverity(graph, ISSUE);
        String expectedSeverityName = (String)graph.getRelatedValue(expectedSeverity, L0.HasName, (Binding)Bindings.STRING);
        assert (expectedSeverity != null);
        for (Variable issue : (Set)graph.syncRequest((Read)new AllVisibleIssues(this.resource))) {
            if (!expectedSeverityName.equals(issue.getPossiblePropertyValue(graph, "severity"))) continue;
            result.add(issue);
        }
        return result;
    }

    public static IssuesOfSeverity error(ReadGraph graph, Resource resource) {
        return new IssuesOfSeverity(resource, IssueResource.getInstance((ReadGraph)graph).Severity_Error);
    }

    public static IssuesOfSeverity warning(ReadGraph graph, Resource resource) {
        return new IssuesOfSeverity(resource, IssueResource.getInstance((ReadGraph)graph).Severity_Warning);
    }

    public static IssuesOfSeverity fatal(ReadGraph graph, Resource resource) {
        return new IssuesOfSeverity(resource, IssueResource.getInstance((ReadGraph)graph).Severity_Fatal);
    }

    public static IssuesOfSeverity info(ReadGraph graph, Resource resource) {
        return new IssuesOfSeverity(resource, IssueResource.getInstance((ReadGraph)graph).Severity_Info);
    }

    public static IssuesOfSeverity note(ReadGraph graph, Resource resource) {
        return new IssuesOfSeverity(resource, IssueResource.getInstance((ReadGraph)graph).Severity_Note);
    }
}

