/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.common;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ChangeSetIdentifier;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.ResourceSet;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.DependentInstances3;
import org.simantics.db.common.request.ResourceSetGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.changeset.MetadataUtils;
import org.simantics.db.layer0.genericrelation.DependencyChanges;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.service.CollectionSupport;
import org.simantics.db.service.ManagementSupport;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.issues.ontology.IssueResource;

public class IssueSourceUtils {
    public static final boolean DEBUG = false;

    private static long largest(Collection<ChangeSetIdentifier> csis) {
        long largest = 0L;
        for (ChangeSetIdentifier csi : csis) {
            if (csi.getId() <= largest) continue;
            largest = csi.getId();
        }
        return largest;
    }

    public static WriteRequest getUpdateRequest(WriteGraph graph, final Resource source) throws DatabaseException {
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        ManagementSupport support = (ManagementSupport)graph.getService(ManagementSupport.class);
        Long revisionId = (Long)graph.getPossibleRelatedValue(source, ISSUE.ContinuousIssueSource_lastUpdateRevision, (Binding)Bindings.LONG);
        if (revisionId == null) {
            revisionId = 0L;
        }
        Collection csis = support.getChangeSets(revisionId.longValue(), Long.MAX_VALUE);
        final long largest = IssueSourceUtils.largest(csis);
        if (revisionId < largest - 2L) {
            VirtualGraphSupport vgs = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
            VirtualGraph vg = vgs.getWorkspacePersistent("issues");
            return new WriteRequest(vg){

                public void perform(WriteGraph graph) throws DatabaseException {
                    IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
                    graph.claimLiteral(source, ISSUE.ContinuousIssueSource_lastUpdateRevision, (Object)(largest - 2L), (Binding)Bindings.LONG);
                }
            };
        }
        return null;
    }

    public static boolean hasChanges(ReadGraph graph, DependencyChanges event, Resource root, Resource from) throws DatabaseException {
        DependencyChanges.Change[] changes = event.get(root);
        if (changes == null) {
            return false;
        }
        DependencyChanges.Change[] changeArray = changes;
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            DependencyChanges.Change c = changeArray[n2];
            if (c instanceof DependencyChanges.ComponentAddition) {
                return true;
            }
            if (c instanceof DependencyChanges.ComponentRemoval) {
                return true;
            }
            if (c instanceof DependencyChanges.ComponentModification) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static void test(ReadGraph graph, Resource component, ResourceSet types, Collection<Resource> result) throws DatabaseException {
        Collection data = (Collection)graph.syncRequest((Read)new Test3(component, types), (AsyncProcedure)TransientCacheAsyncListener.instance());
        result.addAll(data);
    }

    public static Set<Resource> getChangedDependencies(ReadGraph graph, Resource model, Resource from, Set<Resource> types, DependencyChanges event) throws DatabaseException {
        DependencyChanges.Change[] changes = event.get(model);
        if (changes == null) {
            return Collections.emptySet();
        }
        CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
        ResourceSet typeSet = cs.getResourceSet(graph, types);
        HashSet<Resource> result = new HashSet<Resource>();
        DependencyChanges.Change[] changeArray = changes;
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            DependencyChanges.Change c = changeArray[n2];
            IssueSourceUtils.processChange(graph, c, typeSet, result);
            ++n2;
        }
        return result;
    }

    public static void processChange(ReadGraph graph, DependencyChanges.Change c, ResourceSet types, Set<Resource> result) throws DatabaseException {
        if (c instanceof DependencyChanges.ComponentAddition) {
            DependencyChanges.ComponentAddition addition = (DependencyChanges.ComponentAddition)c;
            IssueSourceUtils.test(graph, addition.component, types, result);
        } else if (c instanceof DependencyChanges.ComponentRemoval) {
            DependencyChanges.ComponentRemoval removal = (DependencyChanges.ComponentRemoval)c;
            result.add(removal.component);
        } else if (c instanceof DependencyChanges.ComponentModification) {
            DependencyChanges.ComponentModification modification = (DependencyChanges.ComponentModification)c;
            IssueSourceUtils.test(graph, modification.component, types, result);
        }
    }

    public static Set<Resource> getChangedDependencies(ReadGraph graph, Resource source, Resource model, Resource from, Set<Resource> types) throws DatabaseException {
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        Long revisionId = (Long)graph.getPossibleRelatedValue(source, ISSUE.ContinuousIssueSource_lastUpdateRevision, (Binding)Bindings.LONG);
        if (revisionId == null) {
            revisionId = 0L;
        }
        Map index = MetadataUtils.getDependencyChangesFrom((ReadGraph)graph, (long)revisionId);
        CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
        ResourceSet typeSet = cs.getResourceSet(graph, types);
        Collection modelChanges = (Collection)index.get(model);
        if (modelChanges == null) {
            return Collections.emptySet();
        }
        HashSet<Resource> result = new HashSet<Resource>();
        for (DependencyChanges.Change c : modelChanges) {
            IssueSourceUtils.processChange(graph, c, typeSet, result);
        }
        return result;
    }

    public static class Test3
    extends BinaryRead<Resource, ResourceSet, Collection<Resource>> {
        public Test3(Resource component, ResourceSet types) {
            super((Object)component, (Object)types);
        }

        public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
            ResourceSetGraph rsg = (ResourceSetGraph)graph.syncRequest((Read)new DependentInstances3((Resource)this.parameter), (Listener)TransientCacheListener.instance());
            return rsg.resolve(graph, (ResourceSet)this.parameter2);
        }
    }
}

