/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.common;

import java.util.HashSet;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.issues.ontology.IssueResource;

public class IssueContexts
extends UnaryRead<Set<Variable>, Set<Resource>> {
    public IssueContexts(Set<Variable> variables) {
        super(variables);
    }

    public Set<Resource> perform(ReadGraph graph) throws DatabaseException {
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        HashSet<Resource> result = new HashSet<Resource>(((Set)this.parameter).size());
        for (Variable issue : (Set)this.parameter) {
            Resource issueResource = issue.getRepresents(graph);
            result.addAll(graph.getObjects(issueResource, ISSUE.Issue_HasContext));
            Resource list = graph.getPossibleObject(issueResource, ISSUE.Issue_HasContexts);
            if (list == null) continue;
            result.addAll(ListUtils.toList((ReadGraph)graph, (Resource)list));
        }
        return result;
    }
}

