/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.Issue;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.DeepObjectsWithType;
import org.simantics.db.common.utils.Functions;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.ReadInterface;
import org.simantics.issues.common.BatchIssueSource;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;

public class DependencyTrackerBatchIssueSource
implements BatchIssueSource {
    final Resource source;

    public DependencyTrackerBatchIssueSource(Resource source) {
        this.source = source;
    }

    @Override
    public Map<Resource, Set<Issue>> run(IProgressMonitor monitor, ReadGraph graph, Collection<Resource> contexts) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        IssueResource IR = IssueResource.getInstance((ReadGraph)graph);
        Resource constraint = graph.getSingleObject(this.source, IR.Sources_DependencyTracker_HasConstraint);
        Resource type = graph.getSingleObject(constraint, L0.HasConstraint_Inverse);
        Resource function = graph.getSingleObject(constraint, L0.Constraint_Validator);
        HashMap<Resource, Set<Issue>> result = new HashMap<Resource, Set<Issue>>();
        for (Resource context : contexts) {
            for (Resource child : (Collection)graph.sync((ReadInterface)new DeepObjectsWithType(context, L0.ConsistsOf, type))) {
                HashSet cs = new HashSet((List)Functions.exec((RequestProcessor)graph, (Resource)function, (Object[])new Object[]{graph, child}));
                result.put(child, cs);
            }
        }
        return result;
    }

    @Override
    public Resource getResource() {
        return this.source;
    }
}

