/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.common;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.simantics.db.Issue;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.issues.common.DependencyIssueValidator2;
import org.simantics.issues.common.IssueByList;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;

public class DependencyIssueSynchronizer2
extends WriteRequest {
    public static final boolean DEBUG = false;
    private Resource resource;
    private Resource model;
    private Resource source;

    public DependencyIssueSynchronizer2(Resource resource, Resource model, Resource source) {
        this.resource = resource;
        this.model = model;
        this.source = source;
    }

    public void perform(WriteGraph graph) throws DatabaseException {
        Set existing = (Set)graph.syncRequest((Read)new DependencyIssueValidator2.DependencyIssueDescriptions(this.source, this.resource), (Listener)TransientCacheListener.instance());
        Set contexts = Collections.emptySet();
        if (graph.hasStatement(this.resource)) {
            contexts = (Set)graph.syncRequest((Read)new DependencyIssueValidator2.Contexts(this.source, this.resource), (Listener)TransientCacheListener.instance());
        }
        if (!existing.equals(contexts)) {
            HashSet added = new HashSet(contexts);
            HashSet removed = new HashSet(existing);
            added.removeAll(existing);
            removed.removeAll(contexts);
            for (Issue add : added) {
                add.write(graph, this.source);
            }
            for (Issue remove : removed) {
                Resource issue = (Resource)graph.sync((ReadInterface)new IssueByList(this.source, remove));
                if (issue == null) continue;
                graph.deny(issue, Layer0.getInstance((ReadGraph)graph).PartOf);
                graph.deny(this.source, IssueResource.getInstance((ReadGraph)graph).IssueSource_Manages, issue);
                RemoverUtil.remove((WriteGraph)graph, (Resource)issue);
            }
        }
    }
}

