/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.common;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.issues.common.preferences.IssuePrefs;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.simulation.ontology.SimulationResource;

public class AllVisibleIssues
extends BinaryRead<Resource, Boolean, Set<Variable>> {
    public AllVisibleIssues(Resource project) {
        super((Object)project, (Object)Boolean.FALSE);
    }

    public AllVisibleIssues(Resource project, boolean onlyUnresolved) {
        super((Object)project, (Object)onlyUnresolved);
    }

    public Set<Variable> perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        Resource project = Simantics.getProjectResource();
        boolean showHidden = false;
        boolean showNormal = true;
        boolean showUser = true;
        if (project != null) {
            showHidden = IssuePrefs.showHiddenIssues(graph, project);
            showNormal = IssuePrefs.showNormalIssues(graph, project);
            showUser = IssuePrefs.showUserIssues(graph, project);
        }
        HashSet<Variable> result = new HashSet<Variable>();
        for (Resource model : (Collection)graph.syncRequest((Read)new ObjectsWithType((Resource)this.parameter, L0X.Activates, SIMU.Model))) {
            for (Resource issue : (Collection)graph.syncRequest((Read)new ObjectsWithType(model, L0.ConsistsOf, ISSUE.Issue))) {
                Variable var;
                Resource source;
                boolean normal;
                boolean resolved = graph.hasStatement(issue, ISSUE.Resolved);
                if (((Boolean)this.parameter2).booleanValue() && resolved) continue;
                boolean hidden = graph.hasStatement(issue, ISSUE.Hidden);
                boolean user = graph.hasStatement(issue, ISSUE.UserIssue);
                boolean bl = normal = !hidden && !user;
                if (!showHidden && hidden || !showUser && user || !showNormal && normal || (source = graph.getPossibleObject(issue, ISSUE.IssueSource_Manages_Inverse)) != null && !Boolean.TRUE.equals(graph.getPossibleRelatedValue(source, ISSUE.IssueSource_active)) || (var = Variables.getPossibleVariable((ReadGraph)graph, (Resource)issue)) == null) continue;
                result.add(var);
            }
        }
        return result;
    }
}

